/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.repository;

import org.ametys.cms.data.holder.group.ModifiableIndexableRepeater;
import org.ametys.cms.data.holder.group.ModifiableIndexableRepeaterEntry;
import org.ametys.plugins.forms.repository.type.Rule;
import org.ametys.plugins.repository.data.holder.group.ModifiableModelAwareRepeater;
import org.ametys.plugins.repository.data.holder.group.ModifiableModelAwareRepeaterEntry;

/**
 * Updates copied question rules
 */
public class FormQuestionRuleCopyUpdater extends AbstractFormCopyUpdater
{
    public void updateForm(Form originalForm, Form createdForm)
    {
        boolean hasChanges = false;
        for (FormQuestion originalFormQuestion : originalForm.getQuestions())
        {
            FormQuestion copiedQuestion = _getCopiedQuestion(createdForm, originalFormQuestion);
            hasChanges = _updateFormQuestionsRules(createdForm, originalFormQuestion, copiedQuestion) || hasChanges;
        }
        
        if (hasChanges)
        {
            createdForm.saveChanges();
        }
    }

    private boolean _updateFormQuestionsRules(Form createdForm, FormQuestion originalQuestion, FormQuestion copiedQuestion)
    {
        ModifiableModelAwareRepeater originalRulesRepeater = originalQuestion.getRepeater(FormQuestion.ATTRIBUTE_RULES);
        if (originalRulesRepeater != null)
        {
            ModifiableIndexableRepeater newRepeater = copiedQuestion.getRepeater(FormQuestion.ATTRIBUTE_RULES, true);
            for (ModifiableModelAwareRepeaterEntry repeaterEntry : originalRulesRepeater.getEntries())
            {
                Rule rule = repeaterEntry.getValue(FormQuestion.ATTRIBUTE_RULE);
                String oldSourceId = rule.getSourceId();
                FormQuestion originalSourceQuestion = _resolver.resolveById(oldSourceId);
                FormQuestion copiedSourceQuestion = _getCopiedQuestion(createdForm, originalSourceQuestion);
                rule.setSourceId(copiedSourceQuestion.getId());
                ModifiableIndexableRepeaterEntry newEntry = newRepeater.addEntry();
                newEntry.setValue(FormQuestion.ATTRIBUTE_RULE, rule);
            }
            return true;
        }
        return false;
    }

    public void updateFormPage(FormPage originalFormPage, FormPage createdFormPage)
    {
        //we don't want question rules to be updated when we copy a page
    }

    public void updateFormQuestion(FormQuestion originalFormQuestion, FormQuestion createdFormQuestion)
    {
        if (_updateFormQuestionsRules(createdFormQuestion.getForm(), originalFormQuestion, createdFormQuestion))
        {
            createdFormQuestion.getFormPage().saveChanges();
        }
    }
    
}
