/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.actions;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.plugins.forms.actions.AbstractProcessFormAction;
import org.ametys.plugins.forms.dao.FormQuestionDAO;
import org.ametys.plugins.forms.helper.FormAdminDashboardHelper;
import org.ametys.plugins.forms.question.types.FileQuestionType;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.plugins.repository.data.holder.values.UntouchedValue;
import org.ametys.plugins.repository.provider.RequestAttributeWorkspaceSelector;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.model.ViewItemContainer;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class EditFormEntryAction
extends AbstractProcessFormAction {
    protected FormAdminDashboardHelper _formAdminDashboardHelper;
    protected CurrentUserProvider _currentUserProvider;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._formAdminDashboardHelper = (FormAdminDashboardHelper)((Object)smanager.lookup(FormAdminDashboardHelper.ROLE));
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String currentWsp = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
        try {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)"default");
            String entryId = request.getParameter("entryId");
            if (entryId == null) {
                throw new IllegalStateException("Impossible to edit entry. No id provided.");
            }
            ArrayListMultimap formErrors = ArrayListMultimap.create();
            FormEntry entry = (FormEntry)this._resolver.resolveById(entryId);
            boolean canSubmitterEdit = this._canSubmitterEdit(entry);
            if (!canSubmitterEdit && !this._canManagerEdit(entry)) {
                formErrors.put((Object)"form-access", (Object)new I18nizableText("plugin.forms", "PLUGINS_FORMS_EDIT_FORM_ENTRY_ERRORS"));
                request.setAttribute("form", (Object)entry.getForm());
                request.setAttribute("form-errors", (Object)formErrors);
                Map map = null;
                return map;
            }
            Optional<Long> currentStepId = Optional.of(this._entryDAO.getCurrentStepId(entry));
            View view = View.of((Collection)entry.getModel());
            View filteredEntryView = this._getRuleFilteredEntryView(request, entry.getForm(), view, new FormQuestionDAO.FormEntryValues(null, entry), currentStepId);
            Map values = this._foAmetysObjectCreationHelper.getFormValues(request, (ViewItemContainer)filteredEntryView, "", (Multimap)formErrors);
            this._adaptFormValuesForChoiceList(entry.getForm(), values);
            this._adaptFormValuesForFile(request, entry.getForm(), values);
            HashMap<String, Object> additionalParameters = new HashMap<String, Object>();
            additionalParameters.put("ignoreWriteRestriction", canSubmitterEdit);
            formErrors.putAll(this._foAmetysObjectCreationHelper.validateValues(values, filteredEntryView));
            for (FormQuestion question : entry.getForm().getQuestions()) {
                if (!filteredEntryView.hasModelViewItem(question.getNameForForm())) continue;
                question.getType().validateEntryValues(question, values, (Multimap<String, I18nizableText>)formErrors, currentStepId, additionalParameters);
            }
            if (!formErrors.isEmpty()) {
                request.setAttribute("form", (Object)entry.getForm());
                request.setAttribute("form-errors", (Object)formErrors);
                Iterator<FormQuestion> iterator = null;
                return iterator;
            }
            entry.synchronizeValues((ViewItemAccessor)filteredEntryView, values);
            this._handleComputedValues(entry.getForm().getQuestions(), entry, true);
            entry.saveChanges();
        }
        finally {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWsp);
        }
        return EMPTY_MAP;
    }

    @Override
    protected List<FormQuestion> _getRuleFilteredQuestions(Request request, Form form, FormQuestionDAO.FormEntryValues entryValues, Optional<Long> currentStepId) {
        String isSubmitterAsString = request.getParameter("isSubmitter");
        boolean isSubmitter = StringUtils.isNotBlank((CharSequence)isSubmitterAsString) ? Boolean.valueOf(isSubmitterAsString) : false;
        boolean canSubmitterEdit = isSubmitter && this._canSubmitterEdit(entryValues.entry());
        boolean onlyWritableQuestion = !canSubmitterEdit;
        boolean onlyReadableQuestion = canSubmitterEdit;
        return this._formQuestionDAO.getRuleFilteredQuestions(form, entryValues, currentStepId, onlyWritableQuestion, onlyReadableQuestion);
    }

    private void _adaptFormValuesForFile(Request request, Form form, Map<String, Object> values) {
        List<FormQuestion> fileQuestions = form.getQuestions().stream().filter(q -> q.getType() instanceof FileQuestionType).toList();
        for (FormQuestion question : fileQuestions) {
            String nameForForm = question.getNameForForm();
            String fileInfo = request.getParameter(nameForForm + "-info");
            if (!"untouched".equals(fileInfo)) continue;
            values.put(nameForForm, new UntouchedValue());
        }
    }

    private boolean _canManagerEdit(FormEntry entry) {
        return this._rightManager.currentUserHasRight("Form_Entries_Rights_Data", (Object)entry) == RightManager.RightResult.RIGHT_ALLOW && !this._formAdminDashboardHelper.getAvailableActions(entry, List.of("edit")).isEmpty();
    }

    private boolean _canSubmitterEdit(FormEntry entry) {
        return this._currentUserProvider.getUser().equals((Object)entry.getUser()) && !this._formAdminDashboardHelper.getAvailableActions(entry, List.of("edit-by-submitter")).isEmpty();
    }
}

