/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.content;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.user.User;
import org.ametys.core.user.UserManager;
import org.ametys.plugins.forms.content.Form;
import org.ametys.plugins.forms.content.jcr.FormPropertiesManager;
import org.ametys.plugins.forms.content.table.FormTableManager;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public class GetOrphanFormsAction
extends ServiceableAction {
    private FormPropertiesManager _formPropertiesManager;
    private FormTableManager _formTableManager;
    private UserManager _userManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._formPropertiesManager = (FormPropertiesManager)((Object)serviceManager.lookup(FormPropertiesManager.ROLE));
        this._formTableManager = (FormTableManager)serviceManager.lookup(FormTableManager.ROLE);
        this._userManager = (UserManager)serviceManager.lookup(UserManager.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        HashMap result = new HashMap();
        try {
            String formId = null;
            Form form = null;
            List<String> tableNames = this._formTableManager.getTableNames();
            ArrayList tableList = new ArrayList();
            for (String tableName : tableNames) {
                HashMap<String, Object> table = new HashMap<String, Object>();
                formId = tableName.substring("Forms_".length());
                if (formId.length() == 0) {
                    this.getLogger().error("Find a SQL form table with a empty id '" + tableName + "'. It will be ignored. This table should be deleted manually.");
                    continue;
                }
                form = this._formPropertiesManager.getForm(formId);
                if (form != null) continue;
                Node frozenContentNode = this._formPropertiesManager.getMostRecentFormFrozenContent(formId);
                if (frozenContentNode != null) {
                    String contributorLogin;
                    String contentUUId = frozenContentNode.getProperty("jcr:frozenUuid").getString();
                    String title = frozenContentNode.getProperty("ametys:title").getString();
                    table.put("contentTitle", title);
                    if (frozenContentNode.hasProperty("ametys:site")) {
                        table.put("siteName", frozenContentNode.getProperty("ametys:site").getString());
                    }
                    try {
                        Node contributorNode = frozenContentNode.getNode("ametys:contributor");
                        contributorLogin = contributorNode.getProperty("ametys:login").getString();
                        User user = this._userManager.getUser(contributorNode.getProperty("ametys:population").getString(), contributorNode.getProperty("ametys:login").getString());
                        table.put("lastContributor", user != null ? user.getFullName() : contributorLogin);
                    }
                    catch (PathNotFoundException e) {
                        contributorLogin = frozenContentNode.getProperty("ametys:contributor").getString();
                        table.put("lastContributor", contributorLogin);
                    }
                    boolean stillExists = true;
                    try {
                        frozenContentNode.getSession().getNodeByIdentifier(contentUUId);
                    }
                    catch (ItemNotFoundException e) {
                        stillExists = false;
                    }
                    table.put("stillExists", stillExists);
                }
                table.put("name", tableName);
                table.put("total", Integer.toString(this._formTableManager.getTotalSubmissions(formId)));
                tableList.add(table);
            }
            result.put("tables", tableList);
        }
        catch (Exception e) {
            throw new ProcessingException("An error occurred while retrieving the orphan forms.", (Throwable)e);
        }
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }
}

