/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.content.processing;

import java.io.File;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Map;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.forms.content.Field;
import org.ametys.plugins.forms.content.data.FieldValue;
import org.ametys.plugins.forms.content.jcr.FormPropertiesManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractFormFieldGenerator
extends ServiceableGenerator {
    protected FormPropertiesManager _formPropManager;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._formPropManager = (FormPropertiesManager)((Object)smanager.lookup(FormPropertiesManager.ROLE));
    }

    protected void saxFieldValue(FieldValue fdValue) throws SAXException {
        this.saxFieldValue("field", fdValue);
    }

    protected void saxFieldValue(String tagName, FieldValue fdValue) throws SAXException {
        Object rawValue;
        Field field = fdValue.getField();
        String value = this._getReadableValue(field, rawValue = fdValue.getValue());
        if (value != null) {
            AttributesImpl atts = new AttributesImpl();
            atts.addCDATAAttribute("label", field.getLabel());
            atts.addCDATAAttribute("name", field.getName());
            atts.addCDATAAttribute("columnName", fdValue.getColumnName());
            atts.addCDATAAttribute("type", field.getType().name());
            Map<String, String> properties = field.getProperties();
            if (properties.containsKey("regexptype")) {
                atts.addCDATAAttribute("regexptype", properties.get("regexptype"));
            }
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)tagName, (Attributes)atts, (String)value);
        }
    }

    protected String _getReadableValue(Field field, Object rawValue) {
        if (rawValue == null) {
            return null;
        }
        switch (field.getType()) {
            case SELECT: {
                boolean multiple = "true".equals(field.getProperties().get("multiple"));
                if (multiple) {
                    String[] rawValues = ((String)rawValue).split("\n");
                    ArrayList<String> readableValues = new ArrayList<String>();
                    for (String v : rawValues) {
                        readableValues.add(this._formPropManager.getDisplayValue(field, v));
                    }
                    return StringUtils.join(readableValues, (String)", ");
                }
                return this._formPropManager.getDisplayValue(field, (String)rawValue);
            }
            case RADIO: {
                String displayValue = this._formPropManager.getDisplayValue(field, (String)rawValue);
                return StringUtils.isNotEmpty((String)displayValue) ? displayValue : (String)rawValue;
            }
            case TEXT: {
                String typedValue = StringUtils.trim((String)((String)rawValue));
                String regexptype = field.getProperties().get("regexptype");
                if ("datetime".equals(regexptype) && StringUtils.isNotEmpty((String)typedValue)) {
                    ZonedDateTime date = this._getZonedDateTime(typedValue);
                    if (date == null) {
                        LocalDate localDate = this._getLocalDate(typedValue);
                        return localDate != null ? DateUtils.zonedDateTimeToString((ZonedDateTime)localDate.atStartOfDay(ZoneOffset.UTC)) : null;
                    }
                    return DateUtils.zonedDateTimeToString((ZonedDateTime)date);
                }
                if ("date".equals(regexptype) && StringUtils.isNotEmpty((String)typedValue)) {
                    LocalDate localDate = this._getLocalDate(typedValue);
                    if (localDate == null) {
                        ZonedDateTime date = this._getZonedDateTime(typedValue);
                        return date != null ? DateUtils.localDateToString((LocalDate)date.toLocalDate()) : null;
                    }
                    return DateUtils.localDateToString((LocalDate)localDate);
                }
                return typedValue;
            }
            case FILE: {
                if (rawValue instanceof File) {
                    File file = (File)rawValue;
                    return file.getName();
                }
                return String.valueOf(rawValue);
            }
            case PASSWORD: 
            case CAPTCHA: {
                return null;
            }
        }
        return String.valueOf(rawValue);
    }

    protected ZonedDateTime _getZonedDateTime(String value) {
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm").withZone(ZoneId.systemDefault()).withChronology(IsoChronology.INSTANCE);
            return ZonedDateTime.parse(value, formatter);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected LocalDate _getLocalDate(String value) {
        try {
            return DateUtils.parseLocalDate((String)value);
        }
        catch (Exception e) {
            return null;
        }
    }
}

