/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.content.processing;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ametys.plugins.forms.content.Form;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.commons.lang.StringUtils;

public class FormErrors {
    protected Form _form;
    protected Map<String, List<I18nizableText>> _errors;
    protected boolean _insertionFailed;
    protected boolean _limitReached;

    public FormErrors() {
        this(null, new LinkedHashMap<String, List<I18nizableText>>());
    }

    public FormErrors(Form form, Map<String, List<I18nizableText>> errors) {
        this._form = form;
        this._errors = errors;
        this._insertionFailed = false;
        this._limitReached = false;
    }

    public Form getForm() {
        return this._form;
    }

    public void setForm(Form form) {
        this._form = form;
    }

    public boolean hasInsertionFailed() {
        return this._insertionFailed;
    }

    public void setInsertionFailed(boolean insertionFailed) {
        this._insertionFailed = insertionFailed;
    }

    public Map<String, List<I18nizableText>> getErrors() {
        return this._errors;
    }

    public void setErrors(Map<String, List<I18nizableText>> errors) {
        this._errors = errors;
    }

    public void addError(String fieldId, I18nizableText error) {
        if (StringUtils.isNotEmpty((String)fieldId) && error != null) {
            if (this._errors.containsKey(fieldId)) {
                this._errors.get(fieldId).add(error);
            } else {
                ArrayList<I18nizableText> errors = new ArrayList<I18nizableText>();
                errors.add(error);
                this._errors.put(fieldId, errors);
            }
        }
    }

    public void addErrors(String fieldId, List<I18nizableText> errors) {
        if (StringUtils.isNotEmpty((String)fieldId) && !errors.isEmpty()) {
            if (this._errors.containsKey(fieldId)) {
                this._errors.get(fieldId).addAll(errors);
            } else {
                this._errors.put(fieldId, errors);
            }
        }
    }

    public boolean hasErrors() {
        for (List<I18nizableText> errList : this._errors.values()) {
            if (errList.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasLimitReached() {
        return this._limitReached;
    }

    public void setLimitReached(boolean limitReached) {
        this._limitReached = limitReached;
    }
}

