/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.content.processing;

import com.opensymphony.workflow.InvalidActionException;
import com.opensymphony.workflow.Workflow;
import com.opensymphony.workflow.WorkflowException;
import jakarta.mail.MessagingException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.ametys.core.captcha.CaptchaHelper;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.core.datasource.dbtype.SQLDatabaseTypeExtensionPoint;
import org.ametys.core.group.InvalidModificationException;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.mail.StandardMailBodyHelper;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.URIUtils;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.forms.content.Field;
import org.ametys.plugins.forms.content.Form;
import org.ametys.plugins.forms.content.data.FieldValue;
import org.ametys.plugins.forms.content.jcr.FormPropertiesManager;
import org.ametys.plugins.forms.content.processing.FormErrors;
import org.ametys.plugins.forms.content.processing.FormValidators;
import org.ametys.plugins.forms.content.table.DbTypeHelper;
import org.ametys.plugins.forms.content.table.FormTableManager;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.workflow.store.JdbcWorkflowStore;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.plugins.workflow.support.WorkflowProvider;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.URIPrefixHandler;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.servlet.multipart.Part;
import org.apache.cocoon.servlet.multipart.PartOnDisk;
import org.apache.cocoon.servlet.multipart.RejectedPart;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class ProcessFormHelper
extends AbstractLogEnabled
implements Component,
Serviceable,
Contextualizable {
    public static final String ROLE = ProcessFormHelper.class.getName();
    public static final String PARAM_FORM_ID = "ametys-form-id";
    protected static final String PARAM_CONTENT_ID = "ametys-content-id";
    protected static final Pattern _INT_PATTERN = Pattern.compile(FormValidators.getIntegerPattern());
    protected static final Pattern _FLOAT_PATTERN = Pattern.compile(FormValidators.getFloatPattern());
    protected static final Pattern _DATE_PATTERN = Pattern.compile(FormValidators.getDatePattern());
    protected static final Pattern _TIME_PATTERN = Pattern.compile(FormValidators.getTimePattern());
    protected static final Pattern _DATETIME_PATTERN = Pattern.compile(FormValidators.getDateTimePattern());
    protected static final Pattern _EMAIL_PATTERN = SendMailHelper.EMAIL_VALIDATION;
    protected static final Pattern _PHONE_PATTERN = Pattern.compile(FormValidators.getPhonePattern());
    protected static final DateFormat _DATE_FORMAT = new SimpleDateFormat(FormValidators.getDateFormat());
    protected static final DateFormat _TIME_FORMAT = new SimpleDateFormat(FormValidators.getTimeFormat());
    protected static final DateFormat _DATETIME_FORMAT = new SimpleDateFormat(FormValidators.getDateTimeFormat());
    private static final String __FORM_ENTRY_PATTERN = "${form}";
    private static Pattern __OPTION_INDEX = Pattern.compile("^option-([0-9]+)-value$");
    protected FormPropertiesManager _formPropertiesManager;
    protected FormTableManager _formTableManager;
    protected SourceResolver _sourceResolver;
    protected AmetysObjectResolver _ametysObjectResolver;
    protected SiteManager _siteManager;
    protected String _pluginName;
    protected URIPrefixHandler _prefixHandler;
    protected WorkflowProvider _workflowProvider;
    protected WorkflowHelper _workflowHelper;
    protected SQLDatabaseTypeExtensionPoint _sqlDatabaseTypeExtensionPoint;
    protected Context _context;
    protected RightManager _rightManager;
    protected CurrentUserProvider _currentUserProvied;
    protected I18nUtils _i18nUtils;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._formPropertiesManager = (FormPropertiesManager)((Object)serviceManager.lookup(FormPropertiesManager.ROLE));
        this._formTableManager = (FormTableManager)serviceManager.lookup(FormTableManager.ROLE);
        this._sourceResolver = (SourceResolver)serviceManager.lookup(SourceResolver.ROLE);
        this._ametysObjectResolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._siteManager = (SiteManager)serviceManager.lookup(SiteManager.ROLE);
        this._sqlDatabaseTypeExtensionPoint = (SQLDatabaseTypeExtensionPoint)serviceManager.lookup(SQLDatabaseTypeExtensionPoint.ROLE);
        this._prefixHandler = (URIPrefixHandler)serviceManager.lookup(URIPrefixHandler.ROLE);
        this._workflowProvider = (WorkflowProvider)serviceManager.lookup(WorkflowProvider.ROLE);
        this._workflowHelper = (WorkflowHelper)serviceManager.lookup(WorkflowHelper.ROLE);
        this._rightManager = (RightManager)serviceManager.lookup(RightManager.ROLE);
        this._currentUserProvied = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._i18nUtils = (I18nUtils)serviceManager.lookup(I18nUtils.ROLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormInformations processForm(Form form, Site site, String pluginName) throws Exception {
        FormInformations formInformations = new FormInformations();
        Map objectModel = ContextHelper.getObjectModel((Context)this._context);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        this._pluginName = pluginName;
        FormErrors errors = new FormErrors(form, new LinkedHashMap<String, List<I18nizableText>>());
        formInformations.setFormErrors(errors);
        Map<String, FieldValue> input = this._getInput(form, request, errors);
        this._validateInput(form, input, errors, request);
        int totalSubmissions = 0;
        if (errors.hasErrors()) {
            return formInformations;
        }
        String entryId = null;
        if (!StringUtils.isEmpty((String)form.getLimit())) {
            ProcessFormHelper processFormHelper = this;
            synchronized (processFormHelper) {
                totalSubmissions = this._formTableManager.getTotalSubmissions(form.getId());
                if (Integer.parseInt(form.getLimit()) <= totalSubmissions) {
                    errors.setLimitReached(true);
                    return formInformations;
                }
                entryId = this._insertInput(form, input, objectModel);
                if (StringUtils.isBlank((String)entryId)) {
                    errors.setInsertionFailed(true);
                    return formInformations;
                }
            }
        } else {
            entryId = this._insertInput(form, input, objectModel);
            if (StringUtils.isBlank((String)entryId)) {
                errors.setInsertionFailed(true);
                return formInformations;
            }
        }
        this._sendEmails(form, input, site, totalSubmissions);
        formInformations.setRedirection(this._getFormRedirection(form, entryId));
        return formInformations;
    }

    protected String _getFormRedirection(Form form, String entryId) {
        if (StringUtils.isNotEmpty((String)form.getRedirectTo())) {
            String pageId = form.getRedirectTo();
            try {
                Page page = (Page)this._ametysObjectResolver.resolveById(pageId);
                return this._prefixHandler.getAbsoluteUriPrefix(page.getSiteName()) + "/" + page.getSitemapName() + "/" + page.getPathInSitemap() + ".html";
            }
            catch (UnknownAmetysObjectException e) {
                this.getLogger().warn("The form '" + form.getId() + "' wants to redirect to the unexisting page '" + pageId + "'. Redirecting to default page.", (Throwable)e);
            }
        }
        return null;
    }

    protected Map<String, FieldValue> _getInput(Form form, Request request, FormErrors errors) {
        LinkedHashMap<String, FieldValue> entries = new LinkedHashMap<String, FieldValue>();
        for (Field field : form.getFields()) {
            String id = field.getId();
            String name = field.getName();
            FieldValue entry = null;
            switch (field.getType()) {
                case TEXT: 
                case COST: 
                case HIDDEN: 
                case PASSWORD: {
                    String sValue = (String)request.get(name);
                    entry = new FieldValue(id, 12, sValue, field);
                    break;
                }
                case SELECT: {
                    Object[] values = request.getParameterValues(name);
                    String sValue = values == null ? "" : StringUtils.join((Object[])values, (String)"\n");
                    entry = new FieldValue(id, 12, sValue, field);
                    break;
                }
                case TEXTAREA: {
                    String sValue = (String)request.get(name);
                    entry = new FieldValue(id, -1, sValue, field);
                    break;
                }
                case RADIO: {
                    String sValue;
                    if (!entries.containsKey(name)) {
                        sValue = (String)request.get(name);
                        entry = new FieldValue(name, 12, sValue, field);
                        break;
                    }
                    if (!StringUtils.isNotEmpty((String)field.getLabel())) break;
                    Field radioField = ((FieldValue)entries.get(name)).getField();
                    Field dummyField = new Field(radioField.getId(), radioField.getType(), radioField.getName(), radioField.getLabel() + "/" + field.getLabel(), radioField.getProperties());
                    ((FieldValue)entries.get(name)).setField(dummyField);
                    break;
                }
                case CHECKBOX: {
                    boolean bValue = request.get(name) != null;
                    entry = new FieldValue(id, 16, bValue, field);
                    break;
                }
                case FILE: {
                    entry = this._getFileEntry(request, field, id, name, errors);
                    break;
                }
                case CAPTCHA: {
                    String formId = request.getParameter(PARAM_FORM_ID);
                    String contentId = request.getParameter(PARAM_CONTENT_ID);
                    String encodedName = contentId + "%20" + formId + "%20" + field.getId();
                    String captchaValue = request.getParameter(encodedName);
                    String captchaKey = request.getParameter(encodedName + "-key");
                    entry = new FieldValue(id, 1111, new String[]{captchaValue, captchaKey}, field);
                    break;
                }
            }
            if (entry == null) continue;
            entries.put(entry.getColumnName(), entry);
        }
        return entries;
    }

    protected FieldValue _getFileEntry(Request request, Field field, String id, String name, FormErrors errors) {
        FieldValue entry = null;
        String keyPrefix = "PLUGINS_FORMS_FORMS_RENDER_ERROR_FILE_";
        Part part = (Part)request.get(name);
        if (part instanceof RejectedPart) {
            RejectedPart rejectedPart = (RejectedPart)part;
            if (rejectedPart.getMaxContentLength() == 0) {
                errors.addError(field.getId(), new I18nizableText("plugin." + this._pluginName, "PLUGINS_FORMS_FORMS_RENDER_ERROR_FILE_INFECTED"));
            } else {
                errors.addError(field.getId(), new I18nizableText("plugin." + this._pluginName, "PLUGINS_FORMS_FORMS_RENDER_ERROR_FILE_REJECTED"));
            }
        } else {
            PartOnDisk uploadedFilePart = (PartOnDisk)part;
            entry = uploadedFilePart != null ? new FieldValue(id, 2004, uploadedFilePart.getFile(), field) : new FieldValue(id, 2004, null, field);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String _insertInput(Form form, Map<String, FieldValue> input, Map objectModel) throws WorkflowException, InvalidModificationException {
        PreparedStatement stmt;
        Connection connection;
        String entryId;
        boolean success;
        block10: {
            success = true;
            entryId = null;
            String tableName = "Forms_" + form.getId();
            connection = null;
            stmt = null;
            try {
                String dataSourceId = (String)Config.getInstance().getValue("plugins.forms.datasource");
                connection = ConnectionHelper.getConnection((String)dataSourceId);
                String dbType = ConnectionHelper.getDatabaseType((Connection)connection);
                ArrayList<String> columns = new ArrayList<String>();
                ArrayList<Object> values = new ArrayList<Object>();
                if (DbTypeHelper.insertIdentity(dbType)) {
                    columns.add("id");
                    if ("oracle".equals(dbType)) {
                        values.add("seq_" + form.getId() + ".nextval");
                    } else {
                        values.add("?");
                    }
                }
                columns.add("creationDate");
                values.add("?");
                columns.add("login");
                values.add("?");
                columns.add("populationId");
                values.add("?");
                for (FieldValue entry : this._getEntriesToInsert(input.values())) {
                    String colName = entry.getColumnName();
                    columns.add(this._sqlDatabaseTypeExtensionPoint.languageEscapeTableName(dbType, colName));
                    values.add("?");
                    if (entry.getType() != 2004) continue;
                    String fileNameColumn = colName + "-filename";
                    String normalizedName = DbTypeHelper.normalizeName(dbType, fileNameColumn);
                    columns.add(this._sqlDatabaseTypeExtensionPoint.languageEscapeTableName(dbType, normalizedName));
                    values.add("?");
                }
                if (this._formTableManager.hasWorkflowIdColumn(form.getId())) {
                    columns.add(this._sqlDatabaseTypeExtensionPoint.languageEscapeTableName(dbType, "workflowId"));
                    values.add("?");
                }
                String sql = "INSERT INTO " + this._sqlDatabaseTypeExtensionPoint.languageEscapeTableName(dbType, tableName) + " (" + StringUtils.join(columns, (String)", ") + ") VALUES (" + StringUtils.join(values, (String)", ") + ")";
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Inserting a user submission in the database :\n" + sql);
                }
                stmt = connection.prepareStatement(sql);
                this._setParameters(form, input, stmt, dbType);
                stmt.executeUpdate();
                ConnectionHelper.cleanup((Statement)stmt);
                entryId = this._getEntryId(connection, dbType, tableName);
                if (!this._formTableManager.hasWorkflowIdColumn(form.getId())) break block10;
                success = this._createWorkflow(form, objectModel, entryId);
            }
            catch (SQLException e) {
                try {
                    this.getLogger().error("Error inserting submission data.", (Throwable)e);
                    success = false;
                }
                catch (Throwable throwable) {
                    ConnectionHelper.cleanup(stmt);
                    ConnectionHelper.cleanup(connection);
                    throw throwable;
                }
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup((Connection)connection);
            }
        }
        ConnectionHelper.cleanup((Statement)stmt);
        ConnectionHelper.cleanup((Connection)connection);
        return success ? entryId : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String _getEntryId(Connection connection, String dbType, String tableName) throws SQLException, InvalidModificationException {
        String id = null;
        if ("mysql".equals(dbType)) {
            try (PreparedStatement stmt = connection.prepareStatement("SELECT id FROM " + this._sqlDatabaseTypeExtensionPoint.languageEscapeTableName(dbType, tableName) + " WHERE id = last_insert_id()");
                 ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    id = rs.getString("id");
                    return id;
                }
                if (connection.getAutoCommit()) {
                    throw new InvalidModificationException("Cannot retrieve inserted group. Group was created but listeners not called : base may be inconsistant");
                }
                connection.rollback();
                throw new InvalidModificationException("Cannot retrieve inserted group. Rolling back");
            }
        }
        if ("derby".equals(dbType)) {
            try (PreparedStatement stmt = connection.prepareStatement("VALUES IDENTITY_VAL_LOCAL ()");
                 ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) return id;
                id = rs.getString(1);
                return id;
            }
        }
        if ("hsqldb".equals(dbType)) {
            try (PreparedStatement stmt = connection.prepareStatement("CALL IDENTITY ()");
                 ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) return id;
                id = rs.getString(1);
                return id;
            }
        }
        if (!"postgresql".equals(dbType)) return id;
        try (PreparedStatement stmt = connection.prepareStatement("SELECT currval('groups_id_seq')");
             ResultSet rs = stmt.executeQuery();){
            if (!rs.next()) return id;
            id = rs.getString(1);
            return id;
        }
    }

    private boolean _createWorkflow(Form form, Map objectModel, String entryId) throws InvalidActionException {
        boolean success = true;
        if (entryId != null) {
            Workflow workflow = this._workflowProvider.getExternalWorkflow(JdbcWorkflowStore.ROLE);
            String workflowName = form.getWorkflowName();
            int initialActionId = this._workflowHelper.getInitialAction(workflowName);
            HashMap<String, String> inputs = new HashMap<String, String>();
            inputs.put("formId", form.getId());
            inputs.put("entryId", entryId);
            inputs.put("parent-context", (String)ObjectModelHelper.getContext((Map)objectModel));
            inputs.put("request", (String)ObjectModelHelper.getRequest((Map)objectModel));
            try {
                long workflowInstanceId = workflow.initialize(form.getWorkflowName(), initialActionId, inputs);
                success = this._updateWorkflowId(form.getId(), entryId, workflowInstanceId);
            }
            catch (Exception e) {
                this.getLogger().error("Error inserting submission data.", (Throwable)e);
                this._removeFormEntry(form.getId(), entryId);
                success = false;
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _removeFormEntry(String formId, String entryId) {
        boolean success = true;
        String tableName = "Forms_" + formId;
        Connection connection = null;
        PreparedStatement stmt = null;
        try {
            String dataSourceId = (String)Config.getInstance().getValue("plugins.forms.datasource");
            connection = ConnectionHelper.getConnection((String)dataSourceId);
            String dbType = ConnectionHelper.getDatabaseType((Connection)connection);
            StringBuilder sql = new StringBuilder();
            sql.append("DELETE FROM ").append(this._sqlDatabaseTypeExtensionPoint.languageEscapeTableName(dbType, tableName)).append(" WHERE id = ?");
            stmt = connection.prepareStatement(sql.toString());
            stmt.setString(1, entryId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                this.getLogger().error("Error inserting submission data.", (Throwable)e);
                success = false;
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(connection);
                throw throwable;
            }
            ConnectionHelper.cleanup(stmt);
            ConnectionHelper.cleanup((Connection)connection);
        }
        ConnectionHelper.cleanup((Statement)stmt);
        ConnectionHelper.cleanup((Connection)connection);
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _updateWorkflowId(String formId, String entryId, long workflowId) {
        boolean success = true;
        String tableName = "Forms_" + formId;
        Connection connection = null;
        PreparedStatement stmt = null;
        try {
            String dataSourceId = (String)Config.getInstance().getValue("plugins.forms.datasource");
            connection = ConnectionHelper.getConnection((String)dataSourceId);
            String dbType = ConnectionHelper.getDatabaseType((Connection)connection);
            StringBuilder sql = new StringBuilder();
            sql.append("UPDATE ").append(this._sqlDatabaseTypeExtensionPoint.languageEscapeTableName(dbType, tableName)).append(" SET ").append(this._sqlDatabaseTypeExtensionPoint.languageEscapeTableName(dbType, "workflowId")).append(" = ?").append(" WHERE id = ?");
            stmt = connection.prepareStatement(sql.toString());
            stmt.setLong(1, workflowId);
            stmt.setString(2, entryId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                this.getLogger().error("Error inserting submission data.", (Throwable)e);
                success = false;
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(connection);
                throw throwable;
            }
            ConnectionHelper.cleanup(stmt);
            ConnectionHelper.cleanup((Connection)connection);
        }
        ConnectionHelper.cleanup((Statement)stmt);
        ConnectionHelper.cleanup((Connection)connection);
        return success;
    }

    protected void _setParameters(Form form, Map<String, FieldValue> input, PreparedStatement stmt, String dbType) throws SQLException, WorkflowException {
        int index = 1;
        if (DbTypeHelper.insertIdentity(dbType) && !"oracle".equals(dbType)) {
            DbTypeHelper.setIdentity(stmt, index, dbType);
            ++index;
        }
        stmt.setTimestamp(index, new Timestamp(System.currentTimeMillis()));
        ++index;
        UserIdentity user = this._currentUserProvied.getUser();
        if (user != null) {
            stmt.setString(index, user.getLogin());
            stmt.setString(++index, user.getPopulationId());
            ++index;
        } else {
            stmt.setNull(index, 12);
            stmt.setNull(++index, 12);
            ++index;
        }
        Collection<FieldValue> entries = this._getEntriesToInsert(input.values());
        for (FieldValue entry : entries) {
            if (entry.getField().getType() == Field.FieldType.COST) {
                stmt.setString(index, this._computeCost(input));
            } else if (entry.getValue() == null) {
                stmt.setNull(index, entry.getType());
                if (entry.getType() == 2004) {
                    stmt.setNull(++index, 12);
                }
            } else if (entry.getType() == 2004 && entry.getValue() instanceof File) {
                File file = (File)entry.getValue();
                try {
                    this._sqlDatabaseTypeExtensionPoint.setBlob(dbType, stmt, index, (InputStream)new FileInputStream(file), file.length());
                    stmt.setString(++index, file.getName());
                }
                catch (IOException e) {
                    this.getLogger().error("Can't read uploaded file.", (Throwable)e);
                }
            } else if (entry.getType() == 16 && entry.getValue() instanceof Boolean) {
                stmt.setInt(index, Boolean.TRUE.equals(entry.getValue()) ? 1 : 0);
            } else {
                stmt.setObject(index, entry.getValue(), entry.getType());
            }
            ++index;
        }
        if (this._formTableManager.hasWorkflowIdColumn(form.getId())) {
            stmt.setLong(index, -1L);
        }
    }

    private String _computeCost(Map<String, FieldValue> input) {
        double v = input.values().stream().filter(fv -> fv.getField().getType() == Field.FieldType.SELECT && "true".equals(fv.getField().getProperties().getOrDefault("partofcost", "false"))).mapToDouble(this::_getCost).sum();
        return Double.toString(v);
    }

    private double _getCost(FieldValue fv) {
        return fv.getField().getProperties().entrySet().stream().mapToDouble(e -> {
            Matcher m = __OPTION_INDEX.matcher((CharSequence)e.getKey());
            if (m.matches() && this._equals((String)e.getValue(), fv.getValue())) {
                String v = fv.getField().getProperties().getOrDefault("option-" + m.group(1) + "-cost", "0");
                return Double.parseDouble(v);
            }
            return 0.0;
        }).sum();
    }

    private boolean _equals(String optionVaue, Object rawSelectedValues) {
        String[] selectedValues;
        for (String selectedValue : selectedValues = StringUtils.split((String)((String)rawSelectedValues), (char)'\n')) {
            if (!StringUtils.equals((String)optionVaue.trim(), (String)selectedValue.trim())) continue;
            return true;
        }
        return false;
    }

    protected void _validateInput(Form form, Map<String, FieldValue> input, FormErrors errors, Request request) {
        for (FieldValue entry : input.values()) {
            Field field = entry.getField();
            switch (field.getType()) {
                case TEXT: {
                    errors.addErrors(field.getId(), this._validateTextField(entry, request));
                    break;
                }
                case PASSWORD: {
                    errors.addErrors(field.getId(), this._validatePassword(entry, request));
                    break;
                }
                case SELECT: {
                    errors.addErrors(field.getId(), this._validateSelect(entry, request));
                    break;
                }
                case TEXTAREA: {
                    errors.addErrors(field.getId(), this._validateTextarea(entry, request));
                    break;
                }
                case RADIO: {
                    errors.addErrors(field.getId(), this._validateRadio(entry, request));
                    break;
                }
                case CHECKBOX: {
                    errors.addErrors(field.getId(), this._validateCheckbox(entry, request));
                    break;
                }
                case FILE: {
                    errors.addErrors(field.getId(), this._validateFile(entry, request));
                    break;
                }
                case CAPTCHA: {
                    errors.addErrors(field.getId(), this._validateCaptcha(entry, request));
                    break;
                }
            }
        }
    }

    protected List<I18nizableText> _validateTextField(FieldValue entry, Request request) {
        ArrayList<I18nizableText> errors = new ArrayList<I18nizableText>();
        Field field = entry.getField();
        Map<String, String> properties = field.getProperties();
        String value = StringUtils.defaultString((String)((String)entry.getValue()));
        String textPrefix = "PLUGINS_FORMS_FORMS_RENDER_ERROR_TEXT_";
        errors.addAll(this._validateMandatory(entry, "PLUGINS_FORMS_FORMS_RENDER_ERROR_TEXT_"));
        errors.addAll(this._validateConfirmation(entry, request, "PLUGINS_FORMS_FORMS_RENDER_ERROR_TEXT_"));
        String regexpType = properties.get("regexptype");
        if (StringUtils.isEmpty((String)regexpType) || "text".equals(regexpType)) {
            errors.addAll(this._validateTextLength(entry, "PLUGINS_FORMS_FORMS_RENDER_ERROR_TEXT_"));
        } else if (!StringUtils.isBlank((String)value)) {
            this._validateNonblankRegexp(entry, errors, value, "PLUGINS_FORMS_FORMS_RENDER_ERROR_TEXT_", regexpType);
        }
        return errors;
    }

    private void _validateNonblankRegexp(FieldValue entry, List<I18nizableText> errors, String value, String textPrefix, String regexpType) {
        if ("int".equals(regexpType) && StringUtils.isBlank((String)value)) {
            errors.addAll(this._validateInteger(entry, textPrefix));
        } else if ("float".equals(regexpType)) {
            errors.addAll(this._validateFloat(entry, textPrefix));
        } else if ("email".equals(regexpType)) {
            if (StringUtils.isNotEmpty((String)value) && !_EMAIL_PATTERN.matcher(value).matches()) {
                errors.add(new I18nizableText("plugin." + this._pluginName, "PLUGINS_FORMS_FORMS_RENDER_ERROR_TEXT_EMAIL"));
            }
        } else if ("phone".equals(regexpType)) {
            if (StringUtils.isNotEmpty((String)value) && !_PHONE_PATTERN.matcher(value).matches()) {
                errors.add(new I18nizableText("plugin." + this._pluginName, "PLUGINS_FORMS_FORMS_RENDER_ERROR_TEXT_PHONE"));
            }
        } else if ("date".equals(regexpType)) {
            errors.addAll(this._validateDate(entry, textPrefix));
        } else if ("time".equals(regexpType)) {
            errors.addAll(this._validateTime(entry, textPrefix));
        } else if ("datetime".equals(regexpType)) {
            errors.addAll(this._validateDateTime(entry, textPrefix));
        } else if ("custom".equals(regexpType)) {
            errors.addAll(this._validateCustomRegexp(entry, textPrefix));
        }
    }

    protected List<I18nizableText> _validatePassword(FieldValue entry, Request request) {
        ArrayList<I18nizableText> errors = new ArrayList<I18nizableText>();
        String keyPrefix = "PLUGINS_FORMS_FORMS_RENDER_ERROR_PASSWORD_";
        errors.addAll(this._validateMandatory(entry, "PLUGINS_FORMS_FORMS_RENDER_ERROR_PASSWORD_"));
        errors.addAll(this._validateConfirmation(entry, request, "PLUGINS_FORMS_FORMS_RENDER_ERROR_PASSWORD_"));
        errors.addAll(this._validateCustomRegexp(entry, "PLUGINS_FORMS_FORMS_RENDER_ERROR_PASSWORD_"));
        return errors;
    }

    protected List<I18nizableText> _validateSelect(FieldValue entry, Request request) {
        ArrayList<I18nizableText> errors = new ArrayList<I18nizableText>();
        String keyPrefix = "PLUGINS_FORMS_FORMS_RENDER_ERROR_SELECT_";
        errors.addAll(this._validateMandatory(entry, "PLUGINS_FORMS_FORMS_RENDER_ERROR_SELECT_"));
        return errors;
    }

    protected List<I18nizableText> _validateTextarea(FieldValue entry, Request request) {
        ArrayList<I18nizableText> errors = new ArrayList<I18nizableText>();
        String keyPrefix = "PLUGINS_FORMS_FORMS_RENDER_ERROR_TEXTAREA_";
        errors.addAll(this._validateMandatory(entry, "PLUGINS_FORMS_FORMS_RENDER_ERROR_TEXTAREA_"));
        return errors;
    }

    protected List<I18nizableText> _validateRadio(FieldValue entry, Request request) {
        ArrayList<I18nizableText> errors = new ArrayList<I18nizableText>();
        String keyPrefix = "PLUGINS_FORMS_FORMS_RENDER_ERROR_RADIO_";
        errors.addAll(this._validateMandatory(entry, "PLUGINS_FORMS_FORMS_RENDER_ERROR_RADIO_"));
        return errors;
    }

    protected List<I18nizableText> _validateCheckbox(FieldValue entry, Request request) {
        ArrayList<I18nizableText> errors = new ArrayList<I18nizableText>();
        Field field = entry.getField();
        Map<String, String> properties = field.getProperties();
        Boolean value = (Boolean)entry.getValue();
        String keyPrefix = "PLUGINS_FORMS_FORMS_RENDER_ERROR_CHECKBOX_";
        if (Boolean.parseBoolean(properties.get("mandatory")) && !value.booleanValue()) {
            errors.add(new I18nizableText("plugin." + this._pluginName, "PLUGINS_FORMS_FORMS_RENDER_ERROR_CHECKBOX_MANDATORY"));
        }
        return errors;
    }

    protected List<I18nizableText> _validateFile(FieldValue entry, Request request) {
        ArrayList<I18nizableText> errors = new ArrayList<I18nizableText>();
        Field field = entry.getField();
        Map<String, String> properties = field.getProperties();
        File file = (File)entry.getValue();
        String keyPrefix = "PLUGINS_FORMS_FORMS_RENDER_ERROR_FILE_";
        if (Boolean.parseBoolean(properties.get("mandatory")) && file == null) {
            errors.add(new I18nizableText("plugin." + this._pluginName, "PLUGINS_FORMS_FORMS_RENDER_ERROR_FILE_MANDATORY"));
        }
        if (file != null) {
            float maxLength;
            if (!file.isFile() || !file.canRead()) {
                errors.add(new I18nizableText("plugin." + this._pluginName, "PLUGINS_FORMS_FORMS_RENDER_ERROR_FILE_INVALID"));
            }
            String fileExtensions = StringUtils.defaultString((String)properties.get("fileextension"));
            String[] fileExtArray = fileExtensions.split(",");
            boolean extensionOk = false;
            for (int i = 0; i < fileExtArray.length && !extensionOk; ++i) {
                String ext = fileExtArray[i].trim().toLowerCase();
                extensionOk = file.getName().toLowerCase().endsWith(ext);
            }
            if (!extensionOk) {
                errors.add(new I18nizableText("plugin." + this._pluginName, "PLUGINS_FORMS_FORMS_RENDER_ERROR_FILE_EXTENSION"));
            }
            if ((maxLength = this._getFloat(properties.get("maxsize"), Float.valueOf(Float.MAX_VALUE)).floatValue()) < Float.MAX_VALUE) {
                maxLength = maxLength * 1024.0f * 1024.0f;
            }
            if ((float)file.length() > maxLength) {
                errors.add(new I18nizableText("plugin." + this._pluginName, "PLUGINS_FORMS_FORMS_RENDER_ERROR_FILE_TOOLARGE", Collections.singletonList(properties.get("maxsize"))));
            }
        }
        return errors;
    }

    protected List<I18nizableText> _validateCaptcha(FieldValue entry, Request request) {
        String value;
        ArrayList<I18nizableText> errors = new ArrayList<I18nizableText>();
        String keyPrefix = "PLUGINS_FORMS_FORMS_RENDER_ERROR_CAPTCHA_";
        String[] values = (String[])entry.getValue();
        String key = values[1];
        if (!CaptchaHelper.checkAndInvalidate((String)key, (String)(value = values[0]))) {
            errors.add(new I18nizableText("plugin." + this._pluginName, "PLUGINS_FORMS_FORMS_RENDER_ERROR_CAPTCHA_INVALID"));
        }
        return errors;
    }

    protected List<I18nizableText> _validateMandatory(FieldValue entry, String keyPrefix) {
        ArrayList<I18nizableText> errors = new ArrayList<I18nizableText>();
        Field field = entry.getField();
        Map<String, String> properties = field.getProperties();
        String value = StringUtils.defaultString((String)((String)entry.getValue()));
        if (Boolean.parseBoolean(properties.get("mandatory")) && StringUtils.isBlank((String)value)) {
            errors.add(new I18nizableText("plugin." + this._pluginName, keyPrefix + "MANDATORY"));
        }
        return errors;
    }

    protected List<I18nizableText> _validateConfirmation(FieldValue entry, Request request, String keyPrefix) {
        String confName;
        String confValue;
        ArrayList<I18nizableText> errors = new ArrayList<I18nizableText>();
        Field field = entry.getField();
        Map<String, String> properties = field.getProperties();
        String value = StringUtils.defaultString((String)((String)entry.getValue()));
        if (Boolean.parseBoolean(properties.get("confirmation")) && !value.equals(confValue = request.getParameter(confName = field.getName() + "_confirmation"))) {
            errors.add(new I18nizableText("plugin." + this._pluginName, keyPrefix + "CONFIRMATION"));
        }
        return errors;
    }

    private List<I18nizableText> _validateTextLength(FieldValue entry, String keyPrefix) {
        ArrayList<I18nizableText> errors = new ArrayList<I18nizableText>();
        Field field = entry.getField();
        Map<String, String> properties = field.getProperties();
        String value = StringUtils.defaultString((String)((String)entry.getValue()));
        Integer minValue = this._getInteger(properties.get("minvalue"), null);
        if (minValue != null && StringUtils.isNotBlank((String)value) && value.length() < minValue) {
            errors.add(new I18nizableText("plugin." + this._pluginName, keyPrefix + "MINLENGTH", Collections.singletonList(minValue.toString())));
        }
        return errors;
    }

    private List<I18nizableText> _validateInteger(FieldValue entry, String keyPrefix) {
        ArrayList<I18nizableText> errors = new ArrayList<I18nizableText>();
        Field field = entry.getField();
        Map<String, String> properties = field.getProperties();
        String value = StringUtils.defaultString((String)((String)entry.getValue()));
        if (!_INT_PATTERN.matcher(value).matches()) {
            errors.add(new I18nizableText("plugin." + this._pluginName, keyPrefix + "INTEGER"));
        } else {
            Integer intValue = this._getInteger(value, null);
            Integer minValue = this._getInteger(properties.get("minvalue"), null);
            Integer maxValue = this._getInteger(properties.get("maxvalue"), null);
            if (minValue != null && intValue != null && intValue < minValue) {
                errors.add(new I18nizableText("plugin." + this._pluginName, keyPrefix + "INTEGER_MINVALUE", Collections.singletonList(minValue.toString())));
            }
            if (maxValue != null && intValue != null && intValue > maxValue) {
                errors.add(new I18nizableText("plugin." + this._pluginName, keyPrefix + "INTEGER_MAXVALUE", Collections.singletonList(maxValue.toString())));
            }
        }
        return errors;
    }

    private List<I18nizableText> _validateFloat(FieldValue entry, String keyPrefix) {
        ArrayList<I18nizableText> errors = new ArrayList<I18nizableText>();
        Field field = entry.getField();
        Map<String, String> properties = field.getProperties();
        String value = StringUtils.defaultString((String)((String)entry.getValue()));
        if (!_FLOAT_PATTERN.matcher(value).matches()) {
            errors.add(new I18nizableText("plugin." + this._pluginName, keyPrefix + "FLOAT"));
        } else {
            Float floatValue = this._getFloat(value, null);
            if (floatValue != null) {
                Integer minValue = this._getInteger(properties.get("minvalue"), null);
                Integer maxValue = this._getInteger(properties.get("maxvalue"), null);
                if (minValue != null && floatValue.floatValue() < (float)minValue.intValue()) {
                    errors.add(new I18nizableText("plugin." + this._pluginName, keyPrefix + "FLOAT_MINVALUE", Collections.singletonList(minValue.toString())));
                }
                if (maxValue != null && floatValue.floatValue() > (float)maxValue.intValue()) {
                    errors.add(new I18nizableText("plugin." + this._pluginName, keyPrefix + "FLOAT_MAXVALUE", Collections.singletonList(maxValue.toString())));
                }
            }
        }
        return errors;
    }

    private List<I18nizableText> _validateDate(FieldValue entry, String keyPrefix) {
        Date date;
        ArrayList<I18nizableText> errors = new ArrayList<I18nizableText>();
        Field field = entry.getField();
        Map<String, String> properties = field.getProperties();
        String value = StringUtils.defaultString((String)((String)entry.getValue()));
        if (!_DATE_PATTERN.matcher(value).matches()) {
            errors.add(new I18nizableText("plugin." + this._pluginName, keyPrefix + "DATE"));
        }
        if ((date = this._getDate(value, null, _DATE_FORMAT)) != null) {
            Date minDate = this._getDate(properties.get("minvalue"), null, _DATE_FORMAT);
            Date maxDate = this._getDate(properties.get("maxvalue"), null, _DATE_FORMAT);
            if (minDate != null && date.before(minDate)) {
                errors.add(new I18nizableText("plugin." + this._pluginName, keyPrefix + "DATE_MINVALUE", Collections.singletonList(properties.get("minvalue"))));
            }
            if (maxDate != null && date.after(maxDate)) {
                errors.add(new I18nizableText("plugin." + this._pluginName, keyPrefix + "DATE_MAXVALUE", Collections.singletonList(properties.get("maxvalue"))));
            }
        }
        return errors;
    }

    private List<I18nizableText> _validateTime(FieldValue entry, String keyPrefix) {
        Date time;
        ArrayList<I18nizableText> errors = new ArrayList<I18nizableText>();
        Field field = entry.getField();
        Map<String, String> properties = field.getProperties();
        String value = StringUtils.defaultString((String)((String)entry.getValue()));
        if (!_TIME_PATTERN.matcher(value).matches()) {
            errors.add(new I18nizableText("plugin." + this._pluginName, keyPrefix + "TIME"));
        }
        if ((time = this._getDate(value, null, _TIME_FORMAT)) != null) {
            Date minTime = this._getDate(properties.get("minvalue"), null, _TIME_FORMAT);
            Date maxTime = this._getDate(properties.get("maxvalue"), null, _TIME_FORMAT);
            if (minTime != null && time.before(minTime)) {
                errors.add(new I18nizableText("plugin." + this._pluginName, keyPrefix + "TIME_MINVALUE", Collections.singletonList(properties.get("minvalue"))));
            }
            if (maxTime != null && time.after(maxTime)) {
                errors.add(new I18nizableText("plugin." + this._pluginName, keyPrefix + "TIME_MAXVALUE", Collections.singletonList(properties.get("maxvalue"))));
            }
        }
        return errors;
    }

    private List<I18nizableText> _validateDateTime(FieldValue entry, String keyPrefix) {
        Date date;
        ArrayList<I18nizableText> errors = new ArrayList<I18nizableText>();
        Field field = entry.getField();
        Map<String, String> properties = field.getProperties();
        String value = StringUtils.defaultString((String)((String)entry.getValue()));
        if (!_DATETIME_PATTERN.matcher(value).matches()) {
            errors.add(new I18nizableText("plugin." + this._pluginName, keyPrefix + "DATETIME"));
        }
        if ((date = this._getDate(value, null, _DATETIME_FORMAT)) != null) {
            Date minDate = this._getDate(properties.get("minvalue"), null, _DATETIME_FORMAT);
            Date maxDate = this._getDate(properties.get("maxvalue"), null, _DATETIME_FORMAT);
            if (minDate != null && date.before(minDate)) {
                errors.add(new I18nizableText("plugin." + this._pluginName, keyPrefix + "DATETIME_MINVALUE", Collections.singletonList(properties.get("minvalue"))));
            }
            if (maxDate != null && date.after(maxDate)) {
                errors.add(new I18nizableText("plugin." + this._pluginName, keyPrefix + "DATETIME_MAXVALUE", Collections.singletonList(properties.get("maxvalue"))));
            }
        }
        return errors;
    }

    private List<I18nizableText> _validateCustomRegexp(FieldValue entry, String keyPrefix) {
        ArrayList<I18nizableText> errors = new ArrayList<I18nizableText>();
        Field field = entry.getField();
        Map<String, String> properties = field.getProperties();
        String value = StringUtils.defaultString((String)((String)entry.getValue()));
        if (StringUtils.isNotBlank((String)value)) {
            String jsPattern;
            Integer minValue = this._getInteger(properties.get("minvalue"), null);
            if (minValue != null && value.length() < minValue) {
                errors.add(new I18nizableText("plugin." + this._pluginName, keyPrefix + "MINLENGTH", Collections.singletonList(minValue.toString())));
            }
            if (StringUtils.isNotBlank((String)(jsPattern = properties.get("regexp")))) {
                try {
                    String decodedJsPattern = URIUtils.decode((String)StringUtils.defaultString((String)jsPattern));
                    Pattern pattern = this._getPattern(decodedJsPattern);
                    if (!pattern.matcher(value).matches()) {
                        errors.add(new I18nizableText("plugin." + this._pluginName, keyPrefix + "REGEXP"));
                    }
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    // empty catch block
                }
            }
        }
        return errors;
    }

    private Pattern _getPattern(String jsRegexp) {
        Pattern pattern = null;
        String regex = "";
        int flags = 0;
        int firstSlash = jsRegexp.indexOf(47);
        int lastSlash = jsRegexp.lastIndexOf(47);
        if (firstSlash > -1 && lastSlash > firstSlash) {
            regex = jsRegexp.substring(firstSlash + 1, lastSlash);
            if ("i".equals(jsRegexp.substring(lastSlash + 1))) {
                flags = 2;
            }
            pattern = Pattern.compile(regex, flags);
        }
        return pattern;
    }

    private Integer _getInteger(String stringValue, Integer defaultValue) {
        Integer value = defaultValue;
        if (StringUtils.isNotEmpty((String)stringValue)) {
            try {
                value = Integer.parseInt(stringValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    private Float _getFloat(String stringValue, Float defaultValue) {
        Float value = defaultValue;
        if (StringUtils.isNotEmpty((String)stringValue)) {
            try {
                value = Float.valueOf(Float.parseFloat(stringValue));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    private Date _getDate(String stringValue, Date defaultValue, DateFormat format) {
        Date value = defaultValue;
        if (StringUtils.isNotEmpty((String)stringValue)) {
            try {
                value = format.parse(stringValue);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return value;
    }

    protected Collection<FieldValue> _getEntriesToInsert(Collection<FieldValue> entries) {
        ArrayList<FieldValue> filteredEntries = new ArrayList<FieldValue>(entries.size());
        for (FieldValue entry : entries) {
            if (Field.FieldType.CAPTCHA.equals((Object)entry.getField().getType())) continue;
            filteredEntries.add(entry);
        }
        return filteredEntries;
    }

    protected void _sendEmails(Form form, Map<String, FieldValue> input, Site site, Integer totalSubmissions) {
        Config config = Config.getInstance();
        String sender = (String)config.getValue("smtp.mail.from");
        if (site != null) {
            sender = (String)site.getValue("site-mail-from");
        }
        this._sendNotificationEmails(form, input, sender, site);
        this._sendReceiptEmail(form, input, sender);
        if (!StringUtils.isEmpty((String)form.getLimit()) && Integer.parseInt(form.getLimit()) == totalSubmissions + 1) {
            this._sendLimitEmail(form, input, sender, site);
        }
    }

    protected void _sendNotificationEmails(Form form, Map<String, FieldValue> input, String sender, Site site) {
        Set<String> emails = form.getNotificationEmails();
        try {
            String label = URIUtils.decode((String)form.getLabel());
            String siteTitle = site != null ? site.getTitle() : "";
            I18nizableText subject = new I18nizableText("plugin.forms", "PLUGINS_FORMS_MAIL_RESULTS_SUBJECT", List.of(label, siteTitle));
            I18nizableText html = new I18nizableText("plugin.forms", "PLUGINS_FORMS_CONTENT_MAIL_RESULTS_TEXT", List.of(label));
            String prettyHtmlBody = StandardMailBodyHelper.newHTMLBody().withTitle(subject).withMessage(html).withDetails(new I18nizableText("plugin.forms", "PLUGINS_FORMS_MAIL_RESULTS_DETAILS_TITLE"), this._getMail("entry.html", form, input), false).build();
            String params = "?type=results&form-name=" + form.getLabel();
            String text = this._getMail("results.txt" + params, form, input);
            Collection<File> files = this._getFiles(input);
            for (String email : emails) {
                if (!StringUtils.isNotEmpty((String)email)) continue;
                try {
                    SendMailHelper.newMail().withSubject(this._i18nUtils.translate((I18nizable)subject)).withHTMLBody(prettyHtmlBody).withTextBody(text).withAttachments(files).withSender(sender).withRecipient(email).sendMail();
                }
                catch (MessagingException | IOException e) {
                    this.getLogger().error("Error sending the notification mail to " + email, e);
                }
            }
        }
        catch (IOException e) {
            this.getLogger().error("Error creating the notification message.", (Throwable)e);
        }
    }

    protected void _sendReceiptEmail(Form form, Map<String, FieldValue> input, String sender) {
        String email = "";
        try {
            FieldValue receiptEntry;
            String receiptFieldId = form.getReceiptFieldId();
            if (StringUtils.isNotEmpty((String)receiptFieldId) && (receiptEntry = input.get(receiptFieldId)).getValue() != null && _EMAIL_PATTERN.matcher(email = receiptEntry.getValue().toString()).matches()) {
                String subject = URIUtils.decode((String)form.getReceiptFieldSubject());
                String bodyTxt = URIUtils.decode((String)form.getReceiptFieldBody());
                String bodyHTML = bodyTxt.replaceAll("\r?\n", "<br/>");
                if (bodyTxt.contains(__FORM_ENTRY_PATTERN)) {
                    String entry2html = this._getMail("entry.html", form, input);
                    String entry2text = this._getMail("entry.txt", form, input);
                    bodyTxt = StringUtils.replace((String)bodyTxt, (String)__FORM_ENTRY_PATTERN, (String)entry2text);
                    bodyHTML = StringUtils.replace((String)bodyHTML, (String)__FORM_ENTRY_PATTERN, (String)entry2html);
                }
                String prettyHtmlBody = StandardMailBodyHelper.newHTMLBody().withTitle(subject).withMessage(bodyHTML).build();
                String overrideSender = form.getReceiptFieldFromAddress();
                SendMailHelper.newMail().withSubject(subject).withHTMLBody(prettyHtmlBody).withTextBody(bodyTxt).withSender(StringUtils.isEmpty((String)overrideSender) ? sender : overrideSender).withRecipient(email).sendMail();
            }
        }
        catch (MessagingException | IOException e) {
            this.getLogger().error("Error sending the receipt mail to " + email, e);
        }
    }

    protected void _sendLimitEmail(Form form, Map<String, FieldValue> input, String sender, Site site) {
        Set<String> emails = form.getNotificationEmails();
        try {
            String label = URIUtils.decode((String)form.getLabel());
            String siteTitle = site != null ? site.getTitle() : "";
            I18nizableText subject = new I18nizableText("plugin.forms", "PLUGINS_FORMS_MAIL_LIMIT_SUBJECT", List.of(label, siteTitle));
            I18nizableText html = new I18nizableText("plugin.forms", "PLUGINS_FORMS_MAIL_LIMIT_TEXT", List.of(label));
            String prettyHtmlBody = StandardMailBodyHelper.newHTMLBody().withTitle(subject).withMessage(html).build();
            I18nizableText text = new I18nizableText("plugin.forms", "PLUGINS_FORMS_MAIL_LIMIT_TEXT_NO_HTML", List.of(label));
            Collection<File> files = this._getFiles(input);
            for (String email : emails) {
                if (!StringUtils.isNotEmpty((String)email)) continue;
                try {
                    SendMailHelper.newMail().withSubject(this._i18nUtils.translate((I18nizable)subject)).withHTMLBody(prettyHtmlBody).withTextBody(this._i18nUtils.translate((I18nizable)text)).withAttachments(files).withSender(sender).withRecipient(email).sendMail();
                }
                catch (MessagingException e) {
                    this.getLogger().error("Error sending the limit mail to " + email, (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            this.getLogger().error("Error creating the limit message.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String _getMail(String resource, Form form, Map<String, FieldValue> input) throws IOException {
        String string;
        Source src = null;
        try {
            String uri = "cocoon:/mail/" + resource;
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("form", form);
            parameters.put("input", input);
            src = this._sourceResolver.resolveURI(uri, null, parameters);
            InputStreamReader reader = new InputStreamReader(src.getInputStream(), "UTF-8");
            string = IOUtils.toString((Reader)reader);
        }
        catch (Throwable throwable) {
            this._sourceResolver.release(src);
            throw throwable;
        }
        this._sourceResolver.release(src);
        return string;
    }

    protected Collection<File> _getFiles(Map<String, FieldValue> input) {
        ArrayList<File> files = new ArrayList<File>();
        for (FieldValue entry : input.values()) {
            File file;
            if (!Field.FieldType.FILE.equals((Object)entry.getField().getType()) || (file = (File)entry.getValue()) == null) continue;
            files.add(file);
        }
        return files;
    }

    public static class FormInformations {
        private FormErrors _formErrors = null;
        private String _redirection = null;

        public FormErrors getFormErrors() {
            return this._formErrors;
        }

        public void setFormErrors(FormErrors formErrors) {
            this._formErrors = formErrors;
        }

        public String getRedirection() {
            return this._redirection;
        }

        public void setRedirection(String redirection) {
            this._redirection = redirection;
        }
    }
}

