/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.content.table;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.ametys.core.datasource.dbtype.SQLDatabaseTypeExtensionPoint;
import org.ametys.plugins.forms.content.table.FormTableManager;
import org.apache.commons.lang.StringUtils;

public final class DbTypeHelper {
    private DbTypeHelper() {
    }

    public static String normalizeName(String dbType, String str) {
        switch (dbType) {
            case "oracle": {
                return StringUtils.replace((String)str, (String)"-", (String)"_");
            }
        }
        return str;
    }

    public static String filterName(String dbType, String str) {
        switch (dbType) {
            case "oracle": {
                return str.toUpperCase();
            }
        }
        return str;
    }

    public static String getVarcharType(String dbType) {
        return "VARCHAR(255)";
    }

    public static String getTextType(String dbType) {
        switch (dbType) {
            case "derby": {
                return "LONG VARCHAR";
            }
            case "oracle": {
                return "CLOB";
            }
        }
        return "TEXT";
    }

    public static String getBooleanType(String dbType) {
        switch (dbType) {
            case "derby": 
            case "postgresql": {
                return "SMALLINT";
            }
            case "oracle": {
                return "NUMBER(1)";
            }
        }
        return "INT(1)";
    }

    public static String getBinaryType(String dbType) {
        switch (dbType) {
            case "mysql": {
                return "LONGBLOB";
            }
            case "postgresql": {
                return "BYTEA";
            }
        }
        return "BLOB";
    }

    public static String getIntegerType(String dbType) {
        return "INTEGER";
    }

    public static String getDateTimeType(String dbType) {
        return "TIMESTAMP";
    }

    public static String getIdentityType(String dbType) {
        switch (dbType) {
            case "oracle": {
                return "number NOT NULL";
            }
            case "mysql": 
            case "derby": {
                return "int NOT NULL";
            }
        }
        return "";
    }

    public static String getIdentityMarker(String dbType) {
        switch (dbType) {
            case "mysql": {
                return "AUTO_INCREMENT";
            }
            case "derby": {
                return "GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1)";
            }
            case "postgresql": {
                return "SERIAL";
            }
        }
        return "";
    }

    public static String getIdentityValue(String dbType) {
        return "NULL";
    }

    public static String getCurrentDateFunction(String dbType) {
        switch (dbType) {
            case "mysql": {
                return "NOW()";
            }
            case "oracle": {
                return "CURDATE";
            }
            case "postgresql": {
                return "CURRENT_TIMESTAMP";
            }
        }
        return "";
    }

    public static boolean insertIdentity(String dbType) {
        switch (dbType) {
            case "derby": 
            case "postgresql": {
                return false;
            }
        }
        return true;
    }

    public static void setIdentity(PreparedStatement stmt, int index, String dbType) throws SQLException {
        switch (dbType) {
            case "mysql": {
                stmt.setNull(index, 4);
                break;
            }
            case "derby": {
                break;
            }
            case "postgresql": {
                stmt.setNull(index, 4);
                break;
            }
            case "oracle": {
                return;
            }
            default: {
                stmt.setNull(index, 4);
            }
        }
    }

    public static String getRenameColumnStatement(String tableName, FormTableManager.DbColumn column, String newName, String dbType, SQLDatabaseTypeExtensionPoint sqlDatabaseTypeExtensionPoint) {
        return DbTypeHelper.getRenameColumnStatement(tableName, column.getName(), newName, column.getColumnTypeIdentifier(), dbType, sqlDatabaseTypeExtensionPoint);
    }

    public static String getRenameColumnStatement(String tableName, String columnName, String newName, String columnType, String dbType, SQLDatabaseTypeExtensionPoint sqlDatabaseTypeExtensionPoint) {
        StringBuilder buff = new StringBuilder();
        String escapedTableName = sqlDatabaseTypeExtensionPoint.languageEscapeTableName(dbType, tableName);
        String escapedColumnName = sqlDatabaseTypeExtensionPoint.languageEscapeTableName(dbType, columnName);
        String escapedNewName = sqlDatabaseTypeExtensionPoint.languageEscapeTableName(dbType, newName);
        switch (dbType) {
            case "mysql": {
                buff.append("ALTER TABLE ").append(escapedTableName);
                buff.append(" CHANGE ").append(escapedColumnName);
                buff.append(" ").append(escapedNewName).append(" ");
                buff.append(columnType);
                buff.append(" DEFAULT NULL");
                break;
            }
            case "derby": {
                buff.append("RENAME COLUMN ").append(escapedTableName).append(".").append(escapedColumnName);
                buff.append(" TO ").append(escapedNewName);
                break;
            }
            default: {
                buff.append("ALTER TABLE ").append(escapedTableName);
                buff.append(" RENAME COLUMN ").append(escapedColumnName);
                buff.append(" TO ").append(escapedNewName);
            }
        }
        return buff.toString();
    }
}

