/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.content.workflow;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.forms.content.Field;
import org.ametys.plugins.forms.content.Fieldset;
import org.ametys.plugins.forms.content.Form;
import org.apache.commons.lang.StringUtils;
import org.apache.excalibur.xml.xpath.PrefixResolver;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FormParser {
    public static final PrefixResolver RICH_TEXT_PREFIX_RESOLVER = new RichTextPrefixResolver();
    protected static final String _LABEL_ELEMENT = "label";
    protected static final String _INPUT_ELEMENT = "input";
    protected static final String _TEXTAREA_ELEMENT = "textarea";
    protected static final String _SELECT_ELEMENT = "select";
    protected static final String _OPTION_ELEMENT = "option";
    protected static final String _CAPTCHA_ELEMENT = "captcha";
    protected static final String _FIELDSET_ELEMENT = "fieldset";
    protected static final String _LEGEND_ELEMENT = "legend";
    protected XPathProcessor _xpathProcessor;

    public FormParser(XPathProcessor xpathProcessor) {
        this._xpathProcessor = xpathProcessor;
    }

    public List<Node> getNodesAsList(Node context, String xpathExpression) {
        NodeList selectNodeList = this._xpathProcessor.selectNodeList(context, xpathExpression, RICH_TEXT_PREFIX_RESOLVER);
        ArrayList<Node> toReturn = null;
        if (selectNodeList != null) {
            toReturn = new ArrayList<Node>();
            for (int i = 0; i < selectNodeList.getLength(); ++i) {
                toReturn.add(selectNodeList.item(i));
            }
        }
        return toReturn;
    }

    public Form parseForm(Node formNode) {
        if (!formNode.getNodeName().equals("form") && !"cms".equals(this._getAttribute(formNode, "type"))) {
            throw new IllegalArgumentException("The form node must be of type <form type='cms'>");
        }
        Form form = new Form();
        String id = StringUtils.defaultString((String)this._getAttribute(formNode, "id"));
        String label = StringUtils.defaultString((String)this._getAttribute(formNode, _LABEL_ELEMENT));
        String receiptFieldId = StringUtils.defaultString((String)this._getAttribute(formNode, "receipt_to"));
        String receiptFieldFromAddress = StringUtils.defaultString((String)this._getAttribute(formNode, "receipt_from"));
        String receiptFieldSubject = StringUtils.defaultString((String)this._getAttribute(formNode, "receipt_subject"));
        String receiptFieldBody = StringUtils.defaultString((String)this._getAttribute(formNode, "receipt_body"));
        String redirectTo = StringUtils.defaultString((String)this._getAttribute(formNode, "redirect"));
        String emails = StringUtils.defaultString((String)this._getAttribute(formNode, "processing_emails"));
        String workflowName = StringUtils.defaultString((String)this._getAttribute(formNode, "workflow"));
        String limit = StringUtils.defaultString((String)this._getAttribute(formNode, "limit"));
        String places = StringUtils.defaultString((String)this._getAttribute(formNode, "places"));
        String noPlaces = StringUtils.defaultString((String)this._getAttribute(formNode, "no_places"));
        emails = URIUtils.decode((String)emails);
        HashSet<String> emailSet = new HashSet<String>();
        for (String email : emails.split("[;, \n]")) {
            if (!StringUtils.isNotBlank((String)email)) continue;
            emailSet.add(email.trim());
        }
        this._parseFields(formNode, form);
        form.setId(id);
        form.setLabel(label);
        form.setReceiptFieldId(receiptFieldId);
        form.setReceiptFieldFromAddress(receiptFieldFromAddress);
        form.setReceiptFieldSubject(receiptFieldSubject);
        form.setReceiptFieldBody(receiptFieldBody);
        form.setNotificationEmails(emailSet);
        form.setRedirectTo(redirectTo);
        form.setWorkflowName(workflowName);
        form.setLimit(limit);
        form.setRemainingPlaces(places);
        form.setNoRemainingPlaces(noPlaces);
        return form;
    }

    public String _getAttribute(Node node, String attributeName) {
        NamedNodeMap attributes = node.getAttributes();
        Node idAttribute = attributes.getNamedItem(attributeName);
        String toReturn = idAttribute != null ? idAttribute.getNodeValue() : null;
        return toReturn;
    }

    protected void _parseFields(Node formNode, Form form) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList<Fieldset> fieldsets = new ArrayList<Fieldset>();
        HashMap<String, String> labels = new HashMap<String, String>();
        NodeList nodeList = this._xpathProcessor.selectNodeList(formNode, "descendant::html:*", RICH_TEXT_PREFIX_RESOLVER);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Fieldset fieldset;
            Field field;
            Node node = nodeList.item(i);
            String localName = node.getLocalName();
            if (_LABEL_ELEMENT.equals(localName)) {
                this._processLabel(node, labels);
                continue;
            }
            if (_INPUT_ELEMENT.equals(localName)) {
                field = this._processInput(node);
                if (field == null) continue;
                fields.add(field);
                continue;
            }
            if (_TEXTAREA_ELEMENT.equals(localName)) {
                field = this._processTextarea(node);
                if (field == null) continue;
                fields.add(field);
                continue;
            }
            if (_SELECT_ELEMENT.equals(localName)) {
                field = this._processSelect(node);
                if (field == null) continue;
                fields.add(field);
                continue;
            }
            if (_CAPTCHA_ELEMENT.equals(localName)) {
                field = this._processCaptcha(node);
                if (field == null) continue;
                fields.add(field);
                continue;
            }
            if (!_FIELDSET_ELEMENT.equals(localName) || (fieldset = this._processFieldset(node)) == null) continue;
            fieldsets.add(fieldset);
        }
        for (Field field : fields) {
            if (!labels.containsKey(field.getId())) continue;
            field.setLabel((String)labels.get(field.getId()));
        }
        form.setFields(fields);
        form.setFieldsets(fieldsets);
    }

    protected Fieldset _processFieldset(Node fieldsetNode) {
        Fieldset fieldset = new Fieldset();
        Node legendNode = fieldsetNode.getFirstChild();
        if (_LEGEND_ELEMENT.equals(legendNode.getLocalName())) {
            fieldset.setLabel(legendNode.getTextContent());
        }
        List<Node> fieldNodes = this.getNodesAsList(fieldsetNode, "descendant::html:*");
        for (Node fieldNode : fieldNodes) {
            String id = this._getAttribute(fieldNode, "id");
            if (!StringUtils.isNotEmpty((String)id)) continue;
            fieldset.getFieldIds().add(id);
        }
        return fieldset;
    }

    protected void _processLabel(Node labelNode, Map<String, String> labels) {
        String id = this._getAttribute(labelNode, "for");
        String label = labelNode.getTextContent().trim();
        if (label.endsWith(":")) {
            label = label.substring(0, label.length() - 1).trim();
        }
        if (StringUtils.isNotEmpty((String)id)) {
            labels.put(id, label);
        }
    }

    protected Field _processInput(Node inputNode) {
        Field field = null;
        Field.FieldType type = this._getInputType(inputNode);
        if (type != null) {
            field = new Field(type);
            this._processAttributes(inputNode, field);
        }
        return field;
    }

    protected Field _processTextarea(Node textareaNode) {
        Field field = new Field(Field.FieldType.TEXTAREA);
        this._processAttributes(textareaNode, field);
        return field;
    }

    protected Field _processSelect(Node selectNode) {
        Field field = new Field(Field.FieldType.SELECT);
        this._processAttributes(selectNode, field);
        HashMap<CallSite, String> optionProperties = new HashMap<CallSite, String>();
        List<Node> optionNodes = this.getNodesAsList(selectNode, "html:option");
        int i = 0;
        for (Node optionNode : optionNodes) {
            String value = this._getAttribute(optionNode, "value");
            String cost = this._getAttribute(optionNode, "cost");
            String label = optionNode.getTextContent();
            optionProperties.put((CallSite)((Object)("option-" + i + "-value")), value);
            optionProperties.put((CallSite)((Object)("option-" + i + "-label")), label);
            optionProperties.put((CallSite)((Object)("option-" + i + "-cost")), cost);
            ++i;
        }
        field.getProperties().putAll(optionProperties);
        return field;
    }

    protected Field _processCaptcha(Node captchaNode) {
        Field field = new Field(Field.FieldType.CAPTCHA);
        this._processAttributes(captchaNode, field);
        return field;
    }

    protected Field.FieldType _getInputType(Node inputNode) {
        Field.FieldType type = null;
        String typeAttr = this._getAttribute(inputNode, "type");
        if ("text".equals(typeAttr)) {
            type = Field.FieldType.TEXT;
        } else if ("hidden".equals(typeAttr)) {
            type = Field.FieldType.HIDDEN;
        } else if ("password".equals(typeAttr)) {
            type = Field.FieldType.PASSWORD;
        } else if ("checkbox".equals(typeAttr)) {
            type = Field.FieldType.CHECKBOX;
        } else if ("radio".equals(typeAttr)) {
            type = Field.FieldType.RADIO;
        } else if ("file".equals(typeAttr)) {
            type = Field.FieldType.FILE;
        } else if ("cost".equals(typeAttr)) {
            type = Field.FieldType.COST;
        }
        return type;
    }

    protected void _processAttributes(Node node, Field field) {
        String id = this._getAttribute(node, "id");
        String name = this._getAttribute(node, "name");
        HashMap<String, String> properties = new HashMap<String, String>();
        NamedNodeMap atts = node.getAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            Node attribute = atts.item(i);
            String attrName = attribute.getLocalName();
            if ("id".equals(attrName) || "name".equals(attrName) || "type".equals(attrName)) continue;
            String value = attribute.getNodeValue();
            properties.put(attrName, value);
        }
        field.setId(id);
        field.setName(name);
        field.getProperties().putAll(properties);
    }

    public static class RichTextPrefixResolver
    implements PrefixResolver {
        public static final Map<String, String> NAMESPACES = new HashMap<String, String>();

        public String prefixToNamespace(String prefix) {
            return NAMESPACES.get(prefix);
        }

        static {
            NAMESPACES.put("docbook", "http://docbook.org/ns/docbook");
            NAMESPACES.put("html", "http://www.w3.org/1999/xhtml");
            NAMESPACES.put("xlink", "http://www.w3.org/1999/xlink");
        }
    }
}

