/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.content.workflow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.forms.FormsException;
import org.ametys.plugins.forms.content.Field;
import org.ametys.plugins.forms.content.Form;
import org.ametys.plugins.forms.content.data.FieldValue;
import org.ametys.plugins.forms.content.data.UserEntry;
import org.ametys.plugins.forms.content.jcr.FormPropertiesManager;
import org.ametys.plugins.forms.content.table.FormTableManager;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class MailInformationHelper
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = MailInformationHelper.class.getName();
    protected static final Pattern _EMAIL_PATTERN = SendMailHelper.EMAIL_VALIDATION;
    protected CurrentUserProvider _currentUserProvider;
    protected UserManager _userManager;
    protected FormPropertiesManager _formPropertiesManager;
    protected FormTableManager _formTableManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._userManager = (UserManager)serviceManager.lookup(UserManager.ROLE);
        this._formPropertiesManager = (FormPropertiesManager)((Object)serviceManager.lookup(FormPropertiesManager.ROLE));
        this._formTableManager = (FormTableManager)serviceManager.lookup(FormTableManager.ROLE);
    }

    @Callable
    public Map<String, Object> getMailInfo(String formId, Integer entryId) {
        HashMap<String, Object> sendMail = new HashMap<String, Object>();
        sendMail.put("current-user", this._getSender());
        UserEntry formEntry = this._getFormEntry(formId, entryId);
        sendMail.put("emails", this._getAvailableRecipients(formEntry));
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("send-mail", sendMail);
        return result;
    }

    protected Map<String, Object> _getSender() {
        UserIdentity userIdentity = this._currentUserProvider.getUser();
        User user = this._userManager.getUser(userIdentity);
        HashMap<String, Object> currentUser = new HashMap<String, Object>();
        currentUser.put("email", user.getEmail());
        currentUser.put("fullname", user.getFullName());
        return currentUser;
    }

    protected List<Map<String, String>> _getAvailableRecipients(UserEntry formEntry) {
        ArrayList<Map<String, String>> emails = new ArrayList<Map<String, String>>();
        for (FieldValue fieldValue : formEntry.getValues()) {
            Field field = fieldValue.getField();
            if (!Field.FieldType.TEXT.equals((Object)field.getType())) continue;
            Map<String, String> properties = field.getProperties();
            String value = (String)fieldValue.getValue();
            if (value == null || !"email".equals(properties.get("regexptype")) || !_EMAIL_PATTERN.matcher(value).matches()) continue;
            HashMap<String, Object> email = new HashMap<String, Object>();
            email.put("displayValue", field.getLabel() + ": " + value);
            email.put("value", value);
            emails.add(email);
        }
        return emails;
    }

    protected UserEntry _getFormEntry(String formId, Integer entryId) {
        try {
            Form form = this._formPropertiesManager.getForm(formId);
            Map<String, FieldValue> columns = this._formTableManager.getColumns(form);
            return Optional.ofNullable(this._formTableManager.getSubmission(form, columns, entryId)).orElseThrow(() -> new IllegalArgumentException("Unable to retrieve the workflow id for the entry '" + entryId + "' of the form '" + formId + "'."));
        }
        catch (FormsException e) {
            throw new IllegalArgumentException("An error occured while trying to recover the user entry '" + entryId + "' of the form of id '" + formId + "'.");
        }
    }
}

