/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.dao;

import com.opensymphony.workflow.spi.Step;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import org.ametys.cms.search.model.SystemPropertyExtensionPoint;
import org.ametys.cms.search.ui.model.SearchUIColumn;
import org.ametys.cms.search.ui.model.SearchUIColumnHelper;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.plugins.forms.helper.FormElementDefinitionHelper;
import org.ametys.plugins.forms.helper.LimitedEntriesHelper;
import org.ametys.plugins.forms.question.FormQuestionType;
import org.ametys.plugins.forms.question.types.ChoicesListQuestionType;
import org.ametys.plugins.forms.question.types.FileQuestionType;
import org.ametys.plugins.forms.question.types.MatrixQuestionType;
import org.ametys.plugins.forms.question.types.MultipleAwareFormQuestionType;
import org.ametys.plugins.forms.question.types.RestrictiveQuestionType;
import org.ametys.plugins.forms.question.types.RichTextQuestionType;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.BooleanExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.workflow.repository.WorkflowAwareAmetysObject;
import org.ametys.plugins.workflow.support.WorkflowProvider;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.DefinitionContext;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.parameters.ParametersManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.commons.lang3.StringUtils;

public class FormEntryDAO
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = FormEntryDAO.class.getName();
    public static final String ENTRIES_ROOT = "ametys-internal:form-entries";
    public static final String HANDLE_FORMS_ENTRIES_RIGHT_ID = "Form_Entries_Rights_Data";
    public static final String DELETE_FORMS_ENTRIES_RIGHT_ID = "Runtime_Rights_Forms_Entry_Delete";
    protected AmetysObjectResolver _resolver;
    protected ParametersManager _parametersManager;
    protected ObservationManager _observationManager;
    protected CurrentUserProvider _currentUserProvider;
    protected LimitedEntriesHelper _handleLimitedEntriesHelper;
    protected RightManager _rightManager;
    protected WorkflowProvider _workflowProvider;
    protected UserManager _userManager;
    protected SystemPropertyExtensionPoint _systemPropertyEP;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._parametersManager = (ParametersManager)serviceManager.lookup(ParametersManager.ROLE);
        this._observationManager = (ObservationManager)serviceManager.lookup(ObservationManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._handleLimitedEntriesHelper = (LimitedEntriesHelper)((Object)serviceManager.lookup(LimitedEntriesHelper.ROLE));
        this._rightManager = (RightManager)serviceManager.lookup(RightManager.ROLE);
        this._workflowProvider = (WorkflowProvider)serviceManager.lookup(WorkflowProvider.ROLE);
        this._userManager = (UserManager)serviceManager.lookup(UserManager.ROLE);
        this._systemPropertyEP = (SystemPropertyExtensionPoint)serviceManager.lookup(SystemPropertyExtensionPoint.ROLE);
    }

    public boolean hasHandleDataRightOnForm(UserIdentity userIdentity, AmetysObject formElement) {
        return this._rightManager.hasRight(userIdentity, HANDLE_FORMS_ENTRIES_RIGHT_ID, (Object)formElement) == RightManager.RightResult.RIGHT_ALLOW;
    }

    public void checkHandleDataRight(AmetysObject formElement) {
        UserIdentity user = this._currentUserProvider.getUser();
        if (!this.hasHandleDataRightOnForm(user, formElement)) {
            throw new IllegalAccessError("User '" + user + "' tried to handle form data without convenient right [Form_Entries_Rights_Data]");
        }
    }

    @Callable
    public Map<String, Object> getFormEntryProperties(String id) {
        try {
            FormEntry entry = (FormEntry)this._resolver.resolveById(id);
            return this.getFormEntryProperties(entry);
        }
        catch (UnknownAmetysObjectException e) {
            this.getLogger().warn("Can't find entry with id: {}. It probably has just been deleted", (Object)id, (Object)e);
            HashMap<String, Object> infos = new HashMap<String, Object>();
            infos.put("id", id);
            return infos;
        }
    }

    public Map<String, Object> getFormEntryProperties(FormEntry entry) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("id", entry.getId());
        properties.put("formId", entry.getForm().getId());
        properties.put("rights", this._getUserRights(entry));
        return properties;
    }

    protected Set<String> _getUserRights(FormEntry entry) {
        UserIdentity user = this._currentUserProvider.getUser();
        return this._rightManager.getUserRights(user, (Object)entry);
    }

    public FormEntry createEntry(Form form) {
        ModifiableTraversableAmetysObject entriesRoot = form.hasChild(ENTRIES_ROOT) ? (ModifiableTraversableAmetysObject)form.getChild(ENTRIES_ROOT) : (ModifiableTraversableAmetysObject)form.createChild(ENTRIES_ROOT, "ametys:collection");
        String originalName = "entry";
        String uniqueName = originalName + "-1";
        int index = 2;
        while (entriesRoot.hasChild(uniqueName)) {
            uniqueName = originalName + "-" + index++;
        }
        FormEntry entry = (FormEntry)entriesRoot.createChild(uniqueName, "ametys:form-entry");
        HashMap<String, Form> eventParams = new HashMap<String, Form>();
        eventParams.put("form", form);
        this._observationManager.notify(new Event("form.modified", this._currentUserProvider.getUser(), eventParams));
        return entry;
    }

    @Callable
    public Map<String, Object> getSearchModelConfiguration(String formId) throws ProcessingException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Form form = (Form)this._resolver.resolveById(formId);
        result.put("criteria", this._getCriteria(form));
        result.put("columns", this._getColumns(form));
        result.put("searchUrlPlugin", "forms");
        result.put("searchUrl", "form/entries.json");
        result.put("pageSize", 50);
        return result;
    }

    protected Map<String, Object> _getCriteria(Form form) {
        return Map.of();
    }

    protected List<Map<String, Object>> _getColumns(Form form) throws ProcessingException {
        ArrayList<SearchUIColumn> columns = new ArrayList<SearchUIColumn>();
        Model formEntryModel = this.getFormEntryModel(form);
        ModelItem idAttribute = formEntryModel.getModelItem("ametys-id");
        SearchUIColumn idColumn = SearchUIColumnHelper.createModelItemColumn((ModelItem)idAttribute);
        idColumn.setWidth(80);
        columns.add(idColumn);
        ModelItem userAttribute = formEntryModel.getModelItem("ametys-user");
        SearchUIColumn userColumn = SearchUIColumnHelper.createModelItemColumn((ModelItem)userAttribute);
        userColumn.setWidth(150);
        columns.add(userColumn);
        ModelItem submitDateAttribute = formEntryModel.getModelItem("ametys-submit-date");
        SearchUIColumn submitDateColumn = SearchUIColumnHelper.createModelItemColumn((ModelItem)submitDateAttribute);
        submitDateColumn.setWidth(150);
        columns.add(submitDateColumn);
        for (ModelItem modelItem : formEntryModel.getModelItems()) {
            String modelItemName = modelItem.getName();
            if (modelItemName.equals("ametys-ipAddress") || modelItemName.equals("ametys-active") || modelItemName.equals("ametys-submit-date") || modelItemName.equals("ametys-id") || modelItemName.equals("ametys-user") || modelItemName.startsWith("ametys-other-")) continue;
            SearchUIColumn column = SearchUIColumnHelper.createModelItemColumn((ModelItem)modelItem);
            FormQuestion question = form.getQuestion(modelItemName);
            if (question != null) {
                FormQuestionType type = question.getType();
                column.setRenderer(Optional.ofNullable(type.getJSRenderer(question)).filter(StringUtils::isNotBlank));
                column.setConverter(Optional.ofNullable(type.getJSConverter(question)).filter(StringUtils::isNotBlank));
                column.setSortable(this._isSortable(question));
            }
            columns.add(column);
        }
        ArrayList<Map<String, Object>> columnsInfo = new ArrayList<Map<String, Object>>();
        DefinitionContext definitionContext = DefinitionContext.newInstance();
        for (SearchUIColumn column : columns) {
            columnsInfo.add(column.toJSON(definitionContext));
        }
        if (form.isQueueEnabled()) {
            columnsInfo.add(Map.of("name", "ametys-queue-status", "label", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUEUE_STATUS_COLUMN_TITLE_LABEL"), "type", "boolean", "path", "ametys-queue-status"));
        }
        columnsInfo.add(Map.of("name", "ametys-active", "label", new I18nizableText("plugin.forms", "PLUGINS_FORMS_ENTRY_ACTIVE_COLUMN_TITLE_LABEL"), "type", "boolean", "path", "ametys-active", "hidden", true));
        return columnsInfo;
    }

    protected boolean _isSortable(FormQuestion question) {
        MultipleAwareFormQuestionType multipleType;
        FormQuestionType type = question.getType();
        if (type instanceof MultipleAwareFormQuestionType && (multipleType = (MultipleAwareFormQuestionType)((Object)type)).isMultiple(question)) {
            return false;
        }
        return !(type instanceof MatrixQuestionType) && !(type instanceof RichTextQuestionType) && !(type instanceof FileQuestionType);
    }

    @Callable
    public Map<String, String> deleteEntry(String id) {
        HashMap<String, String> result = new HashMap<String, String>();
        FormEntry entry = (FormEntry)this._resolver.resolveById(id);
        if (this._rightManager.currentUserHasRight(DELETE_FORMS_ENTRIES_RIGHT_ID, (Object)entry) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new IllegalAccessError("User '" + this._currentUserProvider.getUser() + "' tried to delete entries without convenient right [Runtime_Rights_Forms_Entry_Delete]");
        }
        this._handleLimitedEntriesHelper.deactivateEntry(id);
        Form form = entry.getForm();
        entry.remove();
        form.saveChanges();
        HashMap<String, Form> eventParams = new HashMap<String, Form>();
        eventParams.put("form", form);
        this._observationManager.notify(new Event("form.modified", this._currentUserProvider.getUser(), eventParams));
        result.put("entryId", id);
        result.put("formId", form.getId());
        result.put("hasEntries", String.valueOf(form.hasEntries()));
        return result;
    }

    @Callable
    public Map<String, Object> clearEntries(String id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> entryIds = new ArrayList<String>();
        Form form = (Form)this._resolver.resolveById(id);
        if (this._rightManager.currentUserHasRight(DELETE_FORMS_ENTRIES_RIGHT_ID, (Object)form) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new IllegalAccessError("User '" + this._currentUserProvider.getUser() + "' tried to delete entries without convenient right [Runtime_Rights_Forms_Entry_Delete]");
        }
        for (FormEntry entry : form.getEntries()) {
            entryIds.add(entry.getId());
            entry.remove();
        }
        form.saveChanges();
        HashMap<String, Form> eventParams = new HashMap<String, Form>();
        eventParams.put("form", form);
        this._observationManager.notify(new Event("form.modified", this._currentUserProvider.getUser(), eventParams));
        result.put("ids", entryIds);
        result.put("formId", form.getId());
        return result;
    }

    public Long getCurrentStepId(FormEntry entry) throws AmetysRepositoryException {
        WorkflowProvider.AmetysObjectWorkflow workflow = this._workflowProvider.getAmetysObjectWorkflow((WorkflowAwareAmetysObject)entry);
        try {
            Step currentStep = (Step)workflow.getCurrentSteps(entry.getWorkflowId()).iterator().next();
            return currentStep.getStepId();
        }
        catch (AmetysRepositoryException e) {
            return RestrictiveQuestionType.INITIAL_WORKFLOW_ID;
        }
    }

    public Model getFormEntryModel(Form form) {
        ArrayList<Object> items = new ArrayList<Object>();
        for (FormQuestion question : form.getQuestions()) {
            ChoicesListQuestionType cLType;
            ModelItem otherFieldModel;
            FormQuestionType type = question.getType();
            if (type.onlyForDisplay(question)) continue;
            Model entryModel = question.getType().getEntryModel(question);
            for (ModelItem modelItem : entryModel.getModelItems()) {
                items.add(modelItem);
            }
            if (!(type instanceof ChoicesListQuestionType) || (otherFieldModel = (cLType = (ChoicesListQuestionType)type).getOtherFieldModel(question)) == null) continue;
            items.add(otherFieldModel);
        }
        items.add(FormElementDefinitionHelper.getElementDefinition("ametys-id", "long", "PLUGIN_FORMS_MODEL_ITEM_ID_LABEL", null, null));
        items.add(FormElementDefinitionHelper.getElementDefinition("ametys-user", "user", "PLUGIN_FORMS_MODEL_ITEM_USER_LABEL", null, null));
        items.add(FormElementDefinitionHelper.getElementDefinition("ametys-active", "boolean", "PLUGIN_FORMS_MODEL_ITEM_ACTIVE_LABEL", null, null));
        items.add(FormElementDefinitionHelper.getElementDefinition("ametys-submit-date", "datetime", "PLUGIN_FORMS_MODEL_ITEM_SUBMISSION_DATE_LABEL", null, null));
        items.add(FormElementDefinitionHelper.getElementDefinition("ametys-ipAddress", "string", "PLUGIN_FORMS_MODEL_ITEM_IP_LABEL", null, null));
        if (form.hasWorkflow()) {
            items.add((ModelItem)this._systemPropertyEP.getExtension("workflowName"));
            items.add((ModelItem)this._systemPropertyEP.getExtension("workflowStep"));
        }
        return Model.of((String)"form.entry.model.id", (String)"form.entry.model.family.id", (ModelItem[])((ModelItem[])items.toArray(ModelItem[]::new)));
    }

    public List<FormEntry> getFormEntries(Form form, boolean onlyActiveEntries, List<Sort> sorts) {
        return this.getFormEntries(form, onlyActiveEntries, null, sorts);
    }

    public List<FormEntry> getFormEntries(Form form, boolean onlyActiveEntries, Expression additionalEntryFilterExpr, List<Sort> sorts) {
        try {
            String uuid = form.getNode().getIdentifier();
            String xpathQuery = "//element(*, ametys:form)[@jcr:uuid = '" + uuid + "']//element(*, ametys:form-entry)";
            String entryFilterQuery = this._getEntryFilterQuery(onlyActiveEntries, additionalEntryFilterExpr);
            if (onlyActiveEntries || StringUtils.isNotBlank((CharSequence)entryFilterQuery)) {
                xpathQuery = xpathQuery + "[" + entryFilterQuery + "]";
            }
            Object sortsAsString = "";
            for (Sort sort : sorts) {
                if (StringUtils.isNotBlank((CharSequence)sortsAsString)) {
                    sortsAsString = (String)sortsAsString + ", ";
                }
                sortsAsString = (String)sortsAsString + "@ametys:" + sort.attributeName() + " " + sort.direction();
            }
            if (StringUtils.isNotBlank((CharSequence)sortsAsString)) {
                xpathQuery = xpathQuery + " order by " + (String)sortsAsString;
            }
            AmetysObjectIterable formEntries = this._resolver.query(xpathQuery);
            return formEntries.stream().collect(Collectors.toList());
        }
        catch (RepositoryException e) {
            this.getLogger().error("An error occurred getting entries of form '" + form.getId() + "'");
            return List.of();
        }
    }

    private String _getEntryFilterQuery(boolean onlyActiveEntries, Expression additionalEntryFilterExpr) {
        ArrayList<Object> expressions = new ArrayList<Object>();
        if (onlyActiveEntries) {
            expressions.add(new BooleanExpression("ametys-active", true));
        }
        if (additionalEntryFilterExpr != null) {
            expressions.add(additionalEntryFilterExpr);
        }
        return new AndExpression(expressions).build();
    }

    @Callable(rights={"Form_Entries_Rights_Data"}, paramIndex=0, rightContext="right.assignment.context.formsdirectoryaccess")
    public List<Map<String, String>> getFormEntriesUsers(String formId) {
        Form form = (Form)this._resolver.resolveById(formId);
        return this.getFormEntries(form, false, new ArrayList<Sort>()).stream().map(FormEntry::getUser).distinct().map(arg_0 -> ((UserManager)this._userManager).getUser(arg_0)).filter(Objects::nonNull).sorted(Comparator.comparing(User::getFullName, String.CASE_INSENSITIVE_ORDER)).map(u -> Map.of("text", u.getFullName(), "id", UserIdentity.userIdentityToString((UserIdentity)u.getIdentity()))).toList();
    }

    public record Sort(String attributeName, String direction) {
    }
}

