/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.forms.dao.FormEntryDAO;
import org.ametys.plugins.forms.question.FormQuestionType;
import org.ametys.plugins.forms.question.sources.ChoiceOption;
import org.ametys.plugins.forms.question.sources.ChoiceSourceType;
import org.ametys.plugins.forms.question.types.CheckBoxQuestionType;
import org.ametys.plugins.forms.question.types.ChoicesListQuestionType;
import org.ametys.plugins.forms.question.types.MatrixQuestionType;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.plugins.forms.repository.type.Matrix;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.BooleanExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.MetadataExpression;
import org.ametys.plugins.repository.query.expression.NotExpression;
import org.ametys.plugins.repository.query.expression.OrExpression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class FormStatisticsHelper
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = FormStatisticsHelper.class.getName();
    protected AmetysObjectResolver _resolver;
    protected RightManager _rightManager;
    protected FormEntryDAO _formEntryDAO;
    protected I18nUtils _i18nUtils;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._formEntryDAO = (FormEntryDAO)((Object)manager.lookup(FormEntryDAO.ROLE));
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
    }

    @Callable(rights={""})
    public Map<String, Object> getStatistics(String id) {
        Form form = (Form)this._resolver.resolveById(id);
        this._formEntryDAO.checkHandleDataRight((AmetysObject)form);
        return this._getStatistics(form);
    }

    public Map<String, Object> getMiniSurveyStatistics(String id) {
        Form form = (Form)this._resolver.resolveById(id);
        if (form.isMiniSurvey()) {
            return this._getStatistics(form);
        }
        return Map.of("error", "not-a-mini-survey");
    }

    protected Map<String, Object> _getStatistics(Form form) {
        HashMap<String, Object> statistics = new HashMap<String, Object>();
        statistics.put("id", form.getId());
        statistics.put("title", form.getTitle());
        statistics.put("nbEntries", form.getEntries().size());
        statistics.put("questions", this.getStatsToArray(form));
        return statistics;
    }

    public Map<String, Map<String, Map<String, Object>>> getStatsMap(Form form) {
        LinkedHashMap<String, Map<String, Map<String, Object>>> statsMap = new LinkedHashMap<String, Map<String, Map<String, Object>>>();
        List questions = form.getQuestions().stream().filter(this::_displayField).collect(Collectors.toList());
        List<FormEntry> entries = form.getEntries();
        for (FormQuestion question : questions) {
            LinkedHashMap<String, Map<String, Object>> questionValues = new LinkedHashMap<String, Map<String, Object>>();
            statsMap.put(question.getNameForForm(), questionValues);
            if (question.getType() instanceof MatrixQuestionType) {
                this._dispatchMatrixStats(entries, question, questionValues);
                continue;
            }
            FormQuestionType formQuestionType = question.getType();
            if (formQuestionType instanceof ChoicesListQuestionType) {
                ChoicesListQuestionType type = (ChoicesListQuestionType)formQuestionType;
                if (type.getSourceType(question).remoteData()) {
                    this._dispatchChoicesWithRemoteDataStats(form, question, questionValues);
                    continue;
                }
                this._dispatchChoicesStats(form, question, questionValues);
                continue;
            }
            if (question.getType() instanceof CheckBoxQuestionType) {
                this._dispatchBooleanStats(form, entries, question, questionValues);
                continue;
            }
            this._dispatchStats(form, entries, question, questionValues);
        }
        return statsMap;
    }

    public List<Map<String, Object>> getStatsToArray(Form form) {
        Map<String, Map<String, Map<String, Object>>> stats = this.getStatsMap(form);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (String questionNameForForm : stats.keySet()) {
            HashMap<String, Object> questionMap = new HashMap<String, Object>();
            FormQuestion question = form.getQuestion(questionNameForForm);
            Map<String, Map<String, Object>> questionStats = stats.get(questionNameForForm);
            questionMap.put("id", questionNameForForm);
            questionMap.put("title", question.getTitle());
            questionMap.put("type", question.getType().getStorageType(question));
            questionMap.put("typeId", question.getType().getId());
            questionMap.put("mandatory", question.isMandatory());
            ArrayList options = new ArrayList();
            for (String optionId : questionStats.keySet()) {
                HashMap<String, Object> option = new HashMap<String, Object>();
                option.put("id", optionId);
                if (question.getType() instanceof MatrixQuestionType) {
                    MatrixQuestionType type = (MatrixQuestionType)question.getType();
                    option.put("label", type.getRows(question).get(optionId));
                }
                questionStats.get(optionId).entrySet();
                ArrayList choices = new ArrayList();
                for (Map.Entry<String, Object> choice : questionStats.get(optionId).entrySet()) {
                    HashMap<String, Object> choiceMap = new HashMap<String, Object>();
                    String choiceId = choice.getKey();
                    Object choiceOb = choice.getValue();
                    choiceMap.put("value", choiceId);
                    choiceMap.put("label", choiceOb instanceof Option ? ((Option)choiceOb).label() : choiceOb);
                    if (question.getType() instanceof MatrixQuestionType) {
                        MatrixQuestionType type = (MatrixQuestionType)question.getType();
                        choiceMap.put("label", type.getColumns(question).get(choiceId));
                    }
                    choiceMap.put("count", choiceOb instanceof Option ? Long.valueOf(((Option)choiceOb).count()) : choiceOb);
                    choices.add(choiceMap);
                }
                option.put("choices", choices);
                options.add(option);
            }
            questionMap.put("options", options);
            result.add(questionMap);
        }
        return result;
    }

    protected void _dispatchMatrixStats(List<FormEntry> entries, FormQuestion question, Map<String, Map<String, Object>> questionValues) {
        MatrixQuestionType matrixType = (MatrixQuestionType)question.getType();
        Map<String, String> rows = matrixType.getRows(question);
        if (rows != null) {
            for (String option : rows.keySet()) {
                LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
                questionValues.put(option, values);
                Map<String, String> columns = matrixType.getColumns(question);
                if (columns == null) continue;
                for (String column : columns.keySet()) {
                    values.put(column, 0);
                    this._setOptionCount(question.getNameForForm(), entries, values, option, column);
                }
            }
        }
    }

    private void _setOptionCount(String questionId, List<FormEntry> entries, Map<String, Object> values, String rowValue, String columnValue) {
        int columnCount = (Integer)values.get(columnValue);
        for (FormEntry entry : entries) {
            List options;
            Matrix matrix = (Matrix)entry.getValue(questionId);
            if (matrix == null || (options = (List)matrix.get(rowValue)) == null || !options.contains(columnValue)) continue;
            ++columnCount;
        }
        values.put(columnValue, columnCount);
    }

    protected void _dispatchChoicesStats(Form form, FormQuestion question, Map<String, Map<String, Object>> questionValues) {
        LinkedHashMap<String, Option> values = new LinkedHashMap<String, Option>();
        questionValues.put("values", values);
        ChoicesListQuestionType type = (ChoicesListQuestionType)question.getType();
        ChoiceSourceType sourceType = type.getSourceType(question);
        try {
            Option choiceAttributes;
            HashMap<String, Object> enumParam = new HashMap<String, Object>();
            enumParam.put("question", (Object)question);
            Map options = sourceType.getTypedEntries(enumParam);
            for (ChoiceOption option : options.keySet()) {
                String optionValue = (String)option.getValue();
                StringExpression expr = new StringExpression(question.getNameForForm(), Expression.Operator.EQ, optionValue);
                long countOption = this._formEntryDAO.getFormEntries(form, false, (Expression)expr, List.of()).size();
                Option choiceAttributes2 = new Option(options.get(option).getLabel(), countOption);
                values.put(optionValue, choiceAttributes2);
            }
            if (type.hasOtherOption(question)) {
                AndExpression expr = new AndExpression(new Expression[]{new MetadataExpression("ametys-other-" + question.getNameForForm()), new NotExpression((Expression)new StringExpression("ametys-other-" + question.getNameForForm(), Expression.Operator.EQ, ""))});
                long countOtherOption = this._formEntryDAO.getFormEntries(form, false, (Expression)expr, List.of()).size();
                choiceAttributes = new Option("__internal_other", countOtherOption);
                values.put("__internal_other", choiceAttributes);
            }
            if (!type.isMandatory(question)) {
                ArrayList<OrExpression> exprs = new ArrayList<OrExpression>();
                exprs.add(new OrExpression(new Expression[]{new NotExpression((Expression)new MetadataExpression(question.getNameForForm())), new StringExpression(question.getNameForForm(), Expression.Operator.EQ, "")}));
                if (type.hasOtherOption(question)) {
                    exprs.add(new OrExpression(new Expression[]{new NotExpression((Expression)new MetadataExpression("ametys-other-" + question.getNameForForm())), new StringExpression("ametys-other-" + question.getNameForForm(), Expression.Operator.EQ, "")}));
                }
                long countOtherOption = this._formEntryDAO.getFormEntries(form, false, (Expression)new AndExpression(exprs), List.of()).size();
                choiceAttributes = new Option("__internal_not_answered", countOtherOption);
                values.put("_no_answer", choiceAttributes);
            }
        }
        catch (Exception e) {
            this.getLogger().error("An error occurred while trying to get choices options for question " + question.getId(), (Throwable)e);
        }
    }

    protected void _dispatchChoicesWithRemoteDataStats(Form form, FormQuestion question, Map<String, Map<String, Object>> questionValues) {
        LinkedHashMap<String, Option> values = new LinkedHashMap<String, Option>();
        questionValues.put("values", values);
        ChoicesListQuestionType type = (ChoicesListQuestionType)question.getType();
        ChoiceSourceType sourceType = type.getSourceType(question);
        try {
            Option choiceAttributes;
            long otherCount = 0L;
            long noAnswer = 0L;
            String nameForForm = question.getNameForForm();
            LinkedHashMap stats = new LinkedHashMap();
            for (Object entry : form.getEntries()) {
                List vals = entry.getValue(nameForForm) != null ? (entry.isMultiple(nameForForm) ? Arrays.asList((Object[])entry.getValue(nameForForm)) : List.of(entry.getValue(nameForForm))) : List.of();
                for (Object value : vals) {
                    Long count = stats.getOrDefault(value, 0L);
                    stats.put(value, count + 1L);
                }
                if (type.hasOtherOption(question) && StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue("ametys-other-" + nameForForm)))) {
                    ++otherCount;
                    continue;
                }
                if (!vals.isEmpty()) continue;
                ++noAnswer;
            }
            HashMap<String, Object> enumParam = new HashMap<String, Object>();
            enumParam.put("question", (Object)question);
            for (Object value : stats.keySet()) {
                I18nizableText entry = sourceType.getEntry(new ChoiceOption(value), enumParam);
                if (entry == null) continue;
                Option choiceAttributes2 = new Option(this._i18nUtils.translate((I18nizable)entry), (Long)stats.get(value));
                values.put(value.toString(), choiceAttributes2);
            }
            if (otherCount > 0L) {
                choiceAttributes = new Option("__internal_other", otherCount);
                values.put("__internal_other", choiceAttributes);
            }
            if (noAnswer > 0L) {
                choiceAttributes = new Option("__internal_not_answered", noAnswer);
                values.put("_no_answer", choiceAttributes);
            }
        }
        catch (Exception e) {
            this.getLogger().error("An error occurred while trying to get choices options for question " + question.getId(), (Throwable)e);
        }
    }

    protected void _dispatchBooleanStats(Form form, List<FormEntry> entries, FormQuestion question, Map<String, Map<String, Object>> questionValues) {
        LinkedHashMap<String, Integer> values = new LinkedHashMap<String, Integer>();
        questionValues.put("values", values);
        BooleanExpression booleanExpr = new BooleanExpression(question.getNameForForm(), true);
        int totalTrue = this._formEntryDAO.getFormEntries(form, false, (Expression)booleanExpr, List.of()).size();
        values.put("true", totalTrue);
        values.put("false", entries.size() - totalTrue);
    }

    protected void _dispatchStats(Form form, List<FormEntry> entries, FormQuestion question, Map<String, Map<String, Object>> questionValues) {
        LinkedHashMap<String, Integer> values = new LinkedHashMap<String, Integer>();
        questionValues.put("values", values);
        AndExpression expr = new AndExpression(new Expression[]{new MetadataExpression(question.getNameForForm()), new NotExpression((Expression)new StringExpression(question.getNameForForm(), Expression.Operator.EQ, ""))});
        int totalAnswered = this._formEntryDAO.getFormEntries(form, false, (Expression)expr, List.of()).size();
        values.put("answered", totalAnswered);
        values.put("empty", entries.size() - totalAnswered);
    }

    private boolean _displayField(FormQuestion question) {
        FormQuestionType type = question.getType();
        return type.canBeAnsweredByUser(question);
    }

    public record Option(String label, long count) {
    }
}

