/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This controller allows to limit submission to the current selected form<br/>
 * The button's icon represents the current opening status of the form.
 * @private
 */
Ext.define('Ametys.plugins.forms.controllers.LimitEntriesController', {
	extend: 'Ametys.plugins.forms.controllers.FormController',
	
	updateState: function()
	{
        this.toggle(false);
        this.setIconDecorator(null);
        
        this.callParent(arguments);
	},
    
    getAdditionnalDescription: function(matchingTarget)
    {
        var params = matchingTarget.getParameters();
        
        var limitDescription = "";
        if (params.isLimitedToOneEntryByUser)
        {
            limitDescription = this._addDescription(limitDescription, "{{i18n PLUGINS_FORMS_FORM_LIMITED_ONE_ENTRY_BY_USER_MSG}}");
        }           
        
        if (params.isEntriesLimited)
        {
            limitDescription = this._addDescription(limitDescription, Ext.String.format("{{i18n PLUGINS_FORMS_FORM_LIMITED_MAX_ENTRIES_MSG}}", params.maxEntries));
            if (params.isQueueEnabled)
            {
                if (params.queueSize != null)
                {
                    limitDescription = this._addDescription(limitDescription, Ext.String.format("{{i18n PLUGINS_FORMS_FORM_LIMITED_QUEUE_LIMITED_MSG}}", params.queueSize));
                }
                else
                {
                    limitDescription = this._addDescription(limitDescription, "{{i18n PLUGINS_FORMS_FORM_LIMITED_QUEUE_UNLIMITED_MSG}}");
                }
            }
            
            if (params.nbEntries >= params.maxEntries)
	        {
                limitDescription += "<br/>"; 
	            limitDescription = this._addDescription(limitDescription, "{{i18n PLUGINS_FORMS_FORM_LIMITED_MAX_ENTRY_REACH_MSG}}");
	            if (params.isQueueEnabled && params.queueSize != null && params.nbEntries >= (params.maxEntries + params.queueSize))
	            {
	                limitDescription = this._addDescription(limitDescription, "{{i18n PLUGINS_FORMS_FORM_LIMITED_QUEUE_REACH_MSG}}");
	            }
	            else if (params.isQueueEnabled)
	            {
	                limitDescription = this._addDescription(limitDescription, "{{i18n PLUGINS_FORMS_FORM_LIMITED_QUEUE_OPEN_MSG}}");
	            }
	        }
        }
        
        this.toggle(params.isEntriesLimited || params.isLimitedToOneEntryByUser);
        this._setIconDecorator(params);
        
        return limitDescription;
    },
	
	/**
     * @private
     */
    _addDescription: function(description, text)
    {
        if (description != "") 
        { 
            description += "<br/>"; 
        }
        description += text;
        
        return description;
    },
	
	/**
     * @private
     * Set the icon decorator
     * @param {Object} params the form parameters
     */
	_setIconDecorator: function(params)
	{
        var decorator = null;
        
        if (params.isEntriesLimited)
        {
            if (params.isQueueEnabled)
            {
                decorator = params.queueSize != null && params.nbEntries >= (params.maxEntries + params.queueSize) 
                    ? "decorator-ametysicon-sign-raw-cross"
                    : "decorator-ametysicon-check34";
            }
            else
            {
                decorator = params.nbEntries >= params.maxEntries 
                    ? "decorator-ametysicon-sign-raw-cross"
                    : "decorator-ametysicon-check34";
            }
        }
        
        this.setIconDecorator(decorator);
    }
});