<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:exslt="http://exslt.org/common"
                xmlns:stringutils="org.ametys.core.util.StringUtils"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                extension-element-prefixes="ametys stringutils">
    
    <xsl:param name="contextPath" />
    <xsl:param name="cms-context" />
    <xsl:param name="plugin" />
    <xsl:param name="site" />
    
    
    <xsl:variable name="rowspan-max">
        <xsl:choose>
            <xsl:when test="/xml/form//question[@type = 'form.Matrix']">3</xsl:when> 
            <xsl:when test="/xml/form//question[@type = 'form.ChoicesList']">2</xsl:when>
            <xsl:otherwise>1</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="date-format" select="ametys:translate('plugin.forms:PLUGINS_FORMS_SERVICE_DASHBOARD_DATE_FORMAT')"></xsl:variable>
    <xsl:variable name="date-time-format" select="ametys:translate('plugin.forms:PLUGINS_FORMS_SERVICE_DASHBOARD_DATE_TIME_FORMAT')"></xsl:variable>
    
    <xsl:template match="/xml">
        <html>
            <head/>
            <body>
                <table>
                    <thead>
                        <tr>
                            <th><i18n:text i18n:key="PLUGINS_FORMS_ENTRIES_EXPORT_SUBMITTED_AT"/></th>
                            <th><i18n:text i18n:key="PLUGIN_FORMS_MODEL_ITEM_USER_LABEL"/></th>
                            <xsl:if test="form/@hasWorkflow">
                                <th><i18n:text i18n:key="PLUGINS_FORMS_ENTRIES_EXPORT_WORKFLOW_STATUS"/></th>
                            </xsl:if>
                            <xsl:apply-templates select="form//question[@onlyForDisplay != 'true']" mode="header"/>
                        </tr>
                        <xsl:if test="$rowspan-max &gt; 1">
                            <tr>
                                <th></th>
                                <th></th>
                                <xsl:if test="form/@hasWorkflow">
                                    <th></th>
                                </xsl:if>
                                <xsl:apply-templates select="form//question[@onlyForDisplay != 'true']" mode="header-secondrow"/>
                            </tr>
                        </xsl:if>
                        <xsl:if test="$rowspan-max &gt; 2">
                            <tr>
                                <th></th>
                                <th></th>
                                <xsl:if test="form/@hasWorkflow">
                                    <th></th>
                                </xsl:if>
                                <xsl:apply-templates select="form//question[@onlyForDisplay != 'true']" mode="header-thirdrow"/>
                            </tr>
                        </xsl:if>
                    </thead>
                    <tbody>
                       <xsl:apply-templates select="form-entries/entry"/>
                    </tbody>
                </table>
            </body>
        </html>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.Matrix']" mode="header">
        <th>
            <xsl:attribute name="colspan">
                <xsl:value-of select="count(additional-infos/options/option) * count(additional-infos/columns/column)"/>
            </xsl:attribute>
            <xsl:value-of select="title"/>
        </th>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.ChoicesList']" mode="header">
        <th colspan="2">
            <xsl:value-of select="title"/>
        </th>
    </xsl:template>
    
    <xsl:template match="question" mode="header">
        <th>
            <xsl:value-of select="title"/>
        </th>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.Matrix']" mode="header-secondrow">
        <xsl:for-each select="additional-infos/options/option">  
            <th>
                <xsl:attribute name="colspan"><xsl:value-of select="count(../../columns/column)"/></xsl:attribute>
                <xsl:value-of select="."/>
            </th>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.ChoicesList']" mode="header-secondrow">
        <th><i18n:text i18n:key="PLUGINS_FORMS_EXPORT_XLS_CHOICE_LIST_VALUE"/></th>
        <th><i18n:text i18n:key="PLUGINS_FORMS_EXPORT_XLS_CHOICE_LIST_LABEL"/></th>
    </xsl:template>
    
    <xsl:template match="question" mode="header-secondrow">
        <th></th>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.Matrix']" mode="header-thirdrow">
        <xsl:for-each select="additional-infos/options/option">  
            <xsl:for-each select="../../columns/column">    
                <th><xsl:value-of select="."/></th>
            </xsl:for-each>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.ChoicesList']" mode="header-thirdrow">
        <th></th>
        <th></th>
    </xsl:template>
    
    <xsl:template match="question" mode="header-thirdrow">
        <th></th>
    </xsl:template>
    
    <xsl:template match="entry">
        <tr>
            <xsl:apply-templates select="." mode="submit-date"/>
            <xsl:apply-templates select="." mode="author"/>
            <xsl:apply-templates select="." mode="status"/>
            
            <xsl:variable name="entryNode" select="."/>
            <xsl:apply-templates select="/xml/form//question" mode="value">
                <xsl:with-param name="entryNode" select="exslt:node-set($entryNode)"/>
            </xsl:apply-templates>
        </tr>
    </xsl:template>
    
    <xsl:template match="entry" mode="submit-date">
        <td>
            <xsl:if test="normalize-space(@creationDate) != ''">
                <i18n:date-time src-pattern="yyyy-MM-dd'T'HH:mm:ss" pattern="medium"><xsl:value-of select="@creationDate"/></i18n:date-time>
            </xsl:if>
        </td>
    </xsl:template>
    
    <xsl:template match="entry" mode="author">
        <td>
            <xsl:choose>
                <xsl:when test="@user"><xsl:value-of select="@user"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="@userId"/></xsl:otherwise>
            </xsl:choose>
        </td>
    </xsl:template>
    <xsl:template match="entry" mode="status">
        <xsl:if test="@status">
            <td>
                <xsl:value-of select="@status"/>
            </td>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="question" mode="value">
        <xsl:param name="entryNode"/>

        <xsl:variable name="questionName" select="@name"/>
        <xsl:apply-templates select="$entryNode/field[@name=$questionName]" />
    </xsl:template>
    
    <xsl:template match="field">
        <xsl:variable name="fieldName" select="@name"/>

        <xsl:choose>
             <xsl:when test="*[local-name() = $fieldName]">
                 <xsl:apply-templates select="."  mode="value" />
             </xsl:when>
             <xsl:otherwise>
                <xsl:apply-templates select="/xml/form//question[@name=$fieldName]" mode="no-value"/>
             </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="field[@typeId='form.ChoicesList']">
        <xsl:variable name="fieldName" select="@name"/>
        
        <xsl:choose>
             <xsl:when test="*[local-name() = $fieldName] or additional-infos/other">
                 <xsl:apply-templates select="."  mode="value"/> 
             </xsl:when>
             <xsl:otherwise>
                <xsl:variable name="fieldName" select="@name"/>
                <xsl:apply-templates select="/xml/form//question[@name=$fieldName]" mode="no-value"/>
             </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="field[@typeId='form.Matrix']">
         <xsl:choose>
             <xsl:when test="value">
                 <xsl:apply-templates select="."  mode="value"/> 
             </xsl:when>
             <xsl:otherwise>
                <xsl:variable name="fieldName" select="@name"/>
                <xsl:apply-templates select="/xml/form//question[@name=$fieldName]" mode="no-value"/>
             </xsl:otherwise>
         </xsl:choose>
    </xsl:template>
    
    <xsl:template match="field[@type='file']" mode="value">
        <xsl:variable name="fieldName" select="@name"/>
        <td>
            <xsl:value-of select="*[local-name() = $fieldName]/@filename" />
        </td>
    </xsl:template>
    
    <xsl:template match="field[@type='datetime']" mode="value">
        <xsl:variable name="fieldName" select="@name"/>
        <td>
            <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$date-time-format}" value="{*[local-name() = $fieldName]}"/>
        </td>
    </xsl:template>
    
    <xsl:template match="field[@type='date']" mode="value">
        <xsl:variable name="fieldName" select="@name"/>
        <td>
            <i18n:date src-pattern="yyyy-MM-dd" pattern="{$date-format}" value="{*[local-name() = $fieldName]}"/>
        </td>
    </xsl:template>
    
    <xsl:template match="field[@type='boolean']" mode="value">
        <xsl:variable name="fieldName" select="@name"/>
        <td>
            <xsl:choose>
                <xsl:when test="*[local-name() = $fieldName] = 'true'">
                    <i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_ENTRY_BOOLEAN_TRUE" i18n:catalogue="plugin.forms"/>
                </xsl:when>
                <xsl:otherwise> <i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_ENTRY_BOOLEAN_FALSE" i18n:catalogue="plugin.forms"/></xsl:otherwise>
            </xsl:choose>
        </td>
    </xsl:template>
    
    <xsl:template match="field[@type='matrix']" mode="value">
        <xsl:for-each select="additional-infos/options/option">
            <xsl:for-each select="value">
                <td>
                    <xsl:choose>
                        <xsl:when test="@checked = 'true'"><i18n:text i18n:key="PLUGINS_FORMS_EXPORT_XLS_CHECKED"/></xsl:when>
                        <xsl:otherwise><i18n:text i18n:key="PLUGINS_FORMS_EXPORT_XLS_UNCHECKED"/></xsl:otherwise>
                    </xsl:choose>
                </td>
            </xsl:for-each>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="field[@typeId='form.ChoicesList']" mode="value">
        <xsl:variable name="fieldName" select="@name"/>
        <xsl:variable name="question" select="/xml/form//question[@name=$fieldName]" />
        <xsl:variable name="type" select="$question/source-type/@value" />
        <xsl:variable name="values" select="*[local-name() = $fieldName]" />
        <td>
            <xsl:for-each select="$values">
                <xsl:if test="position() != 1"><br/></xsl:if>
                <xsl:call-template name="choice-list-value">
                    <xsl:with-param name="type" select="$type" />
                    <xsl:with-param name="value" select="." />
                </xsl:call-template>
            </xsl:for-each>
            <xsl:if test="$question/other-option = 'true' and additional-infos/other != ''">
                <xsl:if test="count($values) > 0"><br/></xsl:if>
                <xsl:value-of select="stringutils:sanitizeXlsHtml(additional-infos/other)" />
            </xsl:if>
        </td>
        <td>
            <xsl:for-each select="$values">
                <xsl:variable name="value" select="." />
                <xsl:if test="position() != 1"><br/></xsl:if>
                <xsl:call-template name="choice-list-label">
                    <xsl:with-param name="type" select="$type" />
                    <xsl:with-param name="label" select="$question/additional-infos/options/option[@value=$value]/label" />
                </xsl:call-template>
            </xsl:for-each>
            <xsl:if test="$question/other-option = 'true' and additional-infos/other != ''">
                <xsl:if test="count($values) > 0"><br/></xsl:if>
                <xsl:value-of select="stringutils:sanitizeXlsHtml(additional-infos/other)" />
            </xsl:if>
        </td>
    </xsl:template>
    
    <xsl:template name="choice-list-value">
        <xsl:param name="type" />
        <xsl:param name="value" />
        
        <xsl:choose>
            <xsl:when test="$type = 'org.ametys.plugins.forms.question.sources.UsersSourceType'">
                <xsl:value-of select="concat(@login, '#', @populationId)" />
            </xsl:when>
            <xsl:when test="$type = 'org.ametys.plugins.forms.question.sources.TableRefSourceType'">
                <xsl:value-of select="@id" />
            </xsl:when>
            <xsl:otherwise><xsl:value-of select="$value" /></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="choice-list-label">
        <xsl:param name="type" />
        <xsl:param name="label" />
        
        <xsl:choose>
            <xsl:when test="$type = 'org.ametys.plugins.forms.question.sources.UsersSourceType'">
                <xsl:value-of select="stringutils:sanitizeXlsHtml(.)" />
            </xsl:when>
            <xsl:when test="$type = 'org.ametys.plugins.forms.question.sources.TableRefSourceType'">
                <xsl:value-of select="stringutils:sanitizeXlsHtml(@title)" />
            </xsl:when>
            <xsl:otherwise><xsl:value-of select="stringutils:sanitizeXlsHtml($label)" /></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="field" mode="value">
        <td>
            <xsl:value-of select="stringutils:sanitizeXlsHtml(.)" />
        </td>
    </xsl:template>
    
    <xsl:template match="question[@type='form.Matrix']" mode="no-value" >
        <xsl:for-each select="additional-infos/options/option">
             <xsl:for-each select="../../columns/column">  
                <td/>
            </xsl:for-each>
        </xsl:for-each>
    </xsl:template>
    
     <xsl:template match="question[@type='form.ChoicesList']" mode="no-value" >
        <td/>
        <td/>
    </xsl:template>
    
    <xsl:template match="question" mode="no-value">
        <td/>
    </xsl:template>
</xsl:stylesheet>