/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.content;

import org.apache.cocoon.xml.AttributesImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import org.ametys.cms.contenttype.DockbookUpdateHandler;
import org.ametys.web.repository.content.SharedContent;

/**
 * This handler look for CMS forms in a RichText.
 * It must be used after a copy of a Content to changes theses references if necessary.
 */
public class FormDocbookUpdateHandler extends DockbookUpdateHandler
{
    @Override
    public void startElement(String uri, String loc, String raw, Attributes attrs) throws SAXException
    {
        if (!(_createdContent instanceof SharedContent) && "form".equals(loc))
        {
            Attributes newAttrs = _getAttributesForForm(attrs);
            super.startElement(uri, loc, raw, newAttrs);
            return;
        }
        
        super.startElement(uri, loc, raw, attrs);
    }
    
    /**
     * Get attributes for media objects such as image, flash
     * @param attrs the attributes
     * @return the new attributes
     */
    protected Attributes _getAttributesForForm (Attributes attrs)
    {
        String type = attrs.getValue("type");
        if (!(_createdContent instanceof SharedContent) && "cms".equals(type))
        {
            String updateId = _generateFormId();
            
            AttributesImpl newAttrs = new AttributesImpl();
            _copyAttributes(attrs, newAttrs);
            newAttrs.addAttribute("", "id", "id", "CDATA", updateId);
         
            return newAttrs;
        }
        else
        {
            return attrs;
        }
        
    }
    
    /**
     * Copy attributes
     * @param attrs the attributes to copy
     * @param newAttrs the new attributes
     */
    protected void _copyAttributes(Attributes attrs, AttributesImpl newAttrs)
    {
        for (int i = 0; i < attrs.getLength(); i++)
        {
            String name = attrs.getQName(i);
            
            if (!"id".equals(name))
            {
                newAttrs.addAttribute(attrs.getURI(i), attrs.getLocalName(i), name, attrs.getType(i), attrs.getValue(i));
            }
        }
    }
    
    /**
     * Generate a new form id
     * @return a form id
     */
    protected String _generateFormId ()
    {
        // random 15-digit number 
        long random = Math.round((Math.random() * 0.9 + 0.1) * Math.pow(10, 15));
        return "form_" + String.valueOf(random);
    }
}
