/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.question;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceFactory;

import org.ametys.cms.transformation.docbook.DocbookEnhancementSource;

/**
 * This factory return files upon the DocbookEnhancementExtensionPoint.
 * <ul>
 *  <li>htmleditor2docbook.xsl</li>
 *  <li>docbook2htmleditor.xsl</li>
 * </ul> 
 */
public class FormQuestionSourceFactory implements SourceFactory, Serviceable
{
    private long _timestamp = System.currentTimeMillis();
    private FormQuestionTypeExtensionPoint _formQuestionTypeExtensionPoint;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        _formQuestionTypeExtensionPoint = (FormQuestionTypeExtensionPoint) manager.lookup(FormQuestionTypeExtensionPoint.ROLE);
    }
    
    @Override
    public Source getSource(String location, Map parameters) throws IOException, MalformedURLException
    {
        if (location.endsWith("://formQuestion2html.xsl"))
        {
            return new DocbookEnhancementSource(location, _formQuestionTypeExtensionPoint.getQuestions2htmlXSLT(), _timestamp);
        }
            
        return null;
    }

    @Override
    public void release(Source source)
    {
        // empty
    }
}
