/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.question.types;

import org.ametys.plugins.forms.helper.FormElementDefinitionHelper;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.type.ModelItemTypeConstants;

/**
 * Provide all the necessary method to make a question type multiple or not
 */
public interface MultipleAwareFormQuestionType
{
    /** Constant for multiple attribute. */
    public static final String ATTRIBUTE_MULTIPLE = "multiple";
    
    /**
     * Get the model item to add to the model items return by the method FormQuestionType.getModel
     * @return the model item
     */
    public default ModelItem getMultipleModelItem()
    {
        return FormElementDefinitionHelper.getElementDefinition(ATTRIBUTE_MULTIPLE, ModelItemTypeConstants.BOOLEAN_TYPE_ID, "PLUGINS_FORMS_QUESTIONS_DIALOG_CHOICE_MULTIPLE", "PLUGINS_FORMS_QUESTIONS_DIALOG_CHOICE_MULTIPLE_DESC", null);
    }
    
    /**
     * Create a view element to add in the view elements returned by FormQuestionType.getView
     * @param model the model link to the view
     * @return a view element
     */
    public default ViewElement getMultipleViewElement(Model model)
    {
        ViewElement mandatory = new ViewElement();
        mandatory.setDefinition((ElementDefinition< ? >) model.getModelItem(ATTRIBUTE_MULTIPLE));
        return mandatory;
    }

    /**
     * Check if the question is actually multiple
     * @param question the question to check
     * @return true if the question is multiple
     */
    public default boolean isMultiple(FormQuestion question)
    {
        return question.getValue(ATTRIBUTE_MULTIPLE, false, false);
    }
}
