/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.content;

import com.opensymphony.workflow.Workflow;
import com.opensymphony.workflow.WorkflowException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.data.RichText;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.forms.FormsException;
import org.ametys.plugins.forms.content.Form;
import org.ametys.plugins.forms.content.data.FieldValue;
import org.ametys.plugins.forms.content.data.UserEntry;
import org.ametys.plugins.forms.content.jcr.FormPropertiesManager;
import org.ametys.plugins.forms.content.table.FormTableManager;
import org.ametys.plugins.forms.content.workflow.FormParser;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.impl.DataHolderHelper;
import org.ametys.plugins.workflow.store.JdbcWorkflowStore;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.plugins.workflow.support.WorkflowProvider;
import org.ametys.web.repository.content.WebContent;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.excalibur.xml.dom.DOMParser;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FormManager
extends AbstractLogEnabled
implements Component,
Serviceable,
Contextualizable {
    public static final String ROLE = FormManager.class.getName();
    public static final String ENTRY_WORKFLOW_REINITIALIZATION = "workflowEntryReinitialization";
    private static final String __FORM_TYPE_CMS = "//html:form[@type='cms']";
    private ServiceManager _manager;
    private FormPropertiesManager _formPropertiesManager;
    private DOMParser _parser;
    private FormParser _formParser;
    private FormTableManager _formTableManager;
    private WorkflowProvider _workflowProvider;
    private JdbcWorkflowStore _jdbcWorkflowStore;
    private WorkflowHelper _workflowHelper;
    private Context _context;

    public void service(ServiceManager smanager) throws ServiceException {
        this._manager = smanager;
        this._parser = (DOMParser)smanager.lookup(DOMParser.ROLE);
        XPathProcessor processor = (XPathProcessor)smanager.lookup(XPathProcessor.ROLE);
        this._formParser = new FormParser(processor);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    private FormPropertiesManager getFormPropertiesManager() {
        if (this._formPropertiesManager == null) {
            try {
                this._formPropertiesManager = (FormPropertiesManager)((Object)this._manager.lookup(FormPropertiesManager.ROLE));
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
        return this._formPropertiesManager;
    }

    private FormTableManager getFormTableManager() {
        if (this._formTableManager == null) {
            try {
                this._formTableManager = (FormTableManager)this._manager.lookup(FormTableManager.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
        return this._formTableManager;
    }

    private WorkflowProvider getWorkflowProvider() {
        if (this._workflowProvider == null) {
            try {
                this._workflowProvider = (WorkflowProvider)this._manager.lookup(WorkflowProvider.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
        return this._workflowProvider;
    }

    private WorkflowHelper getWorkflowHelper() {
        if (this._workflowHelper == null) {
            try {
                this._workflowHelper = (WorkflowHelper)this._manager.lookup(WorkflowHelper.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
        return this._workflowHelper;
    }

    private JdbcWorkflowStore getJdbcWorkflowStore() {
        if (this._jdbcWorkflowStore == null) {
            try {
                this._jdbcWorkflowStore = (JdbcWorkflowStore)this._manager.lookup(JdbcWorkflowStore.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
        return this._jdbcWorkflowStore;
    }

    public void processContentForms(Content content) throws SAXException, IOException, WorkflowException {
        String contentName = content.getName();
        String siteName = "";
        if (content instanceof WebContent) {
            siteName = ((WebContent)content).getSiteName();
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Processing the forms for content '" + contentName + "'");
        }
        ArrayList<Form> forms = new ArrayList<Form>();
        Set<RichText> richTexts = this._getRichTexts((ModelAwareDataHolder)content);
        for (RichText richText : richTexts) {
            InputStream contentStream = richText.getInputStream();
            Document document = this._parser.parseDocument(new InputSource(contentStream));
            List<Node> formNodes = this._formParser.getNodesAsList(document, __FORM_TYPE_CMS);
            for (Node formNode : formNodes) {
                this._processForm(content, contentName, siteName, forms, formNode);
            }
        }
        this._removeUnusedForms(content, contentName, forms);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Forms processed for content '" + contentName + "'");
        }
    }

    private void _processForm(Content content, String contentName, String siteName, List<Form> forms, Node formNode) throws WorkflowException {
        try {
            String oldWorkflowName;
            Form form = this._formParser.parseForm(formNode);
            forms.add(form);
            Form oldForm = this.getFormPropertiesManager().getForm(siteName, form.getId());
            String newWorkflowName = StringUtils.defaultString((String)form.getWorkflowName());
            if (oldForm != null && !newWorkflowName.equals(StringUtils.defaultString((String)(oldWorkflowName = oldForm.getWorkflowName())))) {
                boolean dropColumn = StringUtils.isEmpty((String)newWorkflowName) && this.getFormTableManager().hasWorkflowIdColumn(form.getId());
                boolean addColumn = StringUtils.isNotEmpty((String)newWorkflowName) && !this.getFormTableManager().hasWorkflowIdColumn(form.getId());
                this._resetWorkflowTables(content, form, dropColumn, addColumn);
            }
            if (StringUtils.isNotBlank((String)form.getLabel()) && !this.getFormTableManager().createTable(form)) {
                this.getLogger().error("The form " + form.getLabel() + " was not created in the database.");
            }
            if (oldForm == null) {
                this.getFormPropertiesManager().createForm(siteName, form, content);
                if (StringUtils.isNotEmpty((String)newWorkflowName)) {
                    this.getFormTableManager().addWorkflowIdColumn(form.getId());
                }
            } else {
                this.getFormPropertiesManager().updateForm(siteName, form, content);
            }
        }
        catch (FormsException e) {
            this.getLogger().error("Error trying to store a form in the content " + contentName + " (" + content.getId() + ")", (Throwable)e);
        }
        catch (SQLException e) {
            this.getLogger().error("Error trying to store a form in the content " + contentName + " (" + content.getId() + ")", (Throwable)e);
        }
    }

    private void _resetWorkflowTables(Content content, Form form, boolean dropColumn, boolean addColumn) throws FormsException, WorkflowException, SQLException {
        if (addColumn) {
            this.getFormTableManager().addWorkflowIdColumn(form.getId());
        }
        List<UserEntry> submissions = this.getFormTableManager().getSubmissions(form, new HashMap<String, FieldValue>(), 0, Integer.MAX_VALUE, null);
        Workflow workflow = this.getWorkflowProvider().getExternalWorkflow(JdbcWorkflowStore.ROLE);
        for (UserEntry submission : submissions) {
            Integer workflowId = submission.getWorkflowId();
            if (workflowId != null && workflowId != 0) {
                this.getJdbcWorkflowStore().clearHistory((long)workflowId.intValue());
                this.getJdbcWorkflowStore().deleteInstance((long)workflowId.intValue());
            }
            if (!this.getFormTableManager().hasWorkflowIdColumn(form.getId()) || dropColumn) continue;
            String workflowName = form.getWorkflowName();
            int initialActionId = this.getWorkflowHelper().getInitialAction(workflowName);
            HashMap<String, Object> inputs = new HashMap<String, Object>();
            inputs.put("formId", form.getId());
            inputs.put("entryId", String.valueOf(submission.getId()));
            inputs.put("contentId", content.getId());
            inputs.put(ENTRY_WORKFLOW_REINITIALIZATION, true);
            inputs.put("parent-context", this._context);
            inputs.put("request", ContextHelper.getRequest((Context)this._context));
            long newWorkflowId = workflow.initialize(workflowName, initialActionId, inputs);
            this.getFormTableManager().setWorkflowId(form, submission.getId(), newWorkflowId);
        }
        if (dropColumn) {
            this.getFormTableManager().dropWorkflowIdColumn(form.getId());
        }
    }

    private void _removeUnusedForms(Content content, String contentName, List<Form> forms) {
        try {
            for (Form form : this.getFormPropertiesManager().getForms(content)) {
                boolean found = false;
                for (Form form2 : forms) {
                    if (!form2.getId().equals(form.getId())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.getFormPropertiesManager().remove(form, content);
            }
        }
        catch (FormsException e) {
            this.getLogger().error("Cannot iterate on existing forms to remove unused forms on content " + contentName + " (" + content.getId() + ")", (Throwable)e);
        }
    }

    protected Set<RichText> _getRichTexts(ModelAwareDataHolder dataHolder) {
        HashSet<RichText> richTexts = new HashSet<RichText>();
        Map richTextValues = DataHolderHelper.findItemsByType((ModelAwareDataHolder)dataHolder, (String)"rich-text");
        for (Object richTextValue : richTextValues.values()) {
            if (richTextValue instanceof RichText[]) {
                Arrays.stream((RichText[])richTextValue).forEach(richTexts::add);
                continue;
            }
            if (richTextValue == null) continue;
            richTexts.add((RichText)richTextValue);
        }
        return richTexts;
    }
}

