/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.content.table;

import java.io.IOException;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.cms.repository.Content;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.core.datasource.dbtype.SQLDatabaseTypeExtensionPoint;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.forms.FormsException;
import org.ametys.plugins.forms.content.Field;
import org.ametys.plugins.forms.content.Form;
import org.ametys.plugins.forms.content.data.FieldValue;
import org.ametys.plugins.forms.content.data.UserEntry;
import org.ametys.plugins.forms.content.jcr.FormPropertiesManager;
import org.ametys.plugins.forms.content.table.DbTypeHelper;
import org.ametys.plugins.forms.data.Answer;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.workflow.store.JdbcWorkflowStore;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormTableManager
implements Component,
Serviceable {
    public static final String ROLE = FormTableManager.class.getName();
    public static final String FORMS_POOL_CONFIG_PARAM = "plugins.forms.datasource";
    public static final String TABLE_PREFIX = "Forms_";
    public static final String ID_FIELD = "id";
    public static final String CREATION_DATE_FIELD = "creationDate";
    public static final String LOGIN_FIELD = "login";
    public static final String POPULATION_ID_FIELD = "populationId";
    public static final String WORKFLOW_ID_FIELD = "workflowId";
    public static final String FILE_NAME_COLUMN_SUFFIX = "-filename";
    public static final int TABLE_CREATED_AND_UP_TO_DATE = 2;
    public static final int TABLE_CREATED_BUT_NEED_UPDATE = 3;
    public static final int TABLE_NOT_CREATED = 1;
    public static final int TABLE_UNKOWN_STATUS = 0;
    private static Logger __logger = LoggerFactory.getLogger(FormTableManager.class);
    private ServiceManager _manager;
    private FormPropertiesManager _formPropertiesManager;
    private AmetysObjectResolver _resolver;
    private I18nUtils _i18nUtils;
    private JdbcWorkflowStore _jdbcWorkflowStore;
    private SQLDatabaseTypeExtensionPoint _sqlDatabaseTypeExtensionPoint;

    public void service(ServiceManager smanager) throws ServiceException {
        this._manager = smanager;
    }

    private SQLDatabaseTypeExtensionPoint getSQLDatabaseTypeExtensionPoint() {
        if (this._sqlDatabaseTypeExtensionPoint == null) {
            try {
                this._sqlDatabaseTypeExtensionPoint = (SQLDatabaseTypeExtensionPoint)this._manager.lookup(SQLDatabaseTypeExtensionPoint.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
        return this._sqlDatabaseTypeExtensionPoint;
    }

    private I18nUtils getI18nUtils() {
        if (this._i18nUtils == null) {
            try {
                this._i18nUtils = (I18nUtils)this._manager.lookup(I18nUtils.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
        return this._i18nUtils;
    }

    private AmetysObjectResolver getAmetysObjectResolver() {
        if (this._resolver == null) {
            try {
                this._resolver = (AmetysObjectResolver)this._manager.lookup(AmetysObjectResolver.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
        return this._resolver;
    }

    private FormPropertiesManager getFormPropertiesManager() {
        if (this._formPropertiesManager == null) {
            try {
                this._formPropertiesManager = (FormPropertiesManager)((Object)this._manager.lookup(FormPropertiesManager.ROLE));
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
        return this._formPropertiesManager;
    }

    private JdbcWorkflowStore getJdbcWorkflowStore() {
        if (this._jdbcWorkflowStore == null) {
            try {
                this._jdbcWorkflowStore = (JdbcWorkflowStore)this._manager.lookup(JdbcWorkflowStore.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
        return this._jdbcWorkflowStore;
    }

    public boolean createTable(Form form) {
        if (form == null) {
            throw new IllegalArgumentException("Form object can not be null");
        }
        Map<String, FieldValue> columns = this.getColumns(form);
        return this._createOrUpdateTable(form.getId(), columns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropTable(String table) {
        PreparedStatement stmt = null;
        Connection connection = null;
        try {
            String dataSourceId = (String)Config.getInstance().getValue(FORMS_POOL_CONFIG_PARAM);
            connection = ConnectionHelper.getConnection((String)dataSourceId);
            String request = "DROP TABLE " + this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(ConnectionHelper.getDatabaseType((Connection)connection), table);
            stmt = connection.prepareStatement(request);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            boolean bl;
            try {
                __logger.error("Error while deleting table " + table, (Throwable)e);
                bl = false;
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(connection);
                throw throwable;
            }
            ConnectionHelper.cleanup(stmt);
            ConnectionHelper.cleanup((Connection)connection);
            return bl;
        }
        ConnectionHelper.cleanup((Statement)stmt);
        ConnectionHelper.cleanup((Connection)connection);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTableNames() {
        ArrayList<String> formsTableNames = new ArrayList<String>();
        Connection con = null;
        Statement stmt = null;
        DatabaseMetaData metadata = null;
        ResultSet tables = null;
        try {
            String dataSourceId = (String)Config.getInstance().getValue(FORMS_POOL_CONFIG_PARAM);
            con = ConnectionHelper.getConnection((String)dataSourceId);
            metadata = con.getMetaData();
            tables = metadata.getTables(con.getCatalog(), con.getSchema(), "%", null);
            while (tables.next()) {
                String tableName = tables.getString(3);
                if (!StringUtils.startsWithIgnoreCase((String)tableName, (String)TABLE_PREFIX)) continue;
                formsTableNames.add(tableName);
            }
        }
        catch (SQLException e) {
            try {
                __logger.error("Error while retrieving the forms table names", (Throwable)e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(con);
                throw throwable;
            }
            ConnectionHelper.cleanup(stmt);
            ConnectionHelper.cleanup((Connection)con);
        }
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup((Connection)con);
        return formsTableNames;
    }

    /*
     * WARNING - void declaration
     */
    public List<Answer> getUserAnwsers(List<Form> forms, UserIdentity user) throws FormsException {
        ArrayList<Answer> anwsers = new ArrayList<Answer>();
        List<String> tableNames = this.getTableNames();
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String dataSourceId = (String)Config.getInstance().getValue(FORMS_POOL_CONFIG_PARAM);
            connection = ConnectionHelper.getConnection((String)dataSourceId);
            String dbType = ConnectionHelper.getDatabaseType((Connection)connection);
            ArrayList<String> queries = new ArrayList<String>();
            for (Form form : forms) {
                String tableName = TABLE_PREFIX + form.getId();
                if (tableNames.stream().anyMatch(tableName::equalsIgnoreCase)) {
                    StringBuilder sql = new StringBuilder();
                    if ("derby".equals(dbType)) {
                        sql.append("(SELECT CAST('");
                        sql.append(form.getId());
                        sql.append("' AS VARCHAR(128)) as formId, id, ");
                    } else {
                        sql.append("(SELECT '");
                        sql.append(form.getId());
                        sql.append("' as formId, id, ");
                    }
                    sql.append(LOGIN_FIELD);
                    sql.append(", ");
                    sql.append(POPULATION_ID_FIELD);
                    sql.append(", ");
                    sql.append(CREATION_DATE_FIELD);
                    sql.append(", ");
                    if (StringUtils.isNotBlank((String)form.getWorkflowName())) {
                        sql.append(this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, WORKFLOW_ID_FIELD));
                    } else {
                        sql.append("-1 AS ");
                        sql.append(this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, WORKFLOW_ID_FIELD));
                    }
                    sql.append(" FROM ");
                    sql.append(this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, tableName));
                    sql.append(" WHERE ");
                    sql.append(LOGIN_FIELD);
                    sql.append(" = ? AND ");
                    sql.append(POPULATION_ID_FIELD);
                    sql.append(" = ?)");
                    queries.add(sql.toString());
                    continue;
                }
                __logger.warn("Table name '" + tableName + "' for content id '" + form.getContentId() + "' doesn't exist on the SQL database.");
            }
            stmt = connection.prepareStatement(queries.stream().collect(Collectors.joining(" UNION ALL ")));
            int nextParam = 1;
            for (Form form : forms) {
                String tableName = TABLE_PREFIX + form.getId();
                if (!tableNames.stream().anyMatch(tableName::equalsIgnoreCase)) continue;
                stmt.setString(nextParam++, user.getLogin());
                stmt.setString(nextParam++, user.getPopulationId());
            }
            rs = stmt.executeQuery();
            Long l = 0L;
            while (rs.next()) {
                void var12_17;
                String id = rs.getString(ID_FIELD);
                String formId = rs.getString("formId");
                Form form = this.getFormPropertiesManager().getForm(formId);
                Timestamp creationDate = rs.getTimestamp(CREATION_DATE_FIELD);
                Integer workflowId = rs.getInt(WORKFLOW_ID_FIELD);
                void var19_25 = var12_17;
                Long l2 = var12_17.longValue() + 1L;
                Answer answer = new Answer(id, (Long)var19_25, formId, form.getLabel(), creationDate, form.getWorkflowName(), workflowId, user);
                anwsers.add(answer);
            }
        }
        catch (Exception e) {
            try {
                __logger.error("Error while getting current user answers.", (Throwable)e);
                throw new FormsException("Error while getting current user answers.", e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(rs);
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup((Connection)connection);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup((ResultSet)rs);
        ConnectionHelper.cleanup((Statement)stmt);
        ConnectionHelper.cleanup((Connection)connection);
        return anwsers;
    }

    public List<UserEntry> getSubmissions(Form form, Map<String, FieldValue> columns, int offset, int length, List<Integer> entryIds) throws FormsException {
        ArrayList<UserEntry> entries = new ArrayList<UserEntry>();
        String tableName = TABLE_PREFIX + form.getId();
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String dataSourceId = (String)Config.getInstance().getValue(FORMS_POOL_CONFIG_PARAM);
            connection = ConnectionHelper.getConnection((String)dataSourceId);
            String dbType = ConnectionHelper.getDatabaseType((Connection)connection);
            String request = this._getSubmissionsQuery(offset, length, tableName, dbType, form, columns);
            stmt = connection.prepareStatement(request);
            rs = stmt.executeQuery();
            while (rs.next()) {
                int id = rs.getInt(ID_FIELD);
                if (entryIds != null && !entryIds.contains(id)) continue;
                UserEntry entry = this._getUserEntryFromResultSet(rs, form, columns, dbType);
                entries.add(entry);
            }
        }
        catch (IOException | SQLException e) {
            try {
                __logger.error("Error while getting entries for table " + tableName, (Throwable)e);
                throw new FormsException("Error while getting entries for table " + tableName, e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(rs);
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup((Connection)connection);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup((ResultSet)rs);
        ConnectionHelper.cleanup((Statement)stmt);
        ConnectionHelper.cleanup((Connection)connection);
        return entries;
    }

    private String _getSubmissionsQuery(int offset, int length, String tableName, String dbType, Form form, Map<String, FieldValue> columns) {
        StringBuilder query = this._getFieldsForSelectQuery(dbType, form, columns);
        query.append(" FROM ");
        query.append(this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, tableName));
        return this.getSQLDatabaseTypeExtensionPoint().languageLimitQuery(dbType, query.toString(), Integer.toString(length), Integer.toString(offset));
    }

    public UserEntry getSubmission(Form form, Map<String, FieldValue> columns, Integer entryId) throws FormsException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection connection;
        block4: {
            UserEntry userEntry;
            String tableName = TABLE_PREFIX + form.getId();
            connection = null;
            stmt = null;
            rs = null;
            try {
                String dataSourceId = (String)Config.getInstance().getValue(FORMS_POOL_CONFIG_PARAM);
                connection = ConnectionHelper.getConnection((String)dataSourceId);
                String dbType = ConnectionHelper.getDatabaseType((Connection)connection);
                String request = this._getSubmissionQuery(tableName, dbType, form, columns);
                stmt = connection.prepareStatement(request);
                stmt.setInt(1, entryId);
                rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                userEntry = this._getUserEntryFromResultSet(rs, form, columns, dbType);
            }
            catch (IOException | SQLException e) {
                try {
                    __logger.error("Error while getting entry with id '{}' for table '{}'", new Object[]{entryId, tableName, e});
                    throw new FormsException("Error while getting entry with id '" + entryId + "' for table " + tableName, e);
                }
                catch (Throwable throwable) {
                    ConnectionHelper.cleanup(rs);
                    ConnectionHelper.cleanup(stmt);
                    ConnectionHelper.cleanup((Connection)connection);
                    throw throwable;
                }
            }
            ConnectionHelper.cleanup((ResultSet)rs);
            ConnectionHelper.cleanup((Statement)stmt);
            ConnectionHelper.cleanup((Connection)connection);
            return userEntry;
        }
        ConnectionHelper.cleanup((ResultSet)rs);
        ConnectionHelper.cleanup((Statement)stmt);
        ConnectionHelper.cleanup((Connection)connection);
        return null;
    }

    private String _getSubmissionQuery(String tableName, String dbType, Form form, Map<String, FieldValue> columns) {
        StringBuilder query = this._getFieldsForSelectQuery(dbType, form, columns);
        query.append(" FROM ");
        query.append(this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, tableName));
        query.append(" WHERE id = ?");
        return this.getSQLDatabaseTypeExtensionPoint().languageLimitQuery(dbType, query.toString(), "1", "0");
    }

    private StringBuilder _getFieldsForSelectQuery(String dbType, Form form, Map<String, FieldValue> columns) {
        StringBuilder query = new StringBuilder("SELECT ");
        query.append(ID_FIELD);
        query.append(", ");
        query.append(CREATION_DATE_FIELD);
        query.append(", ");
        query.append(LOGIN_FIELD);
        query.append(", ");
        query.append(POPULATION_ID_FIELD);
        if (StringUtils.isNotBlank((String)form.getWorkflowName())) {
            query.append(", ");
            query.append(this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, WORKFLOW_ID_FIELD));
        }
        for (String name : columns.keySet()) {
            FieldValue fieldValue = columns.get(name);
            if (fieldValue.getType() == 2004) {
                String fileNameColumn = DbTypeHelper.normalizeName(dbType, name + FILE_NAME_COLUMN_SUFFIX);
                query.append(", ");
                query.append(this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, fileNameColumn));
                continue;
            }
            query.append(", ");
            query.append(this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, name));
        }
        return query;
    }

    protected UserEntry _getUserEntryFromResultSet(ResultSet rs, Form form, Map<String, FieldValue> columns, String dbType) throws SQLException, IOException {
        int id = rs.getInt(ID_FIELD);
        Timestamp creationDate = rs.getTimestamp(CREATION_DATE_FIELD);
        UserIdentity userIdentity = null;
        String login = rs.getString(LOGIN_FIELD);
        String populationId = rs.getString(POPULATION_ID_FIELD);
        if (StringUtils.isNotBlank((String)login) && StringUtils.isNotBlank((String)populationId)) {
            userIdentity = new UserIdentity(login, populationId);
        }
        ArrayList<FieldValue> entryValues = new ArrayList<FieldValue>();
        for (Map.Entry<String, FieldValue> column : columns.entrySet()) {
            String columnLabel = column.getKey();
            FieldValue columnValue = column.getValue();
            FieldValue value = null;
            switch (columnValue.getType()) {
                case -1: 
                case 12: {
                    String sValue = rs.getString(columnLabel);
                    value = new FieldValue(columnValue);
                    value.setValue(sValue);
                    entryValues.add(value);
                    break;
                }
                case 16: {
                    Boolean bValue = rs.getBoolean(columnLabel);
                    value = new FieldValue(columnValue);
                    value.setValue(bValue);
                    entryValues.add(value);
                    break;
                }
                case 2004: {
                    String fileNameColumn = columnLabel + FILE_NAME_COLUMN_SUFFIX;
                    String normalizedName = DbTypeHelper.normalizeName(dbType, fileNameColumn);
                    String fileName = rs.getString(normalizedName);
                    value = new FieldValue(columnValue);
                    value.setValue(fileName);
                    entryValues.add(value);
                    break;
                }
                case 4: {
                    Integer iValue = rs.getInt(columnLabel);
                    value = new FieldValue(columnValue);
                    value.setValue(iValue);
                    entryValues.add(value);
                    break;
                }
            }
        }
        Integer workflowId = null;
        if (this.hasWorkflowIdColumn(form.getId())) {
            workflowId = rs.getInt(WORKFLOW_ID_FIELD);
        }
        return new UserEntry(id, creationDate, entryValues, workflowId, userIdentity);
    }

    public int getTotalSubmissions(String formId) throws FormsException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection connection;
        block4: {
            int n;
            String tableName = TABLE_PREFIX + formId;
            connection = null;
            stmt = null;
            rs = null;
            try {
                int count;
                String dataSourceId = (String)Config.getInstance().getValue(FORMS_POOL_CONFIG_PARAM);
                connection = ConnectionHelper.getConnection((String)dataSourceId);
                String dbType = ConnectionHelper.getDatabaseType((Connection)connection);
                String request = "SELECT COUNT(*) FROM " + this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, tableName);
                stmt = connection.prepareStatement(request);
                rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                n = count = rs.getInt(1);
            }
            catch (SQLException e) {
                try {
                    __logger.error("Error while getting entries for table " + tableName, (Throwable)e);
                    throw new FormsException("Error while getting entries for table " + tableName, e);
                }
                catch (Throwable throwable) {
                    ConnectionHelper.cleanup(rs);
                    ConnectionHelper.cleanup(stmt);
                    ConnectionHelper.cleanup((Connection)connection);
                    throw throwable;
                }
            }
            ConnectionHelper.cleanup((ResultSet)rs);
            ConnectionHelper.cleanup((Statement)stmt);
            ConnectionHelper.cleanup((Connection)connection);
            return n;
        }
        ConnectionHelper.cleanup((ResultSet)rs);
        ConnectionHelper.cleanup((Statement)stmt);
        ConnectionHelper.cleanup((Connection)connection);
        return -1;
    }

    @Callable
    public List<Map<String, Object>> getContentForms(List<String> contentIds, String currentLanguage) throws FormsException, URISyntaxException {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (String contentId : contentIds) {
            Content content = (Content)this.getAmetysObjectResolver().resolveById(contentId);
            HashMap<String, Object> contentforms = new HashMap<String, Object>();
            contentforms.put(ID_FIELD, content.getId());
            contentforms.put("title", content.getTitle(new Locale(currentLanguage)));
            ArrayList forms2json = new ArrayList();
            List<Form> forms = this.getFormPropertiesManager().getForms(content);
            for (Form form : forms) {
                HashMap<String, String> form2json = new HashMap<String, String>();
                form2json.put(ID_FIELD, form.getId());
                form2json.put("label", URIUtils.decode((String)form.getLabel()));
                form2json.put("workflowName", StringUtils.defaultString((String)form.getWorkflowName(), (String)""));
                forms2json.add(form2json);
            }
            contentforms.put("forms", forms2json);
            result.add(contentforms);
        }
        return result;
    }

    @Callable
    public List<Map<String, Object>> getColumns(String siteName, String formId) throws FormsException {
        ArrayList<Map<String, Object>> columns2json = new ArrayList<Map<String, Object>>();
        Form form = this.getFormPropertiesManager().getForm(siteName, formId);
        Map<String, FieldValue> columns = this.getColumns(form);
        for (FieldValue column : columns.values()) {
            HashMap<String, Object> column2json = new HashMap<String, Object>();
            column2json.put(ID_FIELD, column.getColumnName());
            Field field = column.getField();
            column2json.put("label", field.getLabel());
            column2json.put("type", field.getType().toString());
            column2json.put("name", field.getName());
            column2json.put("properties", field.getProperties());
            columns2json.add(column2json);
        }
        return columns2json;
    }

    @Callable
    public void removeTables(List<String> tableNames) throws FormsException {
        for (String tableName : tableNames) {
            if (this.dropTable(tableName)) continue;
            throw new FormsException("An error occurred occured while removing the tables from the database.");
        }
    }

    public Map<String, FieldValue> getColumns(Form form) {
        LinkedHashMap<String, FieldValue> columns = new LinkedHashMap<String, FieldValue>();
        block8: for (Field field : form.getFields()) {
            String id = field.getId();
            String name = field.getName();
            FieldValue fdValue = null;
            switch (field.getType()) {
                case TEXT: 
                case HIDDEN: 
                case PASSWORD: 
                case COST: 
                case SELECT: {
                    fdValue = new FieldValue(id, 12, null, field);
                    columns.put(id, fdValue);
                    break;
                }
                case TEXTAREA: {
                    fdValue = new FieldValue(id, -1, null, field);
                    columns.put(id, fdValue);
                    break;
                }
                case RADIO: {
                    int index;
                    String value;
                    if (!columns.containsKey(name)) {
                        value = field.getProperties().get("value");
                        String label = field.getLabel();
                        index = 1;
                        field.getProperties().put("size", String.valueOf(index));
                        field.getProperties().put("option-" + index + "-value", value);
                        field.getProperties().put("option-" + index + "-label", label);
                        field.getProperties().remove("value");
                        fdValue = new FieldValue(name, 12, null, field);
                        columns.put(name, fdValue);
                        break;
                    }
                    value = field.getProperties().get("value");
                    if (!StringUtils.isNotEmpty((String)value)) continue block8;
                    Field radioField = ((FieldValue)columns.get(name)).getField();
                    index = Integer.parseInt(radioField.getProperties().get("size"));
                    String label = field.getLabel();
                    radioField.getProperties().put("size", String.valueOf(++index));
                    radioField.getProperties().put("option-" + index + "-value", value);
                    radioField.getProperties().put("option-" + index + "-label", label);
                    Field dummyField = new Field(radioField.getId(), radioField.getType(), radioField.getName(), radioField.getLabel() + (String)(StringUtils.isNotEmpty((String)label) ? "/" + field.getLabel() : ""), radioField.getProperties());
                    ((FieldValue)columns.get(name)).setField(dummyField);
                    break;
                }
                case CHECKBOX: {
                    fdValue = new FieldValue(id, 16, null, field);
                    columns.put(id, fdValue);
                    break;
                }
                case FILE: {
                    fdValue = new FieldValue(id, 2004, null, field);
                    columns.put(id, fdValue);
                    break;
                }
                case CAPTCHA: {
                    break;
                }
            }
        }
        return columns;
    }

    protected String _getColumnType(int sqlType, String dbType) {
        switch (sqlType) {
            case -1: {
                return DbTypeHelper.getTextType(dbType);
            }
            case 16: {
                return DbTypeHelper.getBooleanType(dbType);
            }
            case 2004: {
                return DbTypeHelper.getBinaryType(dbType);
            }
        }
        return DbTypeHelper.getVarcharType(dbType);
    }

    protected String _getColumnTypeName(int sqlType, String dbType) {
        return StringUtils.substringBefore((String)this._getColumnType(sqlType, dbType), (String)"(");
    }

    protected boolean _isSameType(DbColumn column, FieldValue newColumn, String dbType) {
        int newColumnType = newColumn.getType();
        int currentColumnType = column.getSqlType();
        String newColumnTypeName = this._getColumnTypeName(newColumnType, dbType);
        String currentColumnTypeName = column.getTypeName();
        return currentColumnType == newColumnType || currentColumnTypeName.equals(newColumnTypeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _createTable(String formId, Map<String, FieldValue> columns) {
        boolean bl;
        String tableName = TABLE_PREFIX + formId;
        Connection connection = null;
        PreparedStatement stmt = null;
        try {
            String dataSourceId = (String)Config.getInstance().getValue(FORMS_POOL_CONFIG_PARAM);
            connection = ConnectionHelper.getConnection((String)dataSourceId);
            String dbType = ConnectionHelper.getDatabaseType((Connection)connection);
            StringBuilder sql = new StringBuilder();
            sql.append("CREATE TABLE ");
            sql.append(this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, tableName));
            sql.append(" ( ").append(ID_FIELD).append(" ").append(DbTypeHelper.getIdentityType(dbType)).append(" ").append(DbTypeHelper.getIdentityMarker(dbType)).append(", ");
            sql.append(CREATION_DATE_FIELD).append(" ").append(DbTypeHelper.getDateTimeType(dbType)).append(" NOT NULL,");
            sql.append(LOGIN_FIELD).append(" ").append(DbTypeHelper.getVarcharType(dbType)).append(" DEFAULT NULL,");
            sql.append(POPULATION_ID_FIELD).append(" ").append(DbTypeHelper.getVarcharType(dbType)).append(" DEFAULT NULL,");
            for (Map.Entry<String, FieldValue> column : columns.entrySet()) {
                int sqlType = column.getValue().getType();
                sql.append(this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, column.getKey())).append(" ");
                sql.append(this._getColumnType(sqlType, dbType));
                sql.append(" DEFAULT NULL,");
                if (sqlType != 2004) continue;
                String fileNameColumn = column.getKey() + FILE_NAME_COLUMN_SUFFIX;
                String normalizedName = DbTypeHelper.normalizeName(dbType, fileNameColumn);
                sql.append(this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, normalizedName)).append(" ");
                sql.append(DbTypeHelper.getVarcharType(dbType));
                sql.append(" DEFAULT NULL,");
            }
            sql.append("PRIMARY KEY (").append(ID_FIELD).append("))");
            if (__logger.isDebugEnabled()) {
                __logger.debug("Creating table : " + sql.toString());
            }
            stmt = connection.prepareStatement(sql.toString());
            stmt.executeUpdate();
            ConnectionHelper.cleanup((Statement)stmt);
            if ("oracle".equals(dbType)) {
                String sqlQuery = "create sequence seq_" + formId;
                stmt = connection.prepareStatement(sqlQuery);
                stmt.executeUpdate();
            }
            bl = true;
        }
        catch (SQLException e) {
            boolean bl2;
            try {
                __logger.error("Unable to create table " + tableName, (Throwable)e);
                bl2 = false;
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(connection);
                throw throwable;
            }
            ConnectionHelper.cleanup(stmt);
            ConnectionHelper.cleanup((Connection)connection);
            return bl2;
        }
        ConnectionHelper.cleanup((Statement)stmt);
        ConnectionHelper.cleanup((Connection)connection);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _alterTable(String formId, Map<String, FieldValue> newColumns) {
        String tableName = TABLE_PREFIX + formId;
        Connection connection = null;
        String dataSourceId = (String)Config.getInstance().getValue(FORMS_POOL_CONFIG_PARAM);
        try {
            connection = ConnectionHelper.getConnection((String)dataSourceId);
            connection.setAutoCommit(false);
            Map<String, DbColumn> existingColumns = this._getExistingColumns(connection, tableName);
            DbColumnModifications modifications = this._getColumnsToModify(connection, existingColumns, newColumns);
            this._moveColumns(connection, modifications.getColumnsToRemove(), existingColumns, tableName);
            this._addColumns(connection, modifications.getColumnsToAdd(), tableName);
            connection.commit();
        }
        catch (SQLException e) {
            __logger.error("Unable to alter table " + tableName, (Throwable)e);
            try {
                connection.rollback();
            }
            catch (SQLException sqlex) {
                __logger.error("Error rollbacking the 'alter table' statements for table " + tableName, (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            ConnectionHelper.cleanup((Connection)connection);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int _checkTableStatus(String formId, Map<String, FieldValue> newColumns) {
        int n;
        ResultSet rs;
        ResultSet tables;
        Connection connection;
        block14: {
            int n2;
            block13: {
                int n3;
                block12: {
                    int n4;
                    block11: {
                        Object tableName = TABLE_PREFIX + formId;
                        connection = null;
                        tables = null;
                        rs = null;
                        Map<Object, Object> currentColumns = new HashMap();
                        try {
                            String dataSourceId = (String)Config.getInstance().getValue(FORMS_POOL_CONFIG_PARAM);
                            connection = ConnectionHelper.getConnection((String)dataSourceId);
                            String dbType = ConnectionHelper.getDatabaseType((Connection)connection);
                            tableName = DbTypeHelper.filterName(dbType, (String)tableName);
                            DatabaseMetaData metadata = connection.getMetaData();
                            tables = metadata.getTables(connection.getCatalog(), null, (String)tableName, null);
                            if (!tables.next()) {
                                n4 = 1;
                                ConnectionHelper.cleanup((ResultSet)tables);
                                break block11;
                            }
                            currentColumns = this._getExistingColumns(connection, (String)tableName);
                            for (String newColumn : newColumns.keySet()) {
                                FieldValue newColumnFv;
                                String filteredColumn = DbTypeHelper.filterName(dbType, newColumn);
                                if (!currentColumns.containsKey(filteredColumn)) {
                                    n3 = 3;
                                    ConnectionHelper.cleanup((ResultSet)tables);
                                    break block12;
                                }
                                DbColumn currentColumn = (DbColumn)currentColumns.get(filteredColumn);
                                if (this._isSameType(currentColumn, newColumnFv = newColumns.get(newColumn), dbType)) continue;
                                n2 = 3;
                                ConnectionHelper.cleanup((ResultSet)tables);
                                break block13;
                            }
                            n = 2;
                            ConnectionHelper.cleanup((ResultSet)tables);
                            break block14;
                        }
                        catch (SQLException e) {
                            __logger.error("Unable to get columns from table " + (String)tableName, (Throwable)e);
                            int n5 = 0;
                            return n5;
                        }
                    }
                    ConnectionHelper.cleanup(rs);
                    ConnectionHelper.cleanup((Connection)connection);
                    return n4;
                }
                ConnectionHelper.cleanup(rs);
                ConnectionHelper.cleanup((Connection)connection);
                return n3;
            }
            ConnectionHelper.cleanup(rs);
            ConnectionHelper.cleanup((Connection)connection);
            return n2;
        }
        ConnectionHelper.cleanup(rs);
        ConnectionHelper.cleanup((Connection)connection);
        return n;
        finally {
            ConnectionHelper.cleanup(tables);
            ConnectionHelper.cleanup(rs);
            ConnectionHelper.cleanup((Connection)connection);
        }
    }

    private boolean _createOrUpdateTable(String formId, Map<String, FieldValue> columns) {
        boolean toReturn = true;
        switch (this._checkTableStatus(formId, columns)) {
            case 1: {
                if (this._createTable(formId, columns)) break;
                toReturn = false;
                break;
            }
            case 3: {
                if (this._alterTable(formId, columns)) break;
                toReturn = false;
                break;
            }
        }
        return toReturn;
    }

    private DbColumnModifications _getColumnsToModify(Connection con, Map<String, DbColumn> existingColumns, Map<String, FieldValue> newColumns) {
        DbColumnModifications modifications = new DbColumnModifications();
        String dbType = ConnectionHelper.getDatabaseType((Connection)con);
        LinkedHashMap<String, FieldValue> columnsToAdd = new LinkedHashMap<String, FieldValue>();
        HashMap<String, DbColumn> columnsToRemove = new HashMap<String, DbColumn>();
        for (Map.Entry<String, FieldValue> newColumn : newColumns.entrySet()) {
            String filteredName = DbTypeHelper.filterName(dbType, newColumn.getKey());
            columnsToAdd.put(filteredName, newColumn.getValue());
        }
        if (existingColumns != null) {
            for (String existingColName : existingColumns.keySet()) {
                DbColumn existingColumn = existingColumns.get(existingColName);
                FieldValue newColumn = (FieldValue)columnsToAdd.get(existingColName);
                if (newColumn != null && !this._isSameType(existingColumn, newColumn, dbType)) {
                    columnsToRemove.put(existingColName, existingColumn);
                    continue;
                }
                columnsToAdd.remove(existingColName);
            }
        }
        modifications.setColumnsToAdd(columnsToAdd);
        modifications.setColumnsToRemove(columnsToRemove);
        return modifications;
    }

    private Map<String, DbColumn> _getExistingColumns(Connection con, String table) throws SQLException {
        ResultSet columns = null;
        LinkedHashMap<String, DbColumn> toReturn = new LinkedHashMap<String, DbColumn>();
        try {
            String dbType = ConnectionHelper.getDatabaseType((Connection)con);
            String filteredTableName = DbTypeHelper.filterName(dbType, table);
            DatabaseMetaData metadata = con.getMetaData();
            columns = metadata.getColumns(con.getCatalog(), null, filteredTableName, null);
            while (columns.next()) {
                String columnName = columns.getString("COLUMN_NAME");
                Integer sqlType = columns.getInt("DATA_TYPE");
                String typeName = columns.getString("TYPE_NAME");
                Integer colSize = columns.getInt("COLUMN_SIZE");
                DbColumn col = new DbColumn(columnName, sqlType, typeName, colSize);
                toReturn.put(columnName, col);
            }
        }
        catch (SQLException e) {
            try {
                __logger.error("Unable to get columns from " + table, (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(columns);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup((ResultSet)columns);
        return toReturn;
    }

    private void _moveColumns(Connection con, Map<String, DbColumn> columnsToRemove, Map<String, DbColumn> existingColumns, String tableName) throws SQLException {
        String dbType = ConnectionHelper.getDatabaseType((Connection)con);
        PreparedStatement stmt = null;
        Set<String> existingColumnNames = existingColumns.keySet();
        try {
            for (String columnName : columnsToRemove.keySet()) {
                DbColumn columnToRemove = columnsToRemove.get(columnName);
                String newName = this._getNewName(con, columnName, existingColumnNames);
                String sql = DbTypeHelper.getRenameColumnStatement(tableName, columnToRemove, newName, dbType, this.getSQLDatabaseTypeExtensionPoint());
                if (__logger.isDebugEnabled()) {
                    __logger.debug("Moving column: " + sql);
                }
                stmt = con.prepareStatement(sql);
                stmt.executeUpdate();
                if (columnToRemove.getSqlType() != 2004) continue;
                ConnectionHelper.cleanup((Statement)stmt);
                String fileNameColumn = columnName + FILE_NAME_COLUMN_SUFFIX;
                String newFileNameColumn = this._getNewName(con, fileNameColumn, existingColumnNames);
                String varcharType = DbTypeHelper.getVarcharType(dbType);
                sql = DbTypeHelper.getRenameColumnStatement(tableName, fileNameColumn, newFileNameColumn, varcharType, dbType, this.getSQLDatabaseTypeExtensionPoint());
                if (__logger.isDebugEnabled()) {
                    __logger.debug("Altering table : " + sql.toString());
                }
                stmt = con.prepareStatement(sql.toString());
                stmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            ConnectionHelper.cleanup(stmt);
            throw e;
        }
    }

    private void _addColumns(Connection con, Map<String, FieldValue> columnsToAdd, String tableName) throws SQLException {
        String dbType = ConnectionHelper.getDatabaseType((Connection)con);
        PreparedStatement stmt = null;
        try {
            for (Map.Entry<String, FieldValue> column : columnsToAdd.entrySet()) {
                StringBuilder sql = new StringBuilder();
                sql.append("ALTER TABLE ").append(this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, tableName));
                int sqlType = column.getValue().getType();
                sql.append(" ADD ").append(this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, column.getKey())).append(" ");
                sql.append(this._getColumnType(sqlType, dbType));
                sql.append(" DEFAULT NULL");
                if (__logger.isDebugEnabled()) {
                    __logger.debug("Altering table : " + sql.toString());
                }
                stmt = con.prepareStatement(sql.toString());
                stmt.executeUpdate();
                if (sqlType != 2004) continue;
                ConnectionHelper.cleanup((Statement)stmt);
                sql.setLength(0);
                sql.append("ALTER TABLE ").append(this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, tableName));
                String fileNameColumn = column.getKey() + FILE_NAME_COLUMN_SUFFIX;
                String normalizedName = DbTypeHelper.normalizeName(dbType, fileNameColumn);
                sql.append(" ADD ").append(this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, normalizedName)).append(" ");
                sql.append(DbTypeHelper.getVarcharType(dbType));
                sql.append(" DEFAULT NULL");
                if (__logger.isDebugEnabled()) {
                    __logger.debug("Adding column: " + sql.toString());
                }
                stmt = con.prepareStatement(sql.toString());
                stmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            ConnectionHelper.cleanup(stmt);
            throw e;
        }
    }

    private String _getNewName(Connection con, String currentName, Set<String> existingColumnNames) {
        String dbType = ConnectionHelper.getDatabaseType((Connection)con);
        int i = 1;
        String newName = DbTypeHelper.normalizeName(dbType, currentName + "_old" + i);
        String filteredNewName = DbTypeHelper.filterName(dbType, newName);
        while (existingColumnNames.contains(filteredNewName)) {
            newName = DbTypeHelper.normalizeName(dbType, currentName + "_old" + ++i);
            filteredNewName = DbTypeHelper.filterName(dbType, newName);
        }
        return newName;
    }

    public static int getFieldSqlType(Field.FieldType fieldType) {
        int sqlType = 12;
        switch (fieldType) {
            case TEXT: 
            case HIDDEN: 
            case PASSWORD: 
            case SELECT: 
            case RADIO: {
                sqlType = 12;
                break;
            }
            case TEXTAREA: {
                sqlType = -1;
                break;
            }
            case CHECKBOX: {
                sqlType = 16;
                break;
            }
            case FILE: {
                sqlType = 2004;
                break;
            }
            case CAPTCHA: {
                sqlType = 1111;
                break;
            }
        }
        return sqlType;
    }

    public void addWorkflowIdColumn(String formId) throws FormsException {
        String tableName = TABLE_PREFIX + formId;
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            String dataSourceId = (String)Config.getInstance().getValue(FORMS_POOL_CONFIG_PARAM);
            con = ConnectionHelper.getConnection((String)dataSourceId);
            String dbType = ConnectionHelper.getDatabaseType((Connection)con);
            StringBuilder sql = new StringBuilder();
            sql.append("ALTER TABLE ").append(this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, tableName));
            sql.append(" ADD ").append(this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, WORKFLOW_ID_FIELD)).append(" ");
            sql.append(DbTypeHelper.getIntegerType(dbType));
            if (__logger.isDebugEnabled()) {
                __logger.debug("Adding column: " + sql.toString());
            }
            stmt = con.prepareStatement(sql.toString());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                __logger.error("Error while adding the workflow id column for the table " + tableName, (Throwable)e);
                throw new FormsException("Error while adding a column to the table " + tableName, e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(con);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup((Statement)stmt);
        ConnectionHelper.cleanup((Connection)con);
    }

    public void dropWorkflowIdColumn(String formId) throws FormsException {
        String tableName = TABLE_PREFIX + formId;
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            String dataSourceId = (String)Config.getInstance().getValue(FORMS_POOL_CONFIG_PARAM);
            con = ConnectionHelper.getConnection((String)dataSourceId);
            String dbType = ConnectionHelper.getDatabaseType((Connection)con);
            StringBuilder sql = new StringBuilder();
            sql.append("ALTER TABLE ").append(this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, tableName));
            sql.append(" DROP COLUMN ").append(this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, WORKFLOW_ID_FIELD));
            if (__logger.isDebugEnabled()) {
                __logger.debug("Deleting column: " + sql.toString());
            }
            stmt = con.prepareStatement(sql.toString());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                __logger.error("Error while deleting the workflow id column for the table " + tableName, (Throwable)e);
                throw new FormsException("Error while deleting a column from the table " + tableName, e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(con);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup((Statement)stmt);
        ConnectionHelper.cleanup((Connection)con);
    }

    public void setWorkflowId(Form form, long entryId, long newWorkflowId) throws FormsException {
        String tableName = TABLE_PREFIX + form.getId();
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            String dataSourceId = (String)Config.getInstance().getValue(FORMS_POOL_CONFIG_PARAM);
            con = ConnectionHelper.getConnection((String)dataSourceId);
            String dbType = ConnectionHelper.getDatabaseType((Connection)con);
            String query = "UPDATE " + this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, tableName);
            query = query + " SET " + this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, WORKFLOW_ID_FIELD) + " = ?";
            query = query + " WHERE id = ?";
            stmt = con.prepareStatement(query);
            stmt.setLong(1, newWorkflowId);
            stmt.setLong(2, entryId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                __logger.error("Error while resetting the workflow id for the table " + tableName, (Throwable)e);
                throw new FormsException("Error while deleting entry for table " + tableName, e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(con);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup((Statement)stmt);
        ConnectionHelper.cleanup((Connection)con);
    }

    public List<Integer> getWorkflowIds(String formId, Integer entryId) throws FormsException {
        ArrayList<Integer> workflowIds = new ArrayList<Integer>();
        String tableName = TABLE_PREFIX + formId;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            if (!this.hasWorkflowIdColumn(formId)) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            String dataSourceId = (String)Config.getInstance().getValue(FORMS_POOL_CONFIG_PARAM);
            con = ConnectionHelper.getConnection((String)dataSourceId);
            String dbType = ConnectionHelper.getDatabaseType((Connection)con);
            String query = "SELECT " + this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, WORKFLOW_ID_FIELD) + " FROM " + this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, tableName);
            if (entryId != null) {
                query = query + " WHERE id = ?";
            }
            stmt = con.prepareStatement(query);
            if (entryId != null) {
                stmt.setInt(1, entryId);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                workflowIds.add(rs.getInt(1));
            }
            ConnectionHelper.cleanup((ResultSet)rs);
        }
        catch (SQLException e) {
            __logger.error("Error while getting workflow ids from the table " + tableName, (Throwable)e);
            throw new FormsException("Error while getting workflow ids from the table " + tableName, e);
        }
        finally {
            ConnectionHelper.cleanup(rs);
            ConnectionHelper.cleanup(stmt);
            ConnectionHelper.cleanup(con);
        }
        ConnectionHelper.cleanup((Statement)stmt);
        ConnectionHelper.cleanup((Connection)con);
        return workflowIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasWorkflowIdColumn(String formId) throws SQLException {
        boolean bl;
        boolean hasWorkflowId = true;
        Connection con = null;
        String tableName = TABLE_PREFIX + formId;
        try {
            String dataSourceId = (String)Config.getInstance().getValue(FORMS_POOL_CONFIG_PARAM);
            con = ConnectionHelper.getConnection((String)dataSourceId);
            Map<String, DbColumn> currentColumns = this._getExistingColumns(con, tableName);
            if (!currentColumns.containsKey(WORKFLOW_ID_FIELD)) {
                hasWorkflowId = false;
            }
            bl = hasWorkflowId;
        }
        catch (Throwable throwable) {
            ConnectionHelper.cleanup(con);
            throw throwable;
        }
        ConnectionHelper.cleanup((Connection)con);
        return bl;
    }

    @Callable
    public void deleteEntry(String siteName, String formId, List<Integer> entries) throws ProcessingException, FormsException {
        if (StringUtils.isEmpty((String)siteName) || StringUtils.isEmpty((String)formId)) {
            throw new ProcessingException("The site name and form ID must be provided.");
        }
        Form form = this.getFormPropertiesManager().getForm(siteName, formId);
        if (form == null) {
            throw new ProcessingException("The form of ID '" + formId + " can't be found in the site '" + siteName + "'.");
        }
        String tableName = TABLE_PREFIX + form.getId();
        Connection connection = null;
        PreparedStatement stmt = null;
        try {
            int i;
            String dataSourceId = (String)Config.getInstance().getValue(FORMS_POOL_CONFIG_PARAM);
            connection = ConnectionHelper.getConnection((String)dataSourceId);
            String dbType = ConnectionHelper.getDatabaseType((Connection)connection);
            StringBuilder sb = new StringBuilder();
            sb.append("DELETE FROM " + this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, tableName) + " WHERE ");
            int count = entries.size();
            for (i = 0; i < count; ++i) {
                if (i > 0) {
                    sb.append(" OR ");
                }
                sb.append(ID_FIELD).append("=?");
            }
            stmt = connection.prepareStatement(sb.toString());
            i = 1;
            ArrayList<Integer> workflowIds = new ArrayList<Integer>();
            for (Integer entryId : entries) {
                workflowIds.addAll(this.getWorkflowIds(formId, entryId));
                stmt.setInt(i, entryId);
                ++i;
            }
            for (Integer workflowId : workflowIds) {
                this.getJdbcWorkflowStore().clearHistory((long)workflowId.intValue());
                this.getJdbcWorkflowStore().deleteInstance((long)workflowId.intValue());
            }
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                __logger.error("Error while deleting entry for table " + tableName, (Throwable)e);
                throw new FormsException("Error while deleting entry for table " + tableName, e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(connection);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup((Statement)stmt);
        ConnectionHelper.cleanup((Connection)connection);
    }

    @Callable
    public void clearEntries(String siteName, List<String> formIds) throws ProcessingException, FormsException {
        if (StringUtils.isEmpty((String)siteName) || formIds.isEmpty()) {
            throw new ProcessingException("The site name and form ID must be provided.");
        }
        for (String formId : formIds) {
            Form form = this.getFormPropertiesManager().getForm(siteName, formId);
            if (form == null) {
                throw new ProcessingException("The form of ID '" + formId + " can't be found in the site '" + siteName + "'.");
            }
            String tableName = TABLE_PREFIX + form.getId();
            Connection connection = null;
            PreparedStatement stmt = null;
            try {
                String dataSourceId = (String)Config.getInstance().getValue(FORMS_POOL_CONFIG_PARAM);
                connection = ConnectionHelper.getConnection((String)dataSourceId);
                String dbType = ConnectionHelper.getDatabaseType((Connection)connection);
                String request = "DELETE FROM " + this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, tableName);
                stmt = connection.prepareStatement(request);
                List<Integer> workflowIds = this.getWorkflowIds(formId, null);
                for (Integer workflowId : workflowIds) {
                    this.getJdbcWorkflowStore().clearHistory((long)workflowId.intValue());
                    this.getJdbcWorkflowStore().deleteInstance((long)workflowId.intValue());
                }
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                try {
                    __logger.error("Error while deleting entry for table " + tableName, (Throwable)e);
                    throw new FormsException("Error while deleting entry for table " + tableName, e);
                }
                catch (Throwable throwable) {
                    ConnectionHelper.cleanup(stmt);
                    ConnectionHelper.cleanup(connection);
                    throw throwable;
                }
            }
            ConnectionHelper.cleanup((Statement)stmt);
            ConnectionHelper.cleanup((Connection)connection);
        }
    }

    @Callable
    public Map<String, String> getSelectStatement(String siteName, String formId) throws ProcessingException {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            Form form = this.getFormPropertiesManager().getForm(siteName, formId);
            if (form == null) {
                throw new ProcessingException("The form of ID '" + formId + " can't be found in the site '" + siteName + "'.");
            }
            String tableName = TABLE_PREFIX + form.getId();
            result.put("formId", form.getId());
            result.put("tableName", tableName);
            ArrayList<Object> selectClause = new ArrayList<Object>();
            selectClause.add("id as Id");
            selectClause.add("creationDate as '" + this.getI18nUtils().translate((I18nizable)new I18nizableText("plugin.forms", "PLUGINS_FORMS_CHOOSE_SHOW_FORM_SUBMISSION_DATE")) + "'");
            Map<String, FieldValue> columns = this.getColumns(form);
            for (FieldValue column : columns.values()) {
                selectClause.add(column.getColumnName() + " as '" + column.getField().getLabel() + "'");
            }
            StringBuilder request = new StringBuilder();
            request.append("SELECT ").append(StringUtils.join(selectClause, (String)", ")).append("\nFROM ").append(tableName).append(";");
            result.put("query", request.toString());
        }
        catch (FormsException e) {
            __logger.error("An error occurred while getting the results of a form.", (Throwable)e);
            throw new ProcessingException("An error occurred while getting the results of a form.", (Throwable)e);
        }
        return result;
    }

    class DbColumn {
        protected String _name;
        protected int _sqlType;
        protected String _typeName;
        protected int _columnSize;

        public DbColumn() {
            this("", 0, "", 0);
        }

        public DbColumn(String name, int sqlType, String typeName, int columnSize) {
            this._name = name;
            this._sqlType = sqlType;
            this._typeName = typeName;
            this._columnSize = columnSize;
        }

        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        public int getSqlType() {
            return this._sqlType;
        }

        public void setSqlType(int sqlType) {
            this._sqlType = sqlType;
        }

        public String getTypeName() {
            return this._typeName;
        }

        public void setTypeName(String typeName) {
            this._typeName = typeName;
        }

        public int getColumnSize() {
            return this._columnSize;
        }

        public void setColumnSize(int columnSize) {
            this._columnSize = columnSize;
        }

        public String getColumnTypeIdentifier() {
            StringBuilder buff = new StringBuilder();
            buff.append(this._typeName);
            if (this._typeName.equals("VARCHAR") || this._typeName.equals("INT") || this._typeName.equals("NUMBER")) {
                buff.append('(').append(this._columnSize).append(')');
            }
            return buff.toString();
        }
    }

    class DbColumnModifications {
        protected Map<String, DbColumn> _columnsToRemove;
        protected Map<String, FieldValue> _columnsToAdd;

        public DbColumnModifications() {
            this(new HashMap<String, DbColumn>(), new HashMap<String, FieldValue>());
        }

        public DbColumnModifications(Map<String, DbColumn> columnsToRemove, Map<String, FieldValue> columnsToAdd) {
            this._columnsToRemove = columnsToRemove;
            this._columnsToAdd = columnsToAdd;
        }

        public Map<String, DbColumn> getColumnsToRemove() {
            return this._columnsToRemove;
        }

        public void setColumnsToRemove(Map<String, DbColumn> columnsToRemove) {
            this._columnsToRemove = columnsToRemove;
        }

        public Map<String, FieldValue> getColumnsToAdd() {
            return this._columnsToAdd;
        }

        public void setColumnsToAdd(Map<String, FieldValue> columnsToAdd) {
            this._columnsToAdd = columnsToAdd;
        }
    }
}

