/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.helper;

import java.util.HashMap;
import org.ametys.cms.workflow.AmetysObjectCheckRightsCondition;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.workflow.repository.WorkflowAwareAmetysObject;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.plugins.workflow.support.WorkflowProvider;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang.StringUtils;

public class FormWorkflowHelper
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = FormWorkflowHelper.class.getName();
    protected WorkflowProvider _workflowProvider;
    protected WorkflowHelper _workflowHelper;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._workflowProvider = (WorkflowProvider)serviceManager.lookup(WorkflowProvider.ROLE);
        this._workflowHelper = (WorkflowHelper)serviceManager.lookup(WorkflowHelper.ROLE);
    }

    public void initializeWorkflow(FormEntry entry) throws Exception {
        Form form = entry.getForm();
        String workflowName = form.getWorkflowName();
        if (StringUtils.isNotBlank((String)workflowName)) {
            WorkflowProvider.AmetysObjectWorkflow workflow = this._workflowProvider.getAmetysObjectWorkflow((WorkflowAwareAmetysObject)entry);
            int initialActionId = this._workflowHelper.getInitialAction(workflowName);
            HashMap<String, FormEntry> inputs = new HashMap<String, FormEntry>();
            inputs.put(AmetysObjectCheckRightsCondition.AMETYS_OBJECT_KEY, entry);
            long workflowInstanceId = workflow.initialize(workflowName, initialActionId, inputs);
            entry.setWorkflowId(workflowInstanceId);
        }
    }
}

