/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.helper;

import java.util.function.Function;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.cocoon.sitemap.PatternException;
import org.apache.commons.lang3.StringUtils;

public class MailVariableParser
extends AbstractLogEnabled
implements Component {
    public static final String ROLE = MailVariableParser.class.getName();

    public String replaceText(String expression, Function<String, String> function) throws PatternException {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isOpen = false;
        int openPos = 0;
        for (int i = 0; i < expression.length(); ++i) {
            char c = expression.charAt(i);
            if (c == '\\') {
                sb.append(expression.charAt(++i));
                continue;
            }
            if (c == '{') {
                if (isOpen) {
                    throw new PatternException("Invalid '{' at position " + i + " in expression \"" + expression + "\"");
                }
                isOpen = true;
                openPos = i;
                continue;
            }
            if (c == '}') {
                if (!isOpen) {
                    throw new PatternException("Invalid '}' at position " + i + " in expression \"" + expression + "\"");
                }
                String variable = expression.substring(openPos + 1, i);
                String translation = function.apply(variable);
                if (StringUtils.isNotBlank((CharSequence)translation)) {
                    sb.append(translation);
                }
                isOpen = false;
                continue;
            }
            if (isOpen) continue;
            sb.append(c);
        }
        if (isOpen) {
            throw new PatternException("Invalid '{' at position " + openPos + " in expression \"" + expression + "\"");
        }
        return sb.toString();
    }
}

