/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.question.computing;

import java.util.List;
import java.util.Map;
import org.ametys.plugins.forms.question.computing.AbstractStaticComputingType;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ViewItem;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CurrentPageIdComputingType
extends AbstractStaticComputingType
implements Contextualizable {
    protected Context _context;
    protected AmetysObjectResolver _resolver;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    @Override
    public Object getComputedValue(FormQuestion question, FormEntry entry) {
        Request request = ContextHelper.getRequest((Context)this._context);
        return request.getParameter(question.getNameForForm());
    }

    @Override
    public Map<String, ModelItem> getModelItems() {
        return Map.of();
    }

    @Override
    public String getStorageType(FormQuestion question) {
        return "string";
    }

    @Override
    public List<ViewItem> getViewElements() {
        return List.of();
    }

    @Override
    public void saxAdditionalValue(ContentHandler contentHandler, FormQuestion question, FormEntry entry) throws SAXException {
        Page page;
        String pageId = (String)entry.getValue(question.getNameForForm());
        if (StringUtils.isNotBlank((String)pageId) && (page = this._silentlyResolve(pageId)) != null) {
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"page");
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"title", (String)page.getTitle());
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"id", (String)page.getId());
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"page");
        }
    }

    private Page _silentlyResolve(String pageId) {
        try {
            return (Page)this._resolver.resolveById(pageId);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getJSRenderer() {
        return "Ametys.plugins.forms.helper.SearchEntriesGridHelper.renderPage";
    }

    @Override
    public Object valueToJSONForClient(Object value, FormQuestion question, FormEntry entry, ModelItem modelItem) throws Exception {
        Page page;
        String pageId;
        String string = pageId = value != null ? (String)value : null;
        if (StringUtils.isNotBlank((String)pageId) && (page = this._silentlyResolve(pageId)) != null) {
            return Map.of("id", page.getId(), "title", page.getTitle());
        }
        return value;
    }

    @Override
    public boolean canEdit() {
        return false;
    }
}

