/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.workflow;

import com.opensymphony.workflow.Workflow;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ametys.cms.workflow.history.DescriptionStep;
import org.ametys.cms.workflow.history.ElementWithWorkflow;
import org.ametys.cms.workflow.history.HistoryStep;
import org.ametys.cms.workflow.history.WorkflowAction;
import org.ametys.cms.workflow.history.WorkflowHistory;
import org.ametys.cms.workflow.history.WorkflowHistoryHelper;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.forms.FormsException;
import org.ametys.plugins.forms.data.Answer;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.WebConstants;
import org.ametys.web.WebHelper;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractFormDashboardGenerator
extends ServiceableGenerator {
    protected CurrentUserProvider _currentUserProvider;
    protected WorkflowHistoryHelper _workflowHistoryHelper;
    protected WorkflowHelper _workflowHelper;
    protected UserHelper _userHelper;
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._workflowHistoryHelper = (WorkflowHistoryHelper)smanager.lookup(WorkflowHistoryHelper.ROLE);
        this._workflowHelper = (WorkflowHelper)smanager.lookup(WorkflowHelper.ROLE);
        this._userHelper = (UserHelper)smanager.lookup(UserHelper.ROLE);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        UserIdentity user = this._currentUserProvider.getUser();
        if (user == null) {
            this.getLogger().warn("No user is connected. Return no anwsers.");
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"no-user-connected");
        } else {
            this._saxFormDashboardData(user);
        }
        this.contentHandler.endDocument();
    }

    protected void _saxFormDashboardData(UserIdentity user) throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"answers");
        this._saxAnswers(user);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"answers");
    }

    protected void _saxAnswers(UserIdentity user) {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String siteName = WebHelper.getSiteName((Request)request);
        String lang = (String)request.getAttribute("sitemapLanguage");
        ZoneItem zoneItem = (ZoneItem)request.getAttribute(WebConstants.REQUEST_ATTR_ZONEITEM);
        if (zoneItem == null) {
            String zoneItemId = request.getParameter("zoneItemId");
            zoneItem = (ZoneItem)this._resolver.resolveById(zoneItemId);
        }
        boolean showAnswerWithWorkflow = (Boolean)zoneItem.getServiceParameters().getValue("no-workflow", false, (Object)false);
        try {
            List<Answer> answers = this._getAnswers(request, siteName, lang, user);
            if (!showAnswerWithWorkflow) {
                answers = answers.stream().filter(a -> StringUtils.isNotBlank((String)a.getWorkflowName())).collect(Collectors.toList());
            }
            for (Answer answer : answers) {
                this._saxAnswer(answer, user);
            }
        }
        catch (Exception e) {
            this.getLogger().error("An error occurred saxing answers", (Throwable)e);
        }
    }

    protected void _saxAnswer(Answer answer, UserIdentity user) throws Exception {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("formId", answer.getFormId());
        attrs.addCDATAAttribute("formLabel", URIUtils.decode((String)answer.getFormLabel()));
        attrs.addCDATAAttribute("creationDate", DateUtils.dateToString((Date)answer.getCreationDate()));
        attrs.addCDATAAttribute("id", answer.getId());
        attrs.addCDATAAttribute("number", String.valueOf(answer.getNumber()));
        attrs.addCDATAAttribute("user", this._userHelper.getUserFullName(answer.getUser()));
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"answer", (Attributes)attrs);
        this._saxWorkflowInformations(answer, user);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"answer");
    }

    protected abstract List<Answer> _getAnswers(Request var1, String var2, String var3, UserIdentity var4) throws FormsException;

    protected abstract Workflow _getWorkflow(Answer var1);

    protected void _saxWorkflowInformations(Answer answer, UserIdentity user) throws Exception {
        Integer workflowId = answer.getWorkflowId();
        if (workflowId != null && workflowId != -1) {
            ElementWithWorkflow element = new ElementWithWorkflow(answer.getFormLabel(), DateUtils.asZonedDateTime((Date)answer.getCreationDate()), answer.getUser());
            int initialActionId = this._workflowHelper.getInitialAction(answer.getWorkflowName());
            WorkflowHistory workflowHistory = this._workflowHistoryHelper.getWorkflowHistory(element, (long)workflowId.intValue(), this._getWorkflow(answer), initialActionId);
            for (HistoryStep step : workflowHistory.getSteps()) {
                AttributesImpl stepAttrs = new AttributesImpl();
                Optional comments = step.getComments();
                if (comments.isPresent()) {
                    stepAttrs.addCDATAAttribute("comments", (String)comments.get());
                }
                stepAttrs.addCDATAAttribute("date", DateUtils.dateToString((Date)step.getDate()));
                stepAttrs.addCDATAAttribute("isCurrent", String.valueOf(step.isCurrent()));
                stepAttrs.addCDATAAttribute("id", String.valueOf(step.getId()));
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"step", (Attributes)stepAttrs);
                this._saxDescription(step);
                this._saxAction(step);
                this._saxCaller(step);
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"step");
            }
        }
    }

    private void _saxDescription(HistoryStep step) throws SAXException {
        DescriptionStep description = step.getDescription();
        AttributesImpl descAttrs = new AttributesImpl();
        descAttrs.addCDATAAttribute("icon", (String)description.getMediumIcon().get());
        descAttrs.addCDATAAttribute("status", description.getStatus());
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"description", (Attributes)descAttrs);
        I18nizableText desc = description.getDescription();
        desc.toSAX(this.contentHandler, "label");
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"description");
    }

    private void _saxAction(HistoryStep step) throws SAXException {
        WorkflowAction workflowAction = step.getWorkflowAction();
        AttributesImpl actionAttrs = new AttributesImpl();
        actionAttrs.addCDATAAttribute("icon", (String)workflowAction.getMediumIcon().get());
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"action", (Attributes)actionAttrs);
        I18nizableText label = workflowAction.getLabel();
        label.toSAX(this.contentHandler, "label");
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"action");
    }

    private void _saxCaller(HistoryStep step) throws SAXException {
        Optional caller = step.getCaller();
        if (caller.isPresent()) {
            this._userHelper.saxUserIdentity((UserIdentity)caller.get(), this.contentHandler, "caller");
        }
    }
}

