/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.workflow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public abstract class AbstractMailInformationHelper
extends AbstractLogEnabled
implements Component,
Serviceable {
    protected CurrentUserProvider _currentUserProvider;
    protected UserManager _userManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._userManager = (UserManager)serviceManager.lookup(UserManager.ROLE);
    }

    @Callable
    public Map<String, Object> getMailInfo(String formId, Object entryId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Cloneable> sendMail = new HashMap<String, Cloneable>();
        ArrayList<Map<String, Object>> emails = new ArrayList<Map<String, Object>>();
        UserIdentity userIdentity = this._currentUserProvider.getUser();
        User user = this._userManager.getUser(userIdentity.getPopulationId(), userIdentity.getLogin());
        if (user != null) {
            HashMap<String, String> currentUser = new HashMap<String, String>();
            currentUser.put("email", user.getEmail());
            currentUser.put("fullname", user.getFullName());
            sendMail.put("current-user", currentUser);
            for (MailInfo mailInfo : this._getMailInfos(formId, entryId)) {
                emails.add(mailInfo.toJson());
            }
        }
        sendMail.put("emails", emails);
        result.put("send-mail", sendMail);
        return result;
    }

    protected abstract List<MailInfo> _getMailInfos(String var1, Object var2);

    public static class MailInfo {
        private String _email;
        private String _displayValue;

        public MailInfo(String email, String displayValue) {
            this._email = email;
            this._displayValue = displayValue;
        }

        public String getEmail() {
            return this._email;
        }

        public String getDisplayValue() {
            return this._displayValue;
        }

        public Map<String, Object> toJson() {
            HashMap<String, Object> email = new HashMap<String, Object>();
            email.put("displayValue", this._displayValue);
            email.put("value", this._email);
            return email;
        }
    }
}

