/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.workflow;

import com.opensymphony.workflow.Workflow;
import com.opensymphony.workflow.spi.Step;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.cms.repository.Content;
import org.ametys.cms.workflow.AbstractContentWorkflowComponent;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.forms.FormsException;
import org.ametys.plugins.forms.content.Form;
import org.ametys.plugins.forms.content.data.FieldValue;
import org.ametys.plugins.forms.content.data.UserEntry;
import org.ametys.plugins.forms.content.jcr.FormPropertiesManager;
import org.ametys.plugins.forms.content.table.FormTableManager;
import org.ametys.plugins.forms.workflow.AbstractFormEntriesWorkflowStepsClientSideElement;
import org.ametys.plugins.workflow.AbstractWorkflowComponent;
import org.ametys.plugins.workflow.store.JdbcWorkflowStore;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class FormEntriesWorkflowStepsClientSideElement
extends AbstractFormEntriesWorkflowStepsClientSideElement {
    protected FormPropertiesManager _formPropertiesManager;
    protected FormTableManager _formTableManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._formPropertiesManager = (FormPropertiesManager)((Object)serviceManager.lookup(FormPropertiesManager.ROLE));
        this._formTableManager = (FormTableManager)serviceManager.lookup(FormTableManager.ROLE);
    }

    protected String _getDefaultMenuClassName() {
        return "Ametys.plugins.forms.workflow.FormEntriesWorkflowMenu";
    }

    protected String _getDefaultActionClassName() {
        return "Ametys.plugins.forms.workflow.FormEntriesWorkflowAction.doAction";
    }

    @Override
    protected List<ClientSideElement.ScriptFile> _getAdditionalScriptFiles() {
        ArrayList<ClientSideElement.ScriptFile> scriptFiles = new ArrayList<ClientSideElement.ScriptFile>();
        scriptFiles.add(new ClientSideElement.ScriptFile("/plugins/forms/resources/js/Ametys/plugins/forms/workflow/AbstractFormEntriesWorkflowAction.js"));
        scriptFiles.add(new ClientSideElement.ScriptFile("/plugins/forms/resources/js/Ametys/plugins/forms/workflow/FormEntriesWorkflowAction.js"));
        scriptFiles.add(new ClientSideElement.ScriptFile("/plugins/forms/resources/js/Ametys/plugins/forms/workflow/AbstractFormEntriesWorkflowMenu.js"));
        scriptFiles.add(new ClientSideElement.ScriptFile("/plugins/forms/resources/js/Ametys/plugins/forms/workflow/FormEntriesWorkflowMenu.js"));
        return scriptFiles;
    }

    protected String _getSelectionTargetId() {
        return "^(content-form)$";
    }

    @Override
    @Callable(rights={""})
    public Map<String, Object> getWorkflowState(List<Object> entryIds, String formId, String scriptId) {
        Content formContent = this._getContentIfAllowed(formId);
        ArrayList entries = new ArrayList();
        try {
            Form form = this._formPropertiesManager.getForm(formId);
            List<Object> allEntries = new ArrayList();
            Workflow workflow = this._workflowProvider.getExternalWorkflow(JdbcWorkflowStore.ROLE);
            List<Integer> entryIdsAsInt = entryIds.stream().filter(Integer.class::isInstance).map(Integer.class::cast).collect(Collectors.toList());
            allEntries = this._formTableManager.getSubmissions(form, new HashMap<String, FieldValue>(), 0, Integer.MAX_VALUE, entryIdsAsInt);
            for (UserEntry userEntry : allEntries) {
                for (ClientSideElement.Script script : this._scripts) {
                    if (!script.getId().equals(scriptId)) continue;
                    HashMap<String, Serializable> entryMap = new HashMap<String, Serializable>();
                    Integer workflowId = userEntry.getWorkflowId();
                    if (workflowId == null) continue;
                    List steps = workflow.getCurrentSteps((long)workflowId.intValue());
                    ArrayList<Integer> stepIds = new ArrayList<Integer>();
                    for (Step step : steps) {
                        stepIds.add(step.getStepId());
                    }
                    Integer workflowStepId = (Integer)script.getParameters().get("workflow-step");
                    if (!stepIds.contains(workflowStepId)) continue;
                    HashMap<String, Object> transientVars = new HashMap<String, Object>();
                    transientVars.put(AbstractContentWorkflowComponent.CONTENT_KEY, formContent);
                    transientVars.put(AbstractWorkflowComponent.FAIL_CONDITIONS_KEY, new ArrayList());
                    int[] availableActions = workflow.getAvailableActions((long)workflowId.intValue(), transientVars);
                    Arrays.sort(availableActions);
                    ArrayList<Integer> activeActions = new ArrayList<Integer>();
                    Iterator iterator = ((List)script.getParameters().get("workflow-actions-ids")).iterator();
                    while (iterator.hasNext()) {
                        int actionId = (Integer)iterator.next();
                        if (Arrays.binarySearch(availableActions, actionId) < 0) continue;
                        activeActions.add(actionId);
                    }
                    entryMap.put("id", Integer.valueOf(userEntry.getId()));
                    entryMap.put("actions", activeActions);
                    entries.add(entryMap);
                }
            }
        }
        catch (FormsException e) {
            this.getLogger().error("Error getting forms for a content.", (Throwable)e);
        }
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("entries", entries);
        return results;
    }

    private Content _getContentIfAllowed(String formId) {
        UserIdentity currentUser = this._currentUserProvider.getUser();
        try {
            Content content = this._formPropertiesManager.getFormContent(formId);
            if (this._rightManager.hasReadAccess(currentUser, (Object)content)) {
                return content;
            }
        }
        catch (FormsException e) {
            this.getLogger().error("An error occured while trying to retrieve the content of form '{}'", (Object)formId, (Object)e);
        }
        throw new AccessDeniedException("The user " + currentUser + " tried to access the workflow state of content form '" + formId + "' without sufficient rights");
    }
}

