<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
	xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
	exclude-result-prefixes="ametys resolver">

    <xsl:import href="plugin:forms://stylesheets/forms/questions/computing/cost.xsl"/>
    <xsl:import href="plugin:forms://stylesheets/forms/questions/computing/user.xsl"/>
    <xsl:import href="plugin:forms://stylesheets/forms/questions/computing/currentPageId.xsl"/>
    
    <xsl:template match="question[@type = 'form.Computed']">
        <div class="question computed" id="form-{$uniqueId}-q-{@name}">
            <xsl:variable name="computing-type" select="computing-type/@value"/>
            <xsl:choose>
                <xsl:when test="@canWrite = 'true'">
                    <xsl:apply-templates select="additional-infos/computing-type[@xsl-enabled = 'true' and @id = $computing-type]" mode="render-html">
                        <xsl:with-param name="title" select="title"/>
                        <xsl:with-param name="name" select="@name"/>
                    </xsl:apply-templates>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="additional-infos/computing-type[@xsl-enabled = 'true' and @id = $computing-type]" mode="read-only-render-html">
                        <xsl:with-param name="title" select="title"/>
                        <xsl:with-param name="name" select="@name"/>
                        <xsl:with-param name="value" select="entry-value" />
                    </xsl:apply-templates>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template> 
    
    <xsl:template match="question[@type='form.Computed']" mode="render-mail">
        <xsl:variable name="computing-type" select="additional-infos/@computed-type"/>
        <xsl:apply-templates select="question-infos/computing-type[@xsl-enabled = 'true' and @id = $computing-type]" mode="render-mail">
            <xsl:with-param name="value" select="."/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.Computed']" mode="init-values">
		<xsl:variable name="computing-type" select="computing-type/@value"/>
        <xsl:apply-templates select="additional-infos/computing-type[@xsl-enabled = 'true' and @id = $computing-type]" mode="render-js">
        	<xsl:with-param name="title" select="title"/>
            <xsl:with-param name="name" select="@name"/>
            <xsl:with-param name="value" select="entry-value"/>
        </xsl:apply-templates>
    </xsl:template>
</xsl:stylesheet>
