<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:docbook="http://docbook.org/ns/docbook"
							  xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1" exclude-result-prefixes="docbook resolver i18n">
                              
	<xsl:template match="computing-type[@xsl-enabled = 'true' and @id = 'org.ametys.plugins.forms.question.computing.Cost']"  mode ="render-js">
		<xsl:param name="title"/>
		<xsl:param name="name"/>
        
	    function updateCost_<xsl:value-of select="translate($name, '-', '_')" />_<xsl:value-of select="$uniqueId" />()
	    {
	      var unit = '<xsl:value-of select="../../currency/@value"/>';
             var unitSymbol = '';
             switch(unit)
             {
                 case 'euro': unitSymbol = '€'; break;
                 case 'pound': unitSymbol = '£'; break;
                 case 'dollar': unitSymbol = '$'; break;
             }
             
	      var costValue = 0;
             $j("*[data-cost]").each(function() {
               var input = $j(this);
               if (input.is(":checked") || input.is(":selected"))
               {
                   costValue += parseFloat(input.attr("data-cost"));
               }
             });
             
             $j("*[data-cost-value]").each(function() {
               var input = $j(this);
               costValue += parseFloat(input.attr("data-cost-value"));
             });
             
             var $costFd = $j('#' + '<xsl:value-of select="$name" />_<xsl:value-of select="$uniqueId" />');
             $costFd.find("[data-ametys-total-cost]").html(costValue);
             $costFd.find("[data-ametys-total-cost-unit]").html(unitSymbol);
	    }
	    
	    updateCost_<xsl:value-of select="translate($name, '-', '_')" />_<xsl:value-of select="$uniqueId" />(); // Do it now to avoid blinking if the page is long to load
		$j( document ).ready(function() {
		    
		    updateCost_<xsl:value-of select="translate($name, '-', '_')" />_<xsl:value-of select="$uniqueId" />(); // Do it on load to handle 'back' browser after submit
			
			FormListenersHelper.addListenerForInputs('<xsl:value-of select="$uniqueId" />', updateCost_<xsl:value-of select="translate($name, '-', '_')" />_<xsl:value-of select="$uniqueId" />);
		});
		
		
	</xsl:template>
	
	<xsl:template name="cost-computing-type-label">
       <xsl:param name="title" />
       
       <xsl:value-of select="$title" /><xsl:text> : </xsl:text>
    </xsl:template>
	
	<xsl:template match="computing-type[@xsl-enabled = 'true' and @id = 'org.ametys.plugins.forms.question.computing.Cost']" mode="render-html">
		<xsl:param name="title"/>
		<xsl:param name="name"/>
		
        <div class="computed"> 
       		<p name="{$name}" id="{$name}_{$uniqueId}" class="text">
       		   <xsl:call-template name="cost-computing-type-label">
       		       <xsl:with-param name="title" select="$title" />
       		   </xsl:call-template>
       		   <span class="total" data-ametys-total-cost=""></span>
       		   <span class="unit" data-ametys-total-cost-unit=""></span>
   		   </p>
        </div>
	</xsl:template>
	
	<xsl:template match="computing-type[@xsl-enabled = 'true' and @id = 'org.ametys.plugins.forms.question.computing.Cost']" mode="read-only-render-html">
        <xsl:param name="title"/>
        <xsl:param name="name"/>
        <xsl:param name="value"/>
        
        <div class="computed"> 
            <div class="label">
                <label for="{$name}_{$uniqueId}">
                    <xsl:value-of select="$title" />
                </label>
            </div>
            <div class="{$cssPrefix}__item_value">
                <p name="{$name}" id="{$name}_{$uniqueId}" class="text">
                    <span class="total" data-ametys-total-cost=""></span>
                    <span class="unit" data-ametys-total-cost-unit=""></span>
                </p>
           </div>
        </div>
    </xsl:template>
    
    <xsl:template match="computing-type[@xsl-enabled = 'true' and @id = 'org.ametys.plugins.forms.question.computing.Cost']" mode ="render-mail">
        <xsl:param name="value"/>
        <xsl:value-of select="$value"/>
    </xsl:template>
</xsl:stylesheet>