/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.helper;

import java.util.HashMap;
import java.util.Map;

import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang.StringUtils;

import org.ametys.cms.workflow.AmetysObjectCheckRightsCondition;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.plugins.workflow.support.WorkflowProvider;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;

import com.opensymphony.workflow.Workflow;

/**
 * Helper for manipulating workflows for {@link Form}
 */
public class FormWorkflowHelper extends AbstractLogEnabled implements Serviceable, Component
{
    /** Avalon Role */
    public static final String ROLE = FormWorkflowHelper.class.getName();
    
    /** The workflow provider */
    protected WorkflowProvider _workflowProvider;
    /** The workflow helper component */
    protected WorkflowHelper _workflowHelper;
    
    @Override
    public void service(ServiceManager serviceManager) throws ServiceException
    {
        _workflowProvider = (WorkflowProvider) serviceManager.lookup(WorkflowProvider.ROLE);
        _workflowHelper = (WorkflowHelper) serviceManager.lookup(WorkflowHelper.ROLE);
    }
    
    /**
     * Initialize workflow for form entry
     * @param entry the form entry
     * @throws Exception if an error occurred
     */
    public void initializeWorkflow(FormEntry entry) throws Exception
    {
        Form form = entry.getForm();
        String workflowName = form.getWorkflowName();
        if (StringUtils.isNotBlank(workflowName))
        {
            // create workflow with entry id
            Workflow workflow = _workflowProvider.getAmetysObjectWorkflow(entry);
            
            int initialActionId = _workflowHelper.getInitialAction(workflowName); 
            
            Map<String, Object> inputs = new HashMap<>();
            inputs.put(AmetysObjectCheckRightsCondition.AMETYS_OBJECT_KEY, entry);
            
            long workflowInstanceId = workflow.initialize(workflowName, initialActionId, inputs);
            entry.setWorkflowId(workflowInstanceId);
        }
    }
}
