/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.question.types;

import org.ametys.plugins.forms.helper.FormElementDefinitionHelper;
import org.ametys.plugins.forms.question.FormQuestionType;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.type.ModelItemTypeConstants;

/**
 * Provide all the necessary method to add a description to a {@link FormQuestionType}
 */
public interface DescriptibleFormQuestionType
{
    /** Constant for description attribute. */
    public static final String ATTRIBUTE_DESCRIPTION = "description";
    
    /**
     * Get a model item to include in the model return by FormQuestionType.getModel
     * @return the item
     */
    public default ModelItem getDescriptionModelItem()
    {
        return FormElementDefinitionHelper.getElementDefinition(ATTRIBUTE_DESCRIPTION, ModelItemTypeConstants.STRING_TYPE_ID, "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_DESCRIPTION", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_DESCRIPTION_DESC", null);
    }
    
    /**
     * Get a view element to include in the view returned by FormQuestionType.getView
     * @param model the question type model
     * @return the element
     */
    public default ViewElement getDescriptionViewElement(Model model)
    {
        ViewElement description = new ViewElement();
        description.setDefinition((ElementDefinition< ? >) model.getModelItem(ATTRIBUTE_DESCRIPTION));
        return description;
    }
    
    /**
     * Get the question description
     * @param question the question
     * @return the description
     */
    public default String getDescription(FormQuestion question)
    {
        return question.getValue(DescriptibleFormQuestionType.ATTRIBUTE_DESCRIPTION);
    }
}
