/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.rights;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

import org.ametys.core.right.AbstractStaticRightAssignmentContext;
import org.ametys.core.right.RightAssignmentContext;
import org.ametys.plugins.forms.dao.FormDirectoryDAO;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormDirectory;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.web.WebHelper;

/**
 * {@link RightAssignmentContext} for assigning rights to a {@link Form}
 */
public class FormsDirectoryRightAssignmentContext extends AbstractStaticRightAssignmentContext
{
    /** The id if this right context */
    public static final String ID = "right.assignment.context.formsdirectoryaccess";
    
    /** The Ametys object resolver */
    protected AmetysObjectResolver _resolver;

    /** The form directory DAO */
    protected FormDirectoryDAO _formDirectoryDAO;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _resolver = (AmetysObjectResolver) smanager.lookup(AmetysObjectResolver.ROLE);
        _formDirectoryDAO = (FormDirectoryDAO) smanager.lookup(FormDirectoryDAO.ROLE);
    }
    
    public Object convertJSContext(Object jsContext)
    {
        if (jsContext instanceof String)
        {
            if (jsContext.equals(FormDirectoryDAO.ROOT_FORM_DIRECTORY_ID))
            {
                Request request = ContextHelper.getRequest(_context);
                return _formDirectoryDAO.getFormDirectoriesRootNode(WebHelper.getSiteName(request));
            }
            else
            {
                return _resolver.resolveById((String) jsContext);
            }
        }
        return null;
    }

    public String getContextIdentifier(Object context)
    {
        if (context instanceof Form)
        {
            return ((Form) context).getTitle();
        }
        return null;
    }
    
    public Set<Object> getParentContexts(Object context)
    {
        if (context instanceof Form)
        {
            Form form = (Form) context;
            AmetysObject parent = form.getParent();
            return Collections.singleton(parent);
        }
        else if (context instanceof FormDirectory)
        {
            FormDirectory formDirectory = (FormDirectory) context;
            AmetysObject parent = formDirectory.getParent();
            return Collections.singleton(parent);
        }
        
        return null;
    }

    public List<Object> getRootContexts(Map<String, Object> contextParameters)
    {
        List<Object> rootContexts = new ArrayList<>();
        
        if (matchWorkspace(contextParameters))
        {
            Request request = ContextHelper.getRequest(_context);
            rootContexts.add(_formDirectoryDAO.getFormDirectoriesRootNode(WebHelper.getSiteName(request)));
        }
        
        return rootContexts;
    }
}
