/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.workflow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.runtime.i18n.I18nizableText;

/**
 * This class allows to gather the available form-dedicated workflows
 */
public class FormWorkflowClientSideElement extends StaticClientSideElement
{
    /** The Workflow helper */
    private WorkflowHelper _workflowHelper;
    
    @Override
    public void service(ServiceManager serviceManager) throws ServiceException
    {   
        super.service(serviceManager);
        _workflowHelper = (WorkflowHelper) serviceManager.lookup(WorkflowHelper.ROLE);
    }   
    
    @Override
    public Map<String, Object> configureInitialParameters(Configuration configuration) throws ConfigurationException
    {
        Map<String, Object> initialParameters = new HashMap<>(super.configureInitialParameters(configuration));

        String[] workflowNames = _workflowHelper.getWorkflowNames();
        
        Map<String, Object> workflowBuffer = new HashMap<> ();
        List<Map<String, Object>> workflowsList = new ArrayList<> ();
        
        workflowBuffer.put("label", new I18nizableText("plugin.forms", "PLUGINS_FORMS_FORMS_EDITOR_WORKFLOW_NO_WORKFLOW"));
        workflowBuffer.put("value", "");
        workflowsList.add(workflowBuffer);    
        
        for (String workflowName : workflowNames)
        {
            if (workflowName.startsWith("form-"))
            {
                workflowBuffer = new HashMap<>();
                workflowBuffer.put("value", new I18nizableText(workflowName));
                workflowBuffer.put("label", _workflowHelper.getWorkflowLabel(workflowName));
                workflowsList.add(workflowBuffer);   
            }
        }

        initialParameters.put("data", workflowsList);
        
        return initialParameters;
    }
}
