/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms;

import java.util.Map;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.authentication.AuthorizationRequiredException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;

public class CheckRightAction
extends ServiceableAction {
    private CurrentUserProvider _currentUserProvider;
    private RightManager _rightManager;

    public void service(ServiceManager smanager) throws ServiceException {
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._rightManager = (RightManager)smanager.lookup(RightManager.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        UserIdentity user = this._currentUserProvider.getUser();
        String rightId = parameters.getParameter("rightId");
        if (user == null) {
            throw new AuthorizationRequiredException();
        }
        if (this._rightManager.hasRight(user, rightId, (Object)"/cms") == RightManager.RightResult.RIGHT_ALLOW) {
            return null;
        }
        throw new AccessDeniedException("User " + String.valueOf(user) + " try to acces feature without convenient right");
    }
}

