/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.content.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.cms.content.ContentHelper;
import org.ametys.cms.repository.Content;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.SimpleMenu;
import org.ametys.plugins.forms.FormsException;
import org.ametys.plugins.forms.content.Form;
import org.ametys.plugins.forms.content.jcr.FormPropertiesManager;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public class FormsContentClientSideElement
extends SimpleMenu {
    private FormPropertiesManager _formPropertiesManager;
    private AmetysObjectResolver _resolver;
    private ContentHelper _contentHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._formPropertiesManager = (FormPropertiesManager)((Object)smanager.lookup(FormPropertiesManager.ROLE));
        this._contentHelper = (ContentHelper)smanager.lookup(ContentHelper.ROLE);
    }

    @Callable(rights={""})
    public Map<String, Object> getStatus(List<String> contentIds) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("forms", new ArrayList());
        results.put("noright-contents", new ArrayList());
        for (String contentId : contentIds) {
            Content content = (Content)this._resolver.resolveById(contentId);
            if (this._rightManager.currentUserHasReadAccess((Object)content)) {
                try {
                    List<Form> contentForms = this._formPropertiesManager.getForms(content);
                    for (Form form : contentForms) {
                        if (!StringUtils.isNotEmpty((CharSequence)form.getId()) || !StringUtils.isNotEmpty((CharSequence)form.getLabel())) continue;
                        HashMap<String, String> formParams = new HashMap<String, String>();
                        formParams.put("id", form.getId());
                        formParams.put("label", form.getLabel());
                        formParams.put("content-id", contentId);
                        formParams.put("content-title", this._contentHelper.getTitle(content));
                        List forms = (List)results.get("forms");
                        forms.add(formParams);
                    }
                    continue;
                }
                catch (FormsException e) {
                    this.getLogger().error("Error getting forms for a content.", (Throwable)e);
                    continue;
                }
            }
            List noRightContents = (List)results.get("noright-contents");
            noRightContents.add(contentId);
        }
        return results;
    }
}

