/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.content.data;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.jcr.Node;
import org.ametys.cms.content.ContentHelper;
import org.ametys.cms.repository.Content;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.right.RightManager;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.forms.FormsException;
import org.ametys.plugins.forms.content.Form;
import org.ametys.plugins.forms.content.data.FieldValue;
import org.ametys.plugins.forms.content.data.UserEntry;
import org.ametys.plugins.forms.content.jcr.FormPropertiesManager;
import org.ametys.plugins.forms.content.table.FormTableManager;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class GetFormsListAction
extends ServiceableAction {
    private FormPropertiesManager _formPropertiesManager;
    private FormTableManager _formTableManager;
    private AmetysObjectResolver _resolver;
    private ContentHelper _contentHelper;
    private RightManager _rightManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._formPropertiesManager = (FormPropertiesManager)((Object)serviceManager.lookup(FormPropertiesManager.ROLE));
        this._formTableManager = (FormTableManager)((Object)serviceManager.lookup(FormTableManager.ROLE));
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._contentHelper = (ContentHelper)serviceManager.lookup(ContentHelper.ROLE);
        this._rightManager = (RightManager)serviceManager.lookup(RightManager.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Map jsParameters = (Map)objectModel.get("parent-context");
        String siteName = (String)jsParameters.get("siteName");
        String language = (String)jsParameters.get("lang");
        if (StringUtils.isEmpty((CharSequence)siteName) || StringUtils.isEmpty((CharSequence)language)) {
            throw new ProcessingException("The site name and language must be provided.");
        }
        HashMap result = new HashMap();
        ArrayList formsList = new ArrayList();
        try {
            List<Node> contentNodes = this._formPropertiesManager.getFormContentNodes(siteName, language);
            for (Node contentNode : contentNodes) {
                Content content = (Content)this._resolver.resolve(contentNode, false);
                if (!this._rightManager.currentUserHasReadAccess((Object)content)) continue;
                List<Form> forms = this._formPropertiesManager.getForms(contentNode);
                for (Form form : forms) {
                    HashMap<String, String> formMap = new HashMap<String, String>();
                    try {
                        List<UserEntry> entries = this._formTableManager.getSubmissions(form, new HashMap<String, FieldValue>(), 0, Integer.MAX_VALUE, null);
                        int totalSubmissions = entries.size();
                        Date lastSubmissionDate = this._getLastSubmissionDate(entries);
                        formMap.put("id", form.getId());
                        formMap.put("label", URIUtils.decode((String)form.getLabel()));
                        formMap.put("contentName", content.getName());
                        formMap.put("contentId", content.getId());
                        formMap.put("contentTitle", this._contentHelper.getTitle(content));
                        formMap.put("authorFullName", (String)content.getCreator());
                        formMap.put("entriesAmount", String.valueOf(totalSubmissions));
                        formMap.put("lastEntry", lastSubmissionDate != null ? DateUtils.dateToString((Date)lastSubmissionDate) : null);
                        formMap.put("workflowName", Objects.toString(form.getWorkflowName(), ""));
                        formsList.add(formMap);
                    }
                    catch (FormsException e) {
                        this.getLogger().error("Failed to get SQL table for form '" + form.getId() + "' for content of id '" + content.getId() + "'", (Throwable)e);
                    }
                }
            }
            result.put("forms", formsList);
        }
        catch (Exception e) {
            throw new ProcessingException("An error occurred while processing the forms list.", (Throwable)e);
        }
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    private Date _getLastSubmissionDate(List<UserEntry> entries) {
        Date lastSubmissionDate = null;
        if (entries.size() > 0) {
            lastSubmissionDate = entries.get(0).getCreationDate();
            for (UserEntry entry : entries) {
                Date creationDate = entry.getCreationDate();
                if (!lastSubmissionDate.before(creationDate)) continue;
                lastSubmissionDate = creationDate;
            }
        }
        return lastSubmissionDate;
    }
}

