/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.content.workflow;

import java.io.IOException;
import java.util.Map;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.forms.FormsException;
import org.ametys.plugins.forms.content.Form;
import org.ametys.plugins.forms.content.data.FieldValue;
import org.ametys.plugins.forms.content.data.UserEntry;
import org.ametys.plugins.forms.content.processing.AbstractFormFieldGenerator;
import org.ametys.plugins.forms.content.table.FormTableManager;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FormEntryInformationGenerator
extends AbstractFormFieldGenerator {
    protected FormTableManager _formTableManager;
    protected CurrentUserProvider _currentUserProvider;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._formTableManager = (FormTableManager)((Object)smanager.lookup(FormTableManager.ROLE));
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String siteName = (String)request.get("siteName");
        String formId = (String)request.get("formId");
        String entryId = (String)request.get("entryId");
        this.contentHandler.startDocument();
        try {
            Form form = this._formPropManager.getForm(siteName, formId);
            if (form == null) {
                throw new ProcessingException("The form of ID '" + formId + " can't be found for site '" + siteName + "'.");
            }
            Map<String, FieldValue> columns = this._formTableManager.getColumns(form);
            UserEntry entry = this._formTableManager.getSubmission(form, columns, Integer.parseInt(entryId));
            UserIdentity currentUser = this._currentUserProvider.getUser();
            if (!entry.getUserIdentity().equals((Object)currentUser)) {
                throw new AccessDeniedException("User '" + String.valueOf(currentUser) + "' is not allowed to access to user entry data.");
            }
            AttributesImpl atts = new AttributesImpl();
            atts.addCDATAAttribute("id", entryId);
            atts.addCDATAAttribute("formId", formId);
            atts.addCDATAAttribute("siteName", siteName);
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"entry", (Attributes)atts);
            for (FieldValue fdValue : entry.getValues()) {
                this.saxFieldValue(fdValue);
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"entry");
        }
        catch (FormsException | SAXException e) {
            this.getLogger().error("An error occurred saxing entry information for form '" + formId + "' and entry '" + entryId + "'", (Throwable)e);
        }
        this.contentHandler.endDocument();
    }
}

