/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.dao;

import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.forms.dao.FormDirectoryDAO;
import org.ametys.plugins.forms.dao.FormEntryDAO;
import org.ametys.plugins.forms.dao.FormPageDAO;
import org.ametys.plugins.forms.helper.ScheduleOpeningHelper;
import org.ametys.plugins.forms.repository.CopyFormUpdater;
import org.ametys.plugins.forms.repository.CopyFormUpdaterExtensionPoint;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormDirectory;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.ModifiableAmetysObject;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.TraversableAmetysObject;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.data.holder.ModifiableDataHolder;
import org.ametys.plugins.repository.jcr.NameHelper;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.page.ModifiableZoneItem;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.page.ZoneDAO;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.repository.site.SiteManager;
import org.ametys.web.service.Service;
import org.ametys.web.service.ServiceExtensionPoint;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class FormDAO
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = FormDAO.class.getName();
    public static final String HANDLE_FORMS_RIGHT_ID = "Plugins_Forms_Right_Handle";
    private static final String __FORM_NAME_PREFIX = "form-";
    protected AmetysObjectResolver _resolver;
    protected CurrentUserProvider _userProvider;
    protected I18nUtils _i18nUtils;
    protected FormDirectoryDAO _formDirectoryDAO;
    protected FormPageDAO _formPageDAO;
    protected FormEntryDAO _formEntryDAO;
    protected UserHelper _userHelper;
    protected Repository _repository;
    protected RightManager _rightManager;
    protected ServiceExtensionPoint _serviceEP;
    protected ZoneDAO _zoneDAO;
    protected ScheduleOpeningHelper _scheduleOpeningHelper;
    protected WorkflowHelper _workflowHelper;
    protected SiteManager _siteManager;
    protected ObservationManager _observationManager;
    protected CurrentUserProvider _currentUserProvider;
    protected CopyFormUpdaterExtensionPoint _copyFormEP;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._userProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._userHelper = (UserHelper)manager.lookup(UserHelper.ROLE);
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._formDirectoryDAO = (FormDirectoryDAO)((Object)manager.lookup(FormDirectoryDAO.ROLE));
        this._formPageDAO = (FormPageDAO)((Object)manager.lookup(FormPageDAO.ROLE));
        this._formEntryDAO = (FormEntryDAO)((Object)manager.lookup(FormEntryDAO.ROLE));
        this._repository = (Repository)manager.lookup("javax.jcr.Repository");
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._serviceEP = (ServiceExtensionPoint)manager.lookup(ServiceExtensionPoint.ROLE);
        this._zoneDAO = (ZoneDAO)manager.lookup(ZoneDAO.ROLE);
        this._scheduleOpeningHelper = (ScheduleOpeningHelper)((Object)manager.lookup(ScheduleOpeningHelper.ROLE));
        this._workflowHelper = (WorkflowHelper)manager.lookup(WorkflowHelper.ROLE);
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
        this._observationManager = (ObservationManager)manager.lookup(ObservationManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._copyFormEP = (CopyFormUpdaterExtensionPoint)((Object)manager.lookup(CopyFormUpdaterExtensionPoint.ROLE));
    }

    public boolean hasReadRightOnForm(UserIdentity userIdentity, Form form) {
        return this._rightManager.hasReadAccess(userIdentity, (Object)form);
    }

    public boolean hasWriteRightOnForm(UserIdentity userIdentity, AmetysObject formElement) {
        return this._rightManager.hasRight(userIdentity, HANDLE_FORMS_RIGHT_ID, (Object)formElement) == RightManager.RightResult.RIGHT_ALLOW;
    }

    public boolean hasRightAffectationRightOnForm(UserIdentity userIdentity, Form form) {
        return this.hasWriteRightOnForm(userIdentity, (AmetysObject)form) || this._rightManager.hasRight(userIdentity, "Runtime_Rights_Rights_Handle", (Object)"/cms") == RightManager.RightResult.RIGHT_ALLOW;
    }

    public void checkHandleFormRight(AmetysObject formElement) {
        UserIdentity user = this._userProvider.getUser();
        if (!this.hasWriteRightOnForm(user, formElement)) {
            throw new AccessDeniedException("User '" + String.valueOf(user) + "' tried to handle forms without convenient right [Plugins_Forms_Right_Handle]");
        }
    }

    public List<Form> getForms(String siteName) {
        String xpathQuery = "//element(" + siteName + ", ametys:site)//element(*, ametys:form)";
        return this._resolver.query(xpathQuery).stream().filter(Form.class::isInstance).map(Form.class::cast).collect(Collectors.toList());
    }

    @Callable(rights={"*"})
    public Map<String, Object> getFormProperties(String formId, boolean full, boolean withRights) {
        try {
            Form form = (Form)this._resolver.resolveById(formId);
            return this.getFormProperties(form, full, true);
        }
        catch (UnknownAmetysObjectException e) {
            this.getLogger().warn("Can't find form with id: {}. It probably has just been deleted", (Object)formId, (Object)e);
            HashMap<String, Object> infos = new HashMap<String, Object>();
            infos.put("id", formId);
            return infos;
        }
    }

    public Map<String, Object> getFormProperties(Form form, boolean full, boolean withRights) {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        List<FormEntry> entries = this._formEntryDAO.getFormEntries(form, false, List.of(new FormEntryDAO.Sort("ametys-submit-date", "descending")));
        List<SitemapElement> pages = this.getFormPage(form.getId(), form.getSiteName());
        String workflowName = form.getWorkflowName();
        infos.put("type", "root");
        infos.put("isForm", true);
        infos.put("author", this._userHelper.user2json(form.getAuthor(), true));
        infos.put("contributor", this._userHelper.user2json(form.getContributor()));
        infos.put("lastModificationDate", DateUtils.zonedDateTimeToString((ZonedDateTime)form.getLastModificationDate()));
        infos.put("creationDate", DateUtils.zonedDateTimeToString((ZonedDateTime)form.getCreationDate()));
        infos.put("entriesAmount", entries.size());
        infos.put("lastEntry", this._getLastSubmissionDate(entries));
        infos.put("workflowLabel", StringUtils.isNotBlank((CharSequence)workflowName) ? this._workflowHelper.getWorkflowLabel(workflowName) : new I18nizableText("plugin.forms", "PLUGINS_FORMS_FORMS_EDITOR_WORKFLOW_NO_WORKFLOW"));
        infos.put("id", form.getId());
        infos.put("name", form.getName());
        infos.put("title", form.getTitle());
        infos.put("fullPath", this.getFormFullPath(form.getId()));
        infos.put("pages", this._getPagesInfos(pages));
        infos.put("hasChildren", form.getPages().size() > 0);
        infos.put("workflowName", workflowName);
        infos.put("isConfigured", this.isFormConfigured(form));
        UserIdentity currentUser = this._userProvider.getUser();
        if (withRights) {
            Set<String> userRights = this._getUserRights(form);
            infos.put("rights", userRights);
            infos.put("canEditRight", userRights.contains(HANDLE_FORMS_RIGHT_ID) || this._rightManager.hasRight(currentUser, "Runtime_Rights_Rights_Handle", (Object)"/cms") == RightManager.RightResult.RIGHT_ALLOW);
        } else {
            boolean canWrite = this.hasWriteRightOnForm(currentUser, (AmetysObject)form);
            infos.put("canWrite", canWrite);
            infos.put("canEditRight", canWrite || this._rightManager.hasRight(currentUser, "Runtime_Rights_Rights_Handle", (Object)"/cms") == RightManager.RightResult.RIGHT_ALLOW);
            infos.put("canRead", this.hasReadRightOnForm(currentUser, form));
        }
        if (full) {
            infos.put("isPublished", !pages.isEmpty());
            infos.put("hasEntries", !entries.isEmpty());
            infos.put("nbEntries", form.getActiveEntries().size());
            FormDirectory formDirectoriesRoot = this._formDirectoryDAO.getFormDirectoriesRootNode(form.getSiteName());
            String parentId = form.getParent().getId().equals(formDirectoriesRoot.getId()) ? "root" : form.getParent().getId();
            infos.put("parentId", parentId);
            infos.put("isLimitedToOneEntryByUser", form.isLimitedToOneEntryByUser());
            infos.put("isEntriesLimited", form.isEntriesLimited());
            Optional<Long> maxEntries = form.getMaxEntries();
            if (maxEntries.isPresent()) {
                infos.put("maxEntries", maxEntries.get());
            }
            infos.put("isQueueEnabled", form.isQueueEnabled());
            Optional<Long> queueSize = form.getQueueSize();
            if (queueSize.isPresent()) {
                infos.put("queueSize", queueSize.get());
            }
            infos.put("expirationEnabled", form.isExpirationEnabled());
            LocalDate startDate = form.getStartDate();
            LocalDate endDate = form.getEndDate();
            if (startDate != null || endDate != null) {
                infos.put("scheduleStatus", (Object)this._scheduleOpeningHelper.getStatus(form));
                if (startDate != null) {
                    infos.put("startDate", DateUtils.localDateToString((LocalDate)startDate));
                }
                if (endDate != null) {
                    infos.put("endDate", DateUtils.localDateToString((LocalDate)endDate));
                }
            }
            infos.put("adminEmails", form.hasValue("admin-email-subject"));
            infos.put("receiptAcknowledgement", form.hasValue("receipt-sender"));
            infos.put("isAnonymous", this._rightManager.hasAnonymousReadAccess((Object)form));
        }
        return infos;
    }

    @Callable(rights={"*"})
    public String getFormTitle(String formId) {
        Form form = (Form)this._resolver.resolveById(formId);
        return form.getTitle();
    }

    @Callable(rights={"*"})
    public String getFormFullPath(String formId) {
        Form form = (Form)this._resolver.resolveById(formId);
        String separator = " > ";
        Object fullPath = form.getTitle();
        FormDirectory parent = (FormDirectory)form.getParent();
        if (!this._formDirectoryDAO.isRoot(parent)) {
            fullPath = this._formDirectoryDAO.getFormDirectoryPath(parent, separator) + separator + (String)fullPath;
        }
        return fullPath;
    }

    protected Set<String> _getUserRights(Form form) {
        UserIdentity user = this._userProvider.getUser();
        return this._rightManager.getUserRights(user, (Object)form);
    }

    @Callable(rights={""})
    public Map<String, String> createForm(String siteName, String parentId, String name) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        FormDirectory parentDirectory = this._formDirectoryDAO.getFormDirectory(siteName, parentId);
        this._formDirectoryDAO.checkHandleFormDirectoriesRight((AmetysObject)parentDirectory);
        String uniqueName = NameHelper.getUniqueAmetysObjectName((TraversableAmetysObject)parentDirectory, (String)(__FORM_NAME_PREFIX + name));
        Form form = (Form)parentDirectory.createChild(uniqueName, "ametys:form");
        form.setTitle(name);
        form.setAuthor(this._userProvider.getUser());
        form.setCreationDate(ZonedDateTime.now());
        form.setLastModificationDate(ZonedDateTime.now());
        parentDirectory.saveChanges();
        String formId = form.getId();
        this._formPageDAO.createPage(formId, this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.forms", "PLUGINS_FORMS_CREATE_PAGE_DEFAULT_NAME")));
        result.put("id", formId);
        result.put("name", form.getTitle());
        return result;
    }

    @Callable(rights={""})
    public Map<String, String> renameForm(String id, String newName) {
        HashMap<String, String> results = new HashMap<String, String>();
        Form form = (Form)this._resolver.resolveById(id);
        this.checkHandleFormRight((AmetysObject)form);
        String uniqueName = NameHelper.getUniqueAmetysObjectName((TraversableAmetysObject)((TraversableAmetysObject)form.getParent()), (String)(__FORM_NAME_PREFIX + newName));
        Node node = form.getNode();
        try {
            node.getSession().move(node.getPath(), node.getParent().getPath() + "/" + uniqueName);
            node.getSession().save();
            form.setTitle(newName);
            form.setContributor(this._userProvider.getUser());
            form.setLastModificationDate(ZonedDateTime.now());
            form.saveChanges();
            results.put("newName", form.getTitle());
        }
        catch (RepositoryException e) {
            this.getLogger().warn("Form renaming failed.", (Throwable)e);
            results.put("message", "cannot-rename");
        }
        results.put("id", id);
        return results;
    }

    @Callable(rights={""})
    public Map<String, String> copyForm(String formDirectoryId, String formId) {
        HashMap<String, String> result = new HashMap<String, String>();
        Form originalForm = (Form)this._resolver.resolveById(formId);
        FormDirectory parentFormDirectory = (FormDirectory)this._resolver.resolveById(formDirectoryId);
        this._formDirectoryDAO.checkHandleFormDirectoriesRight((AmetysObject)parentFormDirectory);
        String uniqueName = NameHelper.getUniqueAmetysObjectName((TraversableAmetysObject)parentFormDirectory, (String)(__FORM_NAME_PREFIX + originalForm.getTitle()));
        Form cForm = originalForm.copyTo((ModifiableTraversableAmetysObject)parentFormDirectory, uniqueName);
        originalForm.copyTo((ModifiableDataHolder)cForm);
        String copyTitle = this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.forms", "PLUGIN_FORMS_TREE_COPY_NAME_PREFIX")) + originalForm.getTitle();
        cForm.setTitle(copyTitle);
        cForm.setAuthor(this._userProvider.getUser());
        cForm.setCreationDate(ZonedDateTime.now());
        cForm.setLastModificationDate(ZonedDateTime.now());
        cForm.saveChanges();
        for (String epId : this._copyFormEP.getExtensionsIds()) {
            CopyFormUpdater copyFormUpdater = (CopyFormUpdater)this._copyFormEP.getExtension(epId);
            copyFormUpdater.updateForm(originalForm, cForm);
        }
        result.put("id", cForm.getId());
        return result;
    }

    @Callable(rights={""})
    public Map<String, String> deleteForm(String id) {
        HashMap<String, String> result = new HashMap<String, String>();
        Form form = (Form)this._resolver.resolveById(id);
        this.checkHandleFormRight((AmetysObject)form);
        List<SitemapElement> pages = this.getFormPage(form.getId(), form.getSiteName());
        if (!pages.isEmpty()) {
            throw new AccessDeniedException("Can't delete form ('" + form.getId() + "') which contains pages");
        }
        ModifiableAmetysObject parent = (ModifiableAmetysObject)form.getParent();
        form.remove();
        parent.saveChanges();
        result.put("id", id);
        return result;
    }

    @Callable(rights={""})
    public Map<String, Object> moveForm(String siteName, String id, String newParentId) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        Form form = (Form)this._resolver.resolveById(id);
        FormDirectory directory = this._formDirectoryDAO.getFormDirectory(siteName, newParentId);
        if (this.hasWriteRightOnForm(this._userProvider.getUser(), (AmetysObject)form) && this._formDirectoryDAO.hasWriteRightOnFormDirectory(this._userProvider.getUser(), directory)) {
            this._formDirectoryDAO.move(form, siteName, newParentId, results);
        } else {
            results.put("message", "not-allowed");
        }
        results.put("id", form.getId());
        return results;
    }

    @Callable(rights={""})
    public Map<String, String> setWorkflow(String formId, String workflowName) {
        HashMap<String, String> results = new HashMap<String, String>();
        Form form = (Form)this._resolver.resolveById(formId);
        this.checkHandleFormRight((AmetysObject)form);
        form.setWorkflowName(workflowName);
        form.setContributor(this._userProvider.getUser());
        form.setLastModificationDate(ZonedDateTime.now());
        form.saveChanges();
        results.put("id", formId);
        HashMap<String, Form> eventParams = new HashMap<String, Form>();
        eventParams.put("form", form);
        this._observationManager.notify(new Event("form.modified", this._currentUserProvider.getUser(), eventParams));
        return results;
    }

    protected ZonedDateTime _getLastSubmissionDate(List<FormEntry> entries) {
        return entries.isEmpty() ? null : entries.get(0).getSubmitDate();
    }

    public AmetysObjectIterable<ModifiableZoneItem> getFormZoneItems(String formId, String siteName) {
        String xpathQuery = "//element(" + siteName + ", ametys:site)//element(*, ametys:zoneItem)[@ametys-internal:service = 'org.ametys.forms.service.Display' and ametys:service_parameters/@ametys:formId = '" + formId + "']";
        return this._resolver.query(xpathQuery);
    }

    public String getFormLocale(Form form) {
        List<SitemapElement> zoneItems = this.getFormPage(form.getId(), form.getSiteName());
        return zoneItems.stream().findFirst().map(SitemapElement::getSitemapName).orElse(null);
    }

    public List<SitemapElement> getFormPage(String formId, String siteName) {
        AmetysObjectIterable<ModifiableZoneItem> zoneItems = this.getFormZoneItems(formId, siteName);
        return zoneItems.stream().map(z -> z.getZone().getSitemapElement()).collect(Collectors.toList());
    }

    protected List<Map<String, Object>> _getPagesInfos(List<SitemapElement> pages) {
        ArrayList<Map<String, Object>> pagesInfos = new ArrayList<Map<String, Object>>();
        for (SitemapElement sitemapElement : pages) {
            HashMap<String, Object> info = new HashMap<String, Object>();
            info.put("id", sitemapElement.getId());
            info.put("title", sitemapElement.getTitle());
            info.put("isPage", sitemapElement instanceof Page);
            pagesInfos.add(info);
        }
        return pagesInfos;
    }

    @Callable(rights={"*"})
    public List<Map<String, Object>> getFormDisplayViews(String formId, String siteName, String language) throws Exception {
        ArrayList<Map<String, Object>> jsonifiedViews = new ArrayList<Map<String, Object>>();
        Service service = (Service)this._serviceEP.getExtension("org.ametys.forms.service.Display");
        ElementDefinition viewElementDefinition = service.getParameters().getOrDefault("xslt", null);
        String xpathQuery = "//element(" + siteName + ", ametys:site)/ametys-internal:sitemaps/" + language + "//element(*, ametys:zoneItem)[@ametys-internal:service = 'org.ametys.forms.service.Display' and ametys:service_parameters/@ametys:formId = '" + formId + "']";
        AmetysObjectIterable zoneItems = this._resolver.query(xpathQuery);
        Optional<Object> existedServiceView = zoneItems.stream().map(ZoneItem::getServiceParameters).map(sp -> sp.getValue("xslt")).findFirst();
        Map typedEntries = viewElementDefinition.getEnumerator().getEntries();
        for (String id : typedEntries.keySet()) {
            HashMap<String, Object> viewAsJson = new HashMap<String, Object>();
            viewAsJson.put("id", id);
            viewAsJson.put("label", typedEntries.get(id));
            Boolean isServiceView = existedServiceView.map(s -> s.equals(id)).orElse(false);
            if (isServiceView.booleanValue() || existedServiceView.isEmpty() && id.equals(viewElementDefinition.getDefaultValue())) {
                viewAsJson.put("isDefault", true);
            }
            jsonifiedViews.add(viewAsJson);
        }
        return jsonifiedViews;
    }

    public boolean isFormConfigured(Form form) {
        List<FormQuestion> questions = form.getQuestions();
        return !questions.isEmpty() && !questions.stream().anyMatch(q -> !q.getType().isQuestionConfigured((FormQuestion)((Object)q)));
    }

    public String getDashboardUri(String siteName) {
        String xpathQuery = "//element(" + siteName + ", ametys:site)//element(*, ametys:zoneItem)[@ametys-internal:service = 'org.ametys.plugins.forms.workflow.service.dashboard']";
        AmetysObjectIterable zoneItems = this._resolver.query(xpathQuery);
        Optional<Page> dashboardPage = zoneItems.stream().map(z -> z.getZone().getSitemapElement()).filter(Page.class::isInstance).map(Page.class::cast).findAny();
        if (dashboardPage.isPresent()) {
            Page page = dashboardPage.get();
            String pagePath = page.getSitemap().getName() + "/" + page.getPathInSitemap() + ".html";
            String url = this._siteManager.getSite(siteName).getUrl();
            return url + "/" + pagePath;
        }
        return "";
    }

    public String getAdminDashboardUri(String siteName) {
        String xpathQuery = "//element(" + siteName + ", ametys:site)//element(*, ametys:zoneItem)[@ametys-internal:service = 'org.ametys.plugins.forms.workflow.service.admin.dashboard']";
        AmetysObjectIterable zoneItems = this._resolver.query(xpathQuery);
        Optional<Page> dashboardPage = zoneItems.stream().map(z -> z.getZone().getSitemapElement()).filter(Page.class::isInstance).map(Page.class::cast).findAny();
        if (dashboardPage.isPresent()) {
            Page page = dashboardPage.get();
            String pagePath = page.getSitemap().getName() + "/" + page.getPathInSitemap() + ".html";
            String url = this._siteManager.getSite(siteName).getUrl();
            return url + "/" + pagePath;
        }
        return "";
    }

    @Callable(rights={"Plugins_Forms_Right_Handle"}, rightContext="right.assignment.context.formsdirectoryaccess", paramIndex=0)
    public Map<String, Object> getFormExpiration(String formId) {
        Form form = (Form)this._resolver.resolveById(formId);
        return Map.of("expirationEnabled", form.isExpirationEnabled(), "expirationPeriod", form.getExpirationPeriod(), "expirationPolicy", form.getExpirationPolicy().name());
    }

    @Callable(rights={"Plugins_Forms_Right_Handle"}, rightContext="right.assignment.context.formsdirectoryaccess", paramIndex=0)
    public void setExpirationPolicy(String formId, long expirationPeriod, String expirationPolicy) {
        Form form = (Form)this._resolver.resolveById(formId);
        form.setExpirationPolicy(true, expirationPeriod, Form.ExpirationPolicy.valueOf(expirationPolicy));
        form.saveChanges();
        this._observationManager.notify(new Event("form.modified", this._currentUserProvider.getUser(), Map.of("form", form)));
    }

    public void removeExpirationPolicy(String formId) {
        Form form = (Form)this._resolver.resolveById(formId);
        form.setExpirationPolicy(false, -1L, null);
        form.saveChanges();
        this._observationManager.notify(new Event("form.modified", this._currentUserProvider.getUser(), Map.of("form", form)));
    }
}

