/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.generators;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.forms.dao.FormEntryDAO;
import org.ametys.plugins.forms.dao.FormQuestionDAO;
import org.ametys.plugins.forms.question.FormQuestionType;
import org.ametys.plugins.forms.question.computing.ComputingType;
import org.ametys.plugins.forms.question.types.impl.ComputedQuestionType;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FormEntryInformationGenerator
extends ServiceableGenerator {
    protected CurrentUserProvider _currentUserProvider;
    protected AmetysObjectResolver _resolver;
    protected UserManager _userManager;
    protected FormEntryDAO _formEntryDAO;
    protected FormQuestionDAO _formQuestionDAO;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._userManager = (UserManager)smanager.lookup(UserManager.ROLE);
        this._formEntryDAO = (FormEntryDAO)((Object)smanager.lookup(FormEntryDAO.ROLE));
        this._formQuestionDAO = (FormQuestionDAO)((Object)smanager.lookup(FormQuestionDAO.ROLE));
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        String entryId = this._getFormEntryId();
        this.contentHandler.startDocument();
        try {
            FormEntry entry = (FormEntry)this._resolver.resolveById(entryId);
            this._checkRights(entry);
            this._saxEntry(entry);
        }
        catch (SAXException e) {
            this.getLogger().error("An error occurred saxing entry information for entry '" + entryId + "'", (Throwable)e);
        }
        this.contentHandler.endDocument();
    }

    protected void _checkRights(FormEntry entry) {
        UserIdentity currentUser = this._currentUserProvider.getUser();
        if (!entry.getUser().equals((Object)currentUser)) {
            throw new AccessDeniedException("User '" + String.valueOf(currentUser) + "' is not allowed to access to user entry data.");
        }
    }

    protected void _saxEntry(FormEntry entry) throws SAXException {
        Long entryId;
        AttributesImpl formAttrs = new AttributesImpl();
        formAttrs.addCDATAAttribute("formId", entry.getForm().getId());
        formAttrs.addCDATAAttribute("label", entry.getForm().getTitle());
        formAttrs.addCDATAAttribute("entryId", String.valueOf(entry.getEntryId()));
        ZonedDateTime submittedAt = entry.getSubmitDate().toInstant().atZone(ZoneId.systemDefault());
        formAttrs.addCDATAAttribute("id", entry.getId());
        formAttrs.addCDATAAttribute("creationDate", DateUtils.zonedDateTimeToString((ZonedDateTime)submittedAt));
        UserIdentity userIdentity = entry.getUser();
        if (userIdentity != null) {
            formAttrs.addCDATAAttribute("userId", UserIdentity.userIdentityToString((UserIdentity)userIdentity));
            User user = this._userManager.getUser(userIdentity);
            if (user != null) {
                formAttrs.addCDATAAttribute("user", user.getFullName());
            }
        }
        if ((entryId = entry.getEntryId()) != null) {
            formAttrs.addCDATAAttribute("entryId", String.valueOf(entryId));
        }
        this._addAdditionalEntryAttributes(entry, formAttrs);
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"entry", (Attributes)formAttrs);
        Optional<Long> currentStepId = entry.getForm().hasWorkflow() ? Optional.of(this._formEntryDAO.getCurrentStepId(entry)) : Optional.empty();
        List questions = this._getQuestions(entry, currentStepId).stream().filter(this::_displayField).collect(Collectors.toList());
        for (FormQuestion question : questions) {
            this._saxQuestion(question, entry);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"entry");
    }

    protected List<FormQuestion> _getQuestions(FormEntry entry, Optional<Long> currentStepId) {
        UserIdentity currentUser = this._currentUserProvider.getUser();
        boolean onlyReadableQuestion = currentUser != null && Objects.equals(currentUser, entry.getUser());
        return this._formQuestionDAO.getRuleFilteredQuestions(entry.getForm(), new FormQuestionDAO.FormEntryValues(null, entry), currentStepId, false, onlyReadableQuestion);
    }

    protected void _saxQuestion(FormQuestion question, FormEntry entry) throws SAXException {
        FormQuestionType type = question.getType();
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("type", type.getStorageType(question));
        attrs.addCDATAAttribute("typeId", type.getId());
        attrs.addCDATAAttribute("label", question.getTitle());
        attrs.addCDATAAttribute("name", question.getNameForForm());
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"field", (Attributes)attrs);
        type.saxEntryValue(this.contentHandler, question, entry);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"field");
    }

    protected void _addAdditionalEntryAttributes(FormEntry entry, AttributesImpl attrs) {
    }

    protected boolean _displayField(FormQuestion question) {
        FormQuestionType type = question.getType();
        if (type instanceof ComputedQuestionType) {
            ComputedQuestionType questionType = (ComputedQuestionType)type;
            ComputingType computingType = questionType.getComputingType(question);
            Set<String> displayXSLTs = questionType.getDisplayXSLTs();
            return displayXSLTs != null && !displayXSLTs.isEmpty() && computingType.hasComputedValue();
        }
        return true;
    }

    private String _getFormEntryId() {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String entryId = (String)request.get("entryId");
        if (entryId == null) {
            Map params = (Map)this.objectModel.get("parent-context");
            if (params != null) {
                entryId = (String)params.get("entryId");
            }
            if (entryId == null) {
                entryId = (String)request.getAttribute("entryId");
            }
        }
        return entryId;
    }
}

