/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.question.computing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.plugins.forms.question.computing.AbstractStaticComputingType;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.StaticEnumerator;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewItem;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class UserComputingType
extends AbstractStaticComputingType {
    public static final String ATTRIBUTE_USER_INFO = "user-info";
    public static final String EMAIL_USER_VALUE = "email";
    public static final String ID_USER_VALUE = "id";
    public static final String FULLNAME_USER_VALUE = "fullName";
    public static final String FIRSTNAME_USER_VALUE = "firstName";
    public static final String LASTNAME_USER_VALUE = "lastName";
    protected CurrentUserProvider _currentUserProvider;
    protected UserManager _userManager;
    protected Map<String, ModelItem> _userComputingItems;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
    }

    @Override
    public String getComputedValue(FormQuestion computedQuestion, FormEntry entry) {
        UserIdentity userIdentity = this._currentUserProvider.getUser();
        User user = userIdentity != null ? this._userManager.getUser(userIdentity) : null;
        return user != null ? this._getUserInfoValue(computedQuestion, user) : null;
    }

    @Override
    public Map<String, ModelItem> getModelItems() {
        this._userComputingItems = new HashMap<String, ModelItem>();
        ElementDefinition userInfos = this._formElementDefinitionHelper.getElementDefinition(ATTRIBUTE_USER_INFO, "string", "PLUGINS_FORMS_QUESTIONS_DIALOG_COMPUTING_USERS", "PLUGINS_FORMS_QUESTIONS_DIALOG_COMPUTING_USERS_DESC", null);
        StaticEnumerator userInfoStaticEnumerator = new StaticEnumerator();
        userInfoStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_AUTOFILL_EMAIL"), (Object)EMAIL_USER_VALUE);
        userInfoStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_AUTOFILL_ID"), (Object)ID_USER_VALUE);
        userInfoStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_AUTOFILL_FULLNAME"), (Object)FULLNAME_USER_VALUE);
        userInfoStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_AUTOFILL_FIRSTNAME"), (Object)FIRSTNAME_USER_VALUE);
        userInfoStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_AUTOFILL_LASTNAME"), (Object)LASTNAME_USER_VALUE);
        userInfos.setEnumerator((Enumerator)userInfoStaticEnumerator);
        userInfos.setDefaultValue((Object)FULLNAME_USER_VALUE);
        this._userComputingItems.put(userInfos.getName(), (ModelItem)userInfos);
        return this._userComputingItems;
    }

    @Override
    public List<ViewItem> getViewElements() {
        ArrayList<ViewItem> viewElements = new ArrayList<ViewItem>();
        ViewElement userSelect = new ViewElement();
        userSelect.setDefinition((ElementDefinition)this._userComputingItems.get(ATTRIBUTE_USER_INFO));
        viewElements.add((ViewItem)userSelect);
        return viewElements;
    }

    protected String _getUserInfoValue(FormQuestion question, User user) {
        String userInfo;
        switch (userInfo = (String)question.getValue(ATTRIBUTE_USER_INFO)) {
            case "email": {
                return user.getEmail();
            }
            case "id": {
                return user.getIdentity().getLogin();
            }
            case "fullName": {
                return user.getFullName();
            }
            case "firstName": {
                return user.getFirstName();
            }
            case "lastName": {
                return user.getLastName();
            }
        }
        return null;
    }

    @Override
    public String getStorageType(FormQuestion question) {
        return "string";
    }

    @Override
    public List<String> getFieldToDisableIfFormPublished() {
        List<String> fieldNames = super.getFieldToDisableIfFormPublished();
        fieldNames.add(ATTRIBUTE_USER_INFO);
        return fieldNames;
    }

    @Override
    public boolean canEdit() {
        return false;
    }

    @Override
    public Map<String, Object> getAnonymizedData(FormQuestion question) {
        return Collections.singletonMap(question.getNameForForm(), "anonymized");
    }
}

