/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.question.sources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.forms.helper.FormElementDefinitionHelper;
import org.ametys.plugins.forms.question.sources.ChoiceOption;
import org.ametys.plugins.forms.question.sources.ChoiceSourceType;
import org.ametys.plugins.forms.question.types.impl.ChoicesListQuestionType;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractSourceType
extends AbstractLogEnabled
implements ChoiceSourceType,
Serviceable,
Configurable,
PluginAware {
    public static final String QUESTION_PARAM_KEY = "question";
    protected JSONUtils _jsonUtils;
    protected FormElementDefinitionHelper _formElementDefinitionHelper;
    protected String _pluginName;
    protected String _id;
    protected I18nizableText _label;

    public void service(ServiceManager manager) throws ServiceException {
        this._jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
        this._formElementDefinitionHelper = (FormElementDefinitionHelper)((Object)manager.lookup(FormElementDefinitionHelper.ROLE));
    }

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._id = configuration.getAttribute("id");
        Configuration childLabel = configuration.getChild("label");
        this._label = I18nizableText.getI18nizableTextValue((Configuration)childLabel, (String)("plugin." + this._pluginName), (String)childLabel.getValue());
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public I18nizableText getLabel() {
        return this._label;
    }

    @Override
    public List<String> getFieldToDisableIfFormPublished() {
        return new ArrayList<String>();
    }

    @Override
    public String getStorageType(FormQuestion question) {
        return "string";
    }

    @Override
    public String getJSRenderer() {
        return "Ametys.plugins.forms.helper.SearchEntriesGridHelper.renderStringChoiceList";
    }

    @Override
    public String getJSConverter() {
        return null;
    }

    @Override
    public Object removeEmptyOrOtherValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            ArrayList<String> newVal = new ArrayList<String>();
            for (String val : (String[])value) {
                if (!StringUtils.isNotBlank((CharSequence)val) || val.equals("__internal_other")) continue;
                newVal.add(val);
            }
            if (newVal.isEmpty()) {
                return null;
            }
            return newVal.toArray(new String[newVal.size()]);
        }
        if (StringUtils.isNotBlank((CharSequence)((String)value)) && !value.equals("__internal_other")) {
            return value;
        }
        return null;
    }

    protected FormQuestion _getQuestionFromParam(Map<String, Object> params) {
        return (FormQuestion)((Object)params.get(QUESTION_PARAM_KEY));
    }

    @Override
    public Object valueToJSONForClient(Object value, FormQuestion question, FormEntry entry, ModelItem modelItem) throws Exception {
        return this._getComputedStringValue(value, question, entry);
    }

    protected Object _getComputedStringValue(Object valueToJSONForClient, FormQuestion question, FormEntry entry) throws Exception {
        String name = question.getNameForForm();
        ChoicesListQuestionType type = (ChoicesListQuestionType)question.getType();
        if (entry.isMultiple(name)) {
            String otherValue;
            ArrayList values = new ArrayList();
            if (valueToJSONForClient != null) {
                for (Object val : (List)valueToJSONForClient) {
                    HashMap<String, Object> transformedValue = new HashMap<String, Object>();
                    transformedValue.put("value", val);
                    HashMap<String, Object> enumParam = new HashMap<String, Object>();
                    enumParam.put(QUESTION_PARAM_KEY, (Object)question);
                    transformedValue.put("label", type.getSourceType(question).getEntry(new ChoiceOption(val), enumParam));
                    values.add(transformedValue);
                }
            }
            if (type.hasOtherOption(question) && StringUtils.isNotBlank((CharSequence)(otherValue = (String)entry.getValue("ametys-other-" + name)))) {
                HashMap<String, String> transformedValue = new HashMap<String, String>();
                transformedValue.put("value", otherValue);
                transformedValue.put("label", otherValue);
                values.add(transformedValue);
            }
            return values;
        }
        HashMap<String, Object> transformedValue = new HashMap<String, Object>();
        if (type.hasOtherOption(question) && StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue("ametys-other-" + name)))) {
            String otherValue = (String)entry.getValue("ametys-other-" + name);
            transformedValue.put("value", otherValue);
            transformedValue.put("label", otherValue);
        } else if (valueToJSONForClient != null) {
            transformedValue.put("value", valueToJSONForClient);
            HashMap<String, Object> enumParam = new HashMap<String, Object>();
            enumParam.put(QUESTION_PARAM_KEY, (Object)question);
            transformedValue.put("label", type.getSourceType(question).getEntry(new ChoiceOption(valueToJSONForClient), enumParam));
        }
        return transformedValue;
    }

    protected Object _getComputedComplexValue(Object valueToJSONForClient, FormQuestion question, FormEntry entry) throws Exception {
        String name = question.getNameForForm();
        ChoicesListQuestionType type = (ChoicesListQuestionType)question.getType();
        if (!type.hasOtherOption(question)) {
            return valueToJSONForClient;
        }
        if (entry.isMultiple(name)) {
            String otherValue = (String)entry.getValue("ametys-other-" + name);
            if (StringUtils.isNotBlank((CharSequence)otherValue)) {
                HashMap<String, Object> transformedValue = new HashMap<String, Object>();
                transformedValue.put("value", otherValue);
                transformedValue.put("isOther", true);
                ArrayList<HashMap<String, Object>> computedVal = new ArrayList<HashMap<String, Object>>();
                if (valueToJSONForClient != null) {
                    computedVal.addAll((List)valueToJSONForClient);
                }
                computedVal.add(transformedValue);
                return computedVal;
            }
        } else {
            String otherValue = (String)entry.getValue("ametys-other-" + name);
            if (StringUtils.isNotBlank((CharSequence)otherValue)) {
                HashMap<String, Object> transformedValue = new HashMap<String, Object>();
                transformedValue.put("value", otherValue);
                transformedValue.put("isOther", true);
                return transformedValue;
            }
        }
        return valueToJSONForClient;
    }

    @Override
    public String value2String(Object value) {
        return value.toString();
    }
}

