/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.repository;

import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.jcr.Node;
import org.ametys.cms.data.ametysobject.ModifiableModelAwareDataAwareAmetysObject;
import org.ametys.cms.data.holder.ModifiableIndexableDataHolder;
import org.ametys.cms.data.holder.impl.DefaultModifiableModelAwareDataHolder;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.StringUtils;
import org.ametys.plugins.forms.FormAndDirectoryCommonMethods;
import org.ametys.plugins.forms.dao.FormEntryDAO;
import org.ametys.plugins.forms.question.FormQuestionType;
import org.ametys.plugins.forms.question.types.impl.ChoicesListQuestionType;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.repository.FormFactory;
import org.ametys.plugins.forms.repository.FormPage;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.plugins.forms.repository.type.Rule;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.CopiableAmetysObject;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.MovableAmetysObject;
import org.ametys.plugins.repository.RepositoryIntegrityViolationException;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.JCRRepositoryData;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObject;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObjectFactory;
import org.ametys.plugins.repository.jcr.NameHelper;
import org.ametys.plugins.repository.jcr.SimpleAmetysObject;
import org.ametys.runtime.model.ModelItemContainer;
import org.ametys.web.repository.SiteAwareAmetysObject;
import org.ametys.web.repository.site.Site;

public class Form
extends DefaultTraversableAmetysObject<FormFactory>
implements ModifiableModelAwareDataAwareAmetysObject,
MovableAmetysObject,
SiteAwareAmetysObject,
CopiableAmetysObject {
    public static final String TITLE = "title";
    public static final String DESCRIPTION = "description";
    public static final String AUTHOR = "author";
    public static final String CONTRIBUTOR = "contributor";
    public static final String CREATIONDATE = "creationDate";
    public static final String LASTMODIFICATIONDATE = "lastModificationDate";
    public static final String WORKFLOWNAME = "workflowName";
    public static final String LIMIT_TO_ONE_ENTRY_BY_USER = "limit-to-one-entry-by-user";
    public static final String LIMIT_ENTRIES_ENABLED = "limit-entries-enabled";
    public static final String QUEUE_ENABLED = "queue-enabled";
    public static final String QUEUE_SIZE = "queue-size";
    public static final String QUEUE_CLOSED_MSG = "queue-closed-message";
    public static final String MAX_ENTRIES = "max-entries";
    public static final String REMAINING_MSG = "remaining-message";
    public static final String CLOSED_MSG = "closed-message";
    public static final String ADMIN_EMAILS = "admin-emails";
    public static final String ADMIN_EMAILS_OTHER = "admin-emails-other";
    public static final String ADMIN_EMAIL_LANGUAGE = "admin-emails-language";
    public static final String ADMIN_EMAIL_SUBJECT = "admin-email-subject";
    public static final String ADMIN_EMAIL_BODY = "admin-emails-body";
    public static final String RECEIPT_SENDER = "receipt-sender";
    public static final String RECEIPT_RECEIVER = "receipt-receiver";
    public static final String RECEIPT_SUBJECT = "receipt-subject";
    public static final String RECEIPT_BODY = "receipt-body";
    public static final String QUEUE_SENDER = "queue-sender";
    public static final String QUEUE_RECEIVER = "queue-receiver";
    public static final String QUEUE_SUBJECT = "queue-subject";
    public static final String QUEUE_BODY = "queue-body";
    public static final String START_DATE = "startDate";
    public static final String END_DATE = "endDate";
    public static final String EXPIRATION_ENABLED = "expirationEnabled";
    public static final String EXPIRATION_PERIOD = "expirationPeriod";
    public static final String EXPIRATION_POLICY = "expirationPolicy";

    public Form(Node node, String parentPath, FormFactory factory) {
        super(node, parentPath, (DefaultTraversableAmetysObjectFactory)factory);
    }

    public void setTitle(String title) {
        this.setValue(TITLE, title);
    }

    public void setDescription(String description) {
        this.setValue(DESCRIPTION, description);
    }

    public void setAuthor(UserIdentity author) {
        this.setValue(AUTHOR, author);
    }

    public void setContributor(UserIdentity contributor) {
        this.setValue(CONTRIBUTOR, contributor);
    }

    public void setCreationDate(ZonedDateTime creationDate) {
        this.setValue(CREATIONDATE, creationDate);
    }

    public void setLastModificationDate(ZonedDateTime lastModificationDate) {
        this.setValue(LASTMODIFICATIONDATE, lastModificationDate);
    }

    public String getTitle() {
        return (String)this.getValue(TITLE);
    }

    public String getDescription() {
        return (String)this.getValue(DESCRIPTION);
    }

    public UserIdentity getAuthor() {
        return (UserIdentity)this.getValue(AUTHOR);
    }

    public UserIdentity getContributor() {
        return (UserIdentity)this.getValue(CONTRIBUTOR);
    }

    public ZonedDateTime getCreationDate() {
        return (ZonedDateTime)this.getValue(CREATIONDATE);
    }

    public ZonedDateTime getLastModificationDate() {
        return (ZonedDateTime)this.getValue(LASTMODIFICATIONDATE);
    }

    public String getWorkflowName() {
        return (String)this.getValue(WORKFLOWNAME);
    }

    public void setWorkflowName(String workflowName) {
        this.setValue(WORKFLOWNAME, workflowName);
    }

    public Optional<String> getReceiptSender() {
        return Optional.ofNullable((String)this.getValue(RECEIPT_SENDER));
    }

    public void setReceiptSender(String sender) {
        this.setValue(RECEIPT_SENDER, sender);
    }

    public Optional<String> getReceiptReceiver() {
        return Optional.ofNullable((String)this.getValue(RECEIPT_RECEIVER));
    }

    public void setReceiptReceiver(String receiver) {
        this.setValue(RECEIPT_RECEIVER, receiver);
    }

    public Optional<String> getReceiptSubject() {
        return Optional.ofNullable((String)this.getValue(RECEIPT_SUBJECT));
    }

    public void setReceiptSubject(String subject) {
        this.setValue(RECEIPT_SUBJECT, subject);
    }

    public Optional<String> getReceiptBody() {
        return Optional.ofNullable((String)this.getValue(RECEIPT_BODY));
    }

    public void setReceiptBody(String body) {
        this.setValue(RECEIPT_BODY, body);
    }

    public boolean isMiniSurvey() {
        if (!this.isLimitedToOneEntryByUser()) {
            return false;
        }
        boolean hasAQuestion = false;
        for (FormQuestion question : this.getQuestions()) {
            FormQuestionType type = question.getType();
            if (type.onlyForDisplay(question)) continue;
            if (type instanceof ChoicesListQuestionType && !hasAQuestion) {
                hasAQuestion = true;
                continue;
            }
            return false;
        }
        return hasAQuestion;
    }

    public boolean isLimitedToOneEntryByUser() {
        return (Boolean)this.getValue(LIMIT_TO_ONE_ENTRY_BY_USER, false, false);
    }

    public void limitToOneEntryByUser(boolean limit) {
        this.setValue(LIMIT_TO_ONE_ENTRY_BY_USER, limit);
    }

    public boolean isEntriesLimited() {
        return (Boolean)this.getValue(LIMIT_ENTRIES_ENABLED, false, false);
    }

    public void limitEntries(boolean limitEntries) {
        this.setValue(LIMIT_ENTRIES_ENABLED, limitEntries);
    }

    public boolean isQueueEnabled() {
        return this.isEntriesLimited() && (Boolean)this.getValue(QUEUE_ENABLED, false, false) != false;
    }

    public void enableQueue(boolean enabled) {
        this.setValue(QUEUE_ENABLED, enabled);
    }

    public Optional<Long> getMaxEntries() {
        return Optional.ofNullable((Long)this.getValue(MAX_ENTRIES));
    }

    public void setMaxEntries(Long max) {
        this.setValue(MAX_ENTRIES, max);
    }

    public boolean isExpirationEnabled() {
        return (Boolean)this.getValue(EXPIRATION_ENABLED, false, false);
    }

    public void setExpirationPolicy(boolean enabled, long expirationPeriod, ExpirationPolicy policy) {
        this.setValue(EXPIRATION_ENABLED, enabled);
        if (expirationPeriod > 0L) {
            this.setValue(EXPIRATION_PERIOD, expirationPeriod);
        }
        if (policy != null) {
            this.setValue(EXPIRATION_POLICY, policy.name());
        }
    }

    public ExpirationPolicy getExpirationPolicy() {
        return ExpirationPolicy.valueOf((String)this.getValue(EXPIRATION_POLICY, false, ExpirationPolicy.DELETE.name()));
    }

    public long getExpirationPeriod() {
        return (Long)this.getValue(EXPIRATION_PERIOD, false, -1L);
    }

    public Optional<String> getRemainingMessage() {
        return Optional.ofNullable((String)this.getValue(REMAINING_MSG));
    }

    public void setRemainingMessage(String msg) {
        this.setValue(REMAINING_MSG, msg);
    }

    public Optional<String> getClosedMessage() {
        return Optional.ofNullable((String)this.getValue(CLOSED_MSG));
    }

    public void setClosedMessage(String msg) {
        this.setValue(CLOSED_MSG, msg);
    }

    public Optional<Long> getQueueSize() {
        return Optional.ofNullable((Long)this.getValue(QUEUE_SIZE));
    }

    public void setQueueSize(Long max) {
        this.setValue(QUEUE_SIZE, max);
    }

    public Optional<String> getClosedQueueMessage() {
        return Optional.ofNullable((String)this.getValue(QUEUE_CLOSED_MSG));
    }

    public void setClosedQueueMessage(String msg) {
        this.setValue(QUEUE_CLOSED_MSG, msg);
    }

    public Optional<String> getQueueMailSender() {
        return Optional.ofNullable((String)this.getValue(QUEUE_SENDER));
    }

    public void setQueueMailSender(String sender) {
        this.setValue(QUEUE_SENDER, sender);
    }

    public Optional<String> getQueueMailReceiver() {
        return Optional.ofNullable((String)this.getValue(QUEUE_RECEIVER));
    }

    public void setQueueMailtReceiver(String receiver) {
        this.setValue(QUEUE_RECEIVER, receiver);
    }

    public Optional<String> getQueueMailSubject() {
        return Optional.ofNullable((String)this.getValue(QUEUE_SUBJECT));
    }

    public void setQueueMailSubject(String subject) {
        this.setValue(QUEUE_SUBJECT, subject);
    }

    public Optional<String> getQueueMailBody() {
        return Optional.ofNullable((String)this.getValue(QUEUE_BODY));
    }

    public void setQueueMailBody(String body) {
        this.setValue(QUEUE_BODY, body);
    }

    public Optional<String[]> getAdminEmails() {
        return Optional.ofNullable((String[])this.getValue(ADMIN_EMAILS));
    }

    public void setAdminEmails(String[] emails) {
        this.setValue(ADMIN_EMAILS, emails);
    }

    public Optional<String> getOtherAdminEmails() {
        return Optional.ofNullable((String)this.getValue(ADMIN_EMAILS_OTHER));
    }

    public void setOtherAdminEmails(String emails) {
        this.setValue(ADMIN_EMAILS_OTHER, emails);
    }

    public Optional<String> getAdminEmailLanguage() {
        return Optional.ofNullable((String)this.getValue(ADMIN_EMAIL_LANGUAGE));
    }

    public void setAdminEmailLanguage(String language) {
        this.setValue(ADMIN_EMAIL_LANGUAGE, language);
    }

    public Optional<String> getAdminEmailBody() {
        return Optional.ofNullable((String)this.getValue(ADMIN_EMAIL_BODY));
    }

    public void setAdminEmailBody(String body) {
        this.setValue(ADMIN_EMAIL_BODY, body);
    }

    public Optional<String> getAdminEmailSubject() {
        return Optional.ofNullable((String)this.getValue(ADMIN_EMAIL_SUBJECT));
    }

    public void setAdminEmailSubject(String subject) {
        this.setValue(ADMIN_EMAIL_SUBJECT, subject);
    }

    public void setStartDate(LocalDate date) {
        this.setValue(START_DATE, date);
    }

    public LocalDate getStartDate() {
        return (LocalDate)this.getValue(START_DATE);
    }

    public void setEndDate(LocalDate date) {
        this.setValue(END_DATE, date);
    }

    public LocalDate getEndDate() {
        return (LocalDate)this.getValue(END_DATE);
    }

    public ModifiableIndexableDataHolder getDataHolder() {
        JCRRepositoryData repositoryData = new JCRRepositoryData(this.getNode());
        return new DefaultModifiableModelAwareDataHolder((ModifiableRepositoryData)repositoryData, (ModelItemContainer)((FormFactory)this._getFactory()).getModel());
    }

    public String getSiteName() throws AmetysRepositoryException {
        return this.getSite().getName();
    }

    public Site getSite() throws AmetysRepositoryException {
        AmetysObject parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof Site); parent = parent.getParent()) {
        }
        if (parent == null) {
            throw new AmetysRepositoryException("An error occurred with form with id '" + this.getId() + "'. Forms must always be linked to a site");
        }
        return (Site)parent;
    }

    public Form copyTo(ModifiableTraversableAmetysObject parent, String name) throws AmetysRepositoryException {
        Form form = (Form)parent.createChild(name, "ametys:form");
        form.setTitle(this.getTitle());
        for (FormPage page : this.getPages()) {
            page.copyTo((ModifiableTraversableAmetysObject)form, page.getName());
        }
        return form;
    }

    public AmetysObject copyTo(ModifiableTraversableAmetysObject parent, String name, List<String> restrictTo) throws AmetysRepositoryException {
        return this.copyTo(parent, name);
    }

    public List<FormPage> getPages() throws AmetysRepositoryException {
        return this.getChildren().stream().filter(child -> child instanceof FormPage).map(child -> (FormPage)((Object)child)).collect(Collectors.toList());
    }

    public boolean hasEntries() {
        return !this.getEntries().isEmpty();
    }

    public List<FormEntry> getEntries() throws AmetysRepositoryException {
        FormEntryDAO formEntryDAO = ((FormFactory)this._getFactory()).getFormEntryDAO();
        return formEntryDAO.getFormEntries(this, false, List.of());
    }

    public List<FormEntry> getActiveEntries() throws AmetysRepositoryException {
        FormEntryDAO formEntryDAO = ((FormFactory)this._getFactory()).getFormEntryDAO();
        return formEntryDAO.getFormEntries(this, true, List.of());
    }

    public FormQuestion getQuestion(String name) throws AmetysRepositoryException {
        return this.getQuestions().stream().filter(q -> q.getNameForForm().equals(name)).findFirst().orElse(null);
    }

    public List<FormQuestion> getQuestions() throws AmetysRepositoryException {
        return this.getPages().stream().map(FormPage::getQuestions).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public boolean isQuestionNameUnique(String uniqueName) {
        return !this.getQuestionsNames().contains(uniqueName);
    }

    public String findUniqueQuestionName(String originalName) {
        String filterName = NameHelper.filterName((String)originalName);
        Object name = filterName;
        List<String> questionNames = this.getQuestionsNames();
        while (questionNames.contains(name)) {
            name = filterName + "-" + StringUtils.generateKey().toLowerCase();
        }
        return name;
    }

    public List<String> getQuestionsNames() {
        return this.getQuestions().stream().map(FormQuestion::getNameForForm).toList();
    }

    public String findUniqueQuestionTitle(String originalTitle) {
        Object title = originalTitle;
        int index = 1;
        List<String> questionTitles = this.getQuestions().stream().map(FormQuestion::getTitle).toList();
        while (questionTitles.contains(title)) {
            title = originalTitle + " " + index++;
        }
        return title;
    }

    public Map<FormQuestion, Rule> getQuestionsRule(String sourceQuestionId) {
        HashMap<FormQuestion, Rule> questionsRule = new HashMap<FormQuestion, Rule>();
        for (FormQuestion question : this.getQuestions()) {
            Optional<Rule> questionRule = question.getFirstQuestionRule();
            if (!questionRule.map(q -> q.getSourceId().equals(sourceQuestionId)).orElse(false).booleanValue()) continue;
            questionsRule.put(question, questionRule.get());
        }
        return questionsRule;
    }

    public void deleteQuestionsRule(String sourceQuestionId) {
        for (FormQuestion question : this.getQuestions()) {
            Optional<Rule> questionRule = question.getFirstQuestionRule();
            if (!questionRule.map(q -> q.getSourceId().equals(sourceQuestionId)).orElse(false).booleanValue()) continue;
            question.getRepeater("rules").removeEntry(0);
        }
        this.saveChanges();
    }

    public boolean hasWorkflow() {
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.getWorkflowName());
    }

    public boolean canMoveTo(AmetysObject newParent) throws AmetysRepositoryException {
        return FormAndDirectoryCommonMethods.canMoveTo(this.getSiteName(), newParent, (SimpleAmetysObject)this, ((FormFactory)this._getFactory()).getFormDirectoriesDAO());
    }

    public void moveTo(AmetysObject newParent, boolean renameIfExist) throws AmetysRepositoryException, RepositoryIntegrityViolationException {
        FormAndDirectoryCommonMethods.moveTo(newParent, renameIfExist, (SimpleAmetysObject)this);
    }

    public void orderBefore(AmetysObject siblingNode) throws AmetysRepositoryException {
        FormAndDirectoryCommonMethods.orderBefore(siblingNode, (SimpleAmetysObject)this);
    }

    public boolean isCacheable() {
        if (this.getQuestions().isEmpty() || this.getQuestions().stream().anyMatch(q -> !q.getType().isQuestionConfigured((FormQuestion)((Object)q)))) {
            return true;
        }
        if (this.isEntriesLimited() || this.isLimitedToOneEntryByUser() || this.getStartDate() != null || this.getEndDate() != null) {
            return false;
        }
        return this.getQuestions().stream().allMatch(FormQuestion::isCacheable);
    }

    public static enum ExpirationPolicy {
        DELETE,
        ANONYMIZE;

    }

    public static enum FormProfile {
        READ_ACCESS,
        WRITE_ACCESS,
        RIGHT_ACCESS;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

