/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.repository.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.ametys.core.model.type.AbstractElementType;
import org.ametys.plugins.forms.repository.type.Rule;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.data.repositorydata.RepositoryData;
import org.ametys.plugins.repository.data.type.RepositoryElementType;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.type.DataContext;
import org.apache.commons.lang3.StringUtils;

public class RuleElementType
extends AbstractElementType<Rule>
implements RepositoryElementType<Rule> {
    public static final String RULE_DATA_TYPE = "rule";

    public String getRepositoryDataType() {
        return "string";
    }

    public Rule convertValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this._string2Rule((String)value);
        }
        throw new BadItemTypeException("Try to convert the non " + this.getId() + " JSON object '" + String.valueOf(value) + "' into a " + this.getId());
    }

    public String toString(Rule value) {
        return this._jsonUtils.convertObjectToJson(value.toJson());
    }

    public Object fromJSONForClient(Object json, DataContext context) {
        if (json instanceof List) {
            ArrayList<Rule> ruleList = new ArrayList<Rule>();
            for (Object rule : (List)json) {
                ruleList.add(this.convertValue(rule));
            }
            return ruleList.toArray(new Rule[ruleList.size()]);
        }
        if (json instanceof Rule[]) {
            ArrayList<Rule> ruleList = new ArrayList<Rule>();
            for (Rule rule : (Rule[])json) {
                ruleList.add(this.convertValue(rule));
            }
            return ruleList.toArray(new Rule[ruleList.size()]);
        }
        return this.convertValue(json);
    }

    public boolean isSimple() {
        return false;
    }

    public boolean isCompatible(Object value) {
        return super.isCompatible(value) || value instanceof String || value instanceof String[] || value instanceof Rule || value instanceof Rule[];
    }

    protected Rule _string2Rule(String value) {
        Map castMap = this._jsonUtils.convertJsonToMap(value);
        return new Rule((String)castMap.get("question"), (String)castMap.get("option"), Rule.QuestionRuleType.valueOf((String)castMap.get("action")));
    }

    public Object read(RepositoryData parentData, String name) throws BadItemTypeException {
        if (!parentData.hasValue(name)) {
            return null;
        }
        if (!this.isCompatible(parentData, name)) {
            throw new BadItemTypeException("Try to get " + this.getId() + " value from the non " + this.getId() + " data '" + name + "' on '" + String.valueOf(parentData) + "'");
        }
        if (parentData.isMultiple(name)) {
            String[] values = parentData.getStrings(name);
            return Arrays.stream(values).map(this::_string2Rule).toArray(Rule[]::new);
        }
        String value = parentData.getString(name);
        return this._string2Rule(value);
    }

    public boolean hasNonEmptyValue(RepositoryData parentData, String name) throws BadItemTypeException {
        if (!parentData.hasValue(name)) {
            return false;
        }
        if (!this.isCompatible(parentData, name)) {
            throw new BadItemTypeException("Try to check rule value from the non " + this.getId() + " data '" + name + "' on '" + String.valueOf(parentData) + "'");
        }
        if (parentData.isMultiple(name)) {
            return parentData.getStrings(name).length > 0;
        }
        return StringUtils.isNotEmpty((CharSequence)parentData.getString(name));
    }

    public void write(ModifiableRepositoryData parentData, String name, Object value) throws BadItemTypeException {
        if (value == null) {
            if (parentData.hasValue(name) && parentData.isMultiple(name)) {
                parentData.setValues(name, new String[0]);
            } else {
                parentData.setValue(name, "");
            }
        } else if (value instanceof String) {
            parentData.setValue(name, (String)value);
        } else if (value instanceof String[]) {
            Arrays.stream((String[])value).forEach(v -> Optional.ofNullable(v).orElseThrow(() -> new IllegalArgumentException("Try to set a null value into the multiple " + this.getId() + " data '" + name + "' on '" + String.valueOf(parentData) + "'")));
            parentData.setValues(name, (String[])value);
        } else if (value instanceof Rule) {
            Rule rule = (Rule)value;
            parentData.setValue(name, this._jsonUtils.convertObjectToJson(rule.toJson()));
        } else if (value instanceof Rule[]) {
            String[] values = (String[])Stream.of((Rule[])value).map(r -> this._jsonUtils.convertObjectToJson(r.toJson())).toArray(String[]::new);
            parentData.setValues(name, values);
        } else if (value instanceof List) {
            List ruleList = (List)value;
            String[] ruleListAsJson = (String[])ruleList.stream().map(r -> this._jsonUtils.convertObjectToJson(r.toJson())).toArray(String[]::new);
            parentData.setValues(name, ruleListAsJson);
        } else {
            throw new BadItemTypeException("Try to set the non " + this.getId() + " value '" + String.valueOf(value) + "' to the " + this.getId() + " data '" + name + "' on '" + String.valueOf(parentData) + "'");
        }
    }
}

