/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

const NameHelper = Java.type('org.ametys.plugins.repository.jcr.NameHelper');

const I18nUtils = Java.type('org.ametys.core.util.I18nUtils');
const i18nUtilsComponent = Ametys.serviceManager.lookup(I18nUtils.ROLE);
  
const FormDAO = Java.type('org.ametys.plugins.forms.dao.FormDAO');
const FormDAOComponent = Ametys.serviceManager.lookup(FormDAO.ROLE);
  
const I18nizableText = Java.type("org.ametys.runtime.i18n.I18nizableText");
const List = Java.type("java.util.List");

/** Migration subject and body for forms admin emails in default session */
logger.info("Start migration of forms admin emails for default session");
updateAdminEmails(Repository.session);
  
/** Migration subject and body forms admin emails in live session */
logger.info("Start migration of forms admin emails for live session");
updateAdminEmails(Repository.liveSession);
  
function updateAdminEmails(session)
{
    let count = 0;
    Repository.query("//element(*, ametys:form)[@ametys:admin-emails != '']", true, session).forEach(function(form) {
      if (form.getAdminEmailSubject().isEmpty())
      {
        logger.info(form.getTitle());
        let language = FormDAOComponent.getFormLocale(form);
        form.setValue(
          "admin-email-subject", 
          i18nUtilsComponent.translate(
            new I18nizableText(
              "plugin.forms", 
              "PLUGINS_FORMS_ADMIN_EMAILS_SUBJECT_DEFAULT_ANONYMOUS"
            ),
            language
          )
        );
        form.setValue(
          "admin-emails-body", 
          i18nUtilsComponent.translate(
            new I18nizableText(
              "plugin.forms",
              "PLUGINS_FORMS_ADMIN_EMAILS_BODY_DEFAULT_ANONYMOUS"
            ),
            language
          )
        );
        count++;
      }
    });
 
    if (count > 0)
    {
        session.save(); 
    }
    logger.info(`${count} forms node(s) have be updated in workspaces ${session.getWorkspace().getName()}`);
}  
