/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

function callURL(formId, formDomId, limit, prefix)
{
    if(limit == "")
    {
        return;
    }
    $j.ajax({
        url: prefix + 'forms/get-submissions-action',
        method: 'POST',
        data: {
            formId: formId
        },
        cache: false,
        dataType: 'json',
        success: function(data) {
            var form =  $j("#" + formDomId);
            if (limit == "" || data.submissions < limit)
            {
                form.attr("data-ametys-form-state", "open")
            }
            else
            {
                form.attr("data-ametys-form-state", "closed")
            }
            replaceValues(form.find('*[data-ametys-form-fill ="closed-text"]'), limit, data.submissions)
            replaceValues(form.find('*[data-ametys-form-fill ="limit-text"]'), limit, data.submissions)
        },
        error: function() {
            var form =  $j("#" + formDomId);
            form.attr("data-ametys-form-state", "error")
        },
    });
}

function replaceValues(node, limit, submissions)
{
    if (node && node.length)
    {
        messageToDisplay = node.html().replace(/{remaining}/g, limit - submissions)
        messageToDisplay = messageToDisplay.replace(/{submissions}/g, submissions)
        messageToDisplay = messageToDisplay.replace(/{limit}/g, limit)
        return node.html(messageToDisplay);
    }
}

function checkForm(formId, formDomId, errorCheck)
{
    var form =  $j("#" + formDomId);
    var dataState = form.attr("data-ametys-form-state")
    if (dataState == "closed" || dataState == "loading" || dataState == "error")
    {
        return false;
    }
    var errors = 0;
    var ERROR_CLASSNAME = "form-error";
    var ERROR_CLASSNAME2 = "invalid";

    function reset(id, type)
    {
        var input = $j("#" + id);
        var divinput = $j(input.parents(".input")[0]); 
        var label = $j("#" + id + "_label"); 

        divinput.removeClass(ERROR_CLASSNAME2);

        input.removeClass(ERROR_CLASSNAME + " " + ERROR_CLASSNAME + "-" + type);
        input.prop('title', '');
        
        label.removeClass(ERROR_CLASSNAME);
        label.prop('title', '');
    }
    
    function error(id, type, message)
    {
        var input = $j("#" + id);
        var divinput = $j(input.parents(".input")[0]); 
        var label = $j("#" + id + "_label"); 

        divinput.addClass(ERROR_CLASSNAME2);

        var currentMessage = input.prop('title');
        currentMessage = currentMessage == null || currentMessage == "" ? message : currentMessage + " - " + message;

        var currentLabelMessage = label.prop('title');
        currentLabelMessage = currentLabelMessage == null || currentLabelMessage == "" ? message : currentLabelMessage + " - " + message;
        
        input.addClass(ERROR_CLASSNAME + " " + ERROR_CLASSNAME + "-" + type);
        input.prop('title', currentMessage);
        
        label.addClass(ERROR_CLASSNAME);
        label.prop('title', currentLabelMessage);

        errors++;
    }
    
    errorCheck(reset, error);
    
    if (errors != 0)
    {
        alert("{{i18n plugin.forms:PLUGINS_FORMS_FORMS_RENDER_ERRORS_1}}" + errors + "{{i18n plugin.forms:PLUGINS_FORMS_FORMS_RENDER_ERRORS_2}}");
    }
    return errors == 0;
}

function computeFormCost(element)
{
    var cost = 0.0;
    
    var form = $j(element).parents("form").first();
    form.find("select[data-partofcost='true'] option:selected").each(function(index, option) {
        var c = parseFloat(($j(option).attr("data-cost") || "0").trim())
        if (!isNaN(c))
        {
            cost += c;
        }
    });
    
    form.find("input[data-unit]").each(function(index, input) {
        input.value = cost.toLocaleString($j(input).attr("data-lang"), {style: 'currency', currency: $j(input).attr("data-unit")});
    });
}
