<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                exclude-result-prefixes="i18n resolver">
    
    <xsl:import href="view:forms://stylesheets/forms/helper/entry-information.xsl"/>
    
    <xsl:template match="/*">
        <div class="bloc">
            <h1><i18n:text i18n:catalogue="plugin.forms" i18n:key="UITOOL_DETAILS_FORM_ENTRY_DATA"/></h1>
            <xsl:apply-templates select="field"/>
        </div>
    </xsl:template>
    
    <xsl:template match="field">
        <p>
            <strong><xsl:apply-templates select="." mode="display-label"/></strong><br/>
            <xsl:apply-templates select="." mode="display-value"/>
        </p>
    </xsl:template>
    
    <xsl:template match="field" mode="display-label">
        <xsl:value-of select="@label"/>
    </xsl:template>

    <xsl:template match="field" mode="display-value">
        <xsl:choose>
            <xsl:when test="value">
                <xsl:apply-templates select="." mode="value"/>
            </xsl:when>
            <xsl:otherwise>
                <i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_ENTRY_EMPTY_VALUE" i18n:catalogue="plugin.forms"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="field[@typeId='form.ChoicesList']" mode="display-value">
        <xsl:choose>
            <xsl:when test="additional-infos/values/value">
                <xsl:apply-templates select="." mode="value"/>    
            </xsl:when>
            <xsl:otherwise>
                <i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_ENTRY_EMPTY_VALUE" i18n:catalogue="plugin.forms"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="field[@typeId='form.Computed' and additional-infos/@computed-type = 'computing.CurrentPageId']" mode="value">
        <a href="{resolver:resolve('page', additional-infos/page/id)}"><xsl:value-of select="additional-infos/page/title"/></a>
    </xsl:template>
</xsl:stylesheet>