/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.generators;

import java.util.List;
import java.util.Map;
import java.util.Optional;

import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;

import org.ametys.plugins.forms.dao.FormQuestionDAO.FormEntryValues;
import org.ametys.plugins.forms.helper.FormMailHelper;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.repository.FormQuestion;


/**
 * Generate the entry of a form for a mail
 */
public class FormMailEntryInformationGenerator extends FormEntryInformationGenerator
{
    @Override
    protected void _checkRights(FormEntry entry)
    {
        Request request = ObjectModelHelper.getRequest(objectModel);
        Boolean ignoreRight = (Boolean) request.getAttribute(FormMailHelper.IGNORE_RIGHT_KEY);
        
        if (ignoreRight == null || !ignoreRight)
        {
            super._checkRights(entry);
        }
    }
    
    @Override
    protected List<FormQuestion> _getQuestions(FormEntry entry, Optional<Long> currentStepId)
    {
        return _formQuestionDAO.getRuleFilteredQuestions(entry.getForm(), new FormEntryValues(null, entry), currentStepId, false, _onlyReadableQuestion());
    }
    
    @SuppressWarnings("unchecked")
    private boolean _onlyReadableQuestion()
    {
        Map<String, Object> params = (Map<String, Object>) objectModel.get(ObjectModelHelper.PARENT_CONTEXT);
        return (boolean) params.getOrDefault(FormMailHelper.READ_RESTRICTION_ENABLE, false);
    }
}
