/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.content.data;

import java.util.Map;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.forms.FormsException;
import org.ametys.plugins.forms.content.Form;
import org.ametys.plugins.forms.content.jcr.FormPropertiesManager;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class SetHttpHeaderForExport
extends ServiceableAction {
    private FormPropertiesManager _formPropertiesManager;

    public void service(ServiceManager smanager) throws ServiceException {
        this._formPropertiesManager = (FormPropertiesManager)((Object)smanager.lookup(FormPropertiesManager.ROLE));
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        String siteName = parameters.getParameter("site", "");
        String formId = parameters.getParameter("id", "");
        if (StringUtils.isEmpty((CharSequence)siteName) || StringUtils.isEmpty((CharSequence)formId)) {
            throw new ProcessingException("The site name and form ID must be provided.");
        }
        try {
            Form form = this._formPropertiesManager.getForm(siteName, formId);
            if (form == null) {
                throw new ProcessingException("The form of ID '" + formId + " can't be found in the site '" + siteName + "'.");
            }
            String fileName = URIUtils.decode((String)form.getLabel());
            String encodedName = URIUtils.encodeHeader((String)fileName);
            Response response = ObjectModelHelper.getResponse((Map)objectModel);
            response.setHeader("Content-Disposition", "attachment; filename=\"" + encodedName + ".xls\";filename*=UTF-8''" + encodedName + ".xls");
        }
        catch (FormsException e) {
            this.getLogger().error("Unable to get form with id " + formId, (Throwable)e);
        }
        return EMPTY_MAP;
    }
}

