/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a open tool ribbon button that is able to check for conditions on
 * the rights of a Form Entry.
 * @private
 */
Ext.define('Ametys.plugins.forms.controllers.OpenFormEntryToolController', {
    extend: 'Ametys.ribbon.element.ui.button.OpenToolButtonController',
    
    
    areSameTargets: function (target1, target2)
	{
        if (!this.callParent(arguments))
        {
            return false;
        }
        
		var subtargets1 = target1.getSubtargets(),
		    subtargets2 = target2.getSubtargets();
		
		return this._areSameTargetsArray(subtargets1, subtargets2, 1);
	}
    
});
