<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper" 
    exclude-result-prefixes="ametys">

    <xsl:variable name="date-format" select="ametys:translate('plugin.forms:PLUGINS_FORMS_SERVICE_DASHBOARD_DATE_FORMAT', ametys:lang())"></xsl:variable>
    <xsl:variable name="date-time-format" select="ametys:translate('plugin.forms:PLUGINS_FORMS_SERVICE_DASHBOARD_DATE_TIME_FORMAT', ametys:lang())"></xsl:variable>

    <xsl:template match="question[@type = 'form.DateTime']" mode="question-attribute-class">
        <xsl:attribute name="class">question question-date</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.DateTime']" mode="field-attribute-class">
        <xsl:attribute name="class">field field-date</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.DateTime']" mode="input-attribute-class">
        <xsl:attribute name="class">input input-date</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.DateTime' and date-format/@value = 'date']" mode="read-only-value">
        <xsl:param name="value" />
        
        <i18n:date src-pattern="yyyy-MM-dd" pattern="{$date-format}" value="{$value}"/>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.DateTime' and date-format/@value = 'datetime']" mode="read-only-value">
        <xsl:param name="value" />
        
        <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$date-time-format}" value="{$value}"/>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.DateTime' and @format = 'date']" mode="render-mail">
        <xsl:if test="value != ''">
            <i18n:date src-pattern="yyyy-MM-dd" pattern="{$date-format}" value="{value}"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.DateTime' and @format = 'datetime']" mode="render-mail">
        <xsl:if test="value != ''">
            <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$date-time-format}" value="{value}"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.DateTime' and date-format/@value = 'date']" mode="input">
        <input name="{@name}" id="{@name}_{$uniqueId}" type="date" class="datetime" onchange="onDateChangeFunction_{translate(@name, '-', '_')}_{$uniqueId}()">
            <xsl:if test="mandatory = 'true'">
                <xsl:attribute name="aria-required">true</xsl:attribute>
            </xsl:if>
        </input>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.DateTime' and date-format/@value = 'date']" mode="display-fn">
        <xsl:if test="entry-value/value">
            function dateToIsoString(date) {
                pad = function(num) {
                    return (num &lt; 10 ? '0' : '') + num;
                };

                return date.getFullYear() +
                    '-' + pad(date.getMonth() + 1) +
                    '-' + pad(date.getDate());
            }
            
            var val = "<xsl:value-of select="entry-value/value"/>";
            $j('#<xsl:value-of select="@name"/>_<xsl:value-of select="$uniqueId"/>').val(dateToIsoString(new Date(val)));
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.DateTime' and date-format/@value = 'datetime']" mode="input">
        <input name="{@name}-widget" id="{@name}_{$uniqueId}" type="datetime-local" class="datetime" onchange="onDateChangeFunction_{translate(@name, '-', '_')}_{$uniqueId}()">
            <xsl:if test="mandatory = 'true'">
                <xsl:attribute name="aria-required">true</xsl:attribute>
            </xsl:if>
        </input>
        <input type="hidden" id="{@name}_{$uniqueId}_hidden" name="{@name}" />
    </xsl:template> 
    
    <xsl:template match="question[@type = 'form.DateTime' and date-format/@value = 'datetime']" mode="display-fn">
        <xsl:if test="entry-value/value">
            function dateTimeToIsoString(date) {
                pad = function(num) {
                    return (num &lt; 10 ? '0' : '') + num;
                };

                return date.getFullYear() +
                    '-' + pad(date.getMonth() + 1) +
                    '-' + pad(date.getDate()) +
                    'T' + pad(date.getHours()) +
                    ':' + pad(date.getMinutes()) +
                    ':' + pad(date.getSeconds());
            }
        
            var val = "<xsl:value-of select="entry-value/value"/>";
            $j('#<xsl:value-of select="@name"/>_<xsl:value-of select="$uniqueId"/>_hidden').val(val);
            $j('#<xsl:value-of select="@name"/>_<xsl:value-of select="$uniqueId"/>').val(dateTimeToIsoString(new Date(val)));
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.DateTime']" mode="check-values">
        var value = $j('#<xsl:value-of select="@name"/>_<xsl:value-of select="$uniqueId"/>').val();
        
        <xsl:call-template name="test-min-date" >
            <xsl:with-param name="min" select="min-date" />
        </xsl:call-template> 
        <xsl:call-template name="test-min-date" >
            <xsl:with-param name="min" select="min-datetime" />
        </xsl:call-template> 
        <xsl:call-template name="test-max-date" >
            <xsl:with-param name="max" select="max-datetime" />
        </xsl:call-template> 
        <xsl:call-template name="test-max-date" >
            <xsl:with-param name="max" select="max-date" />
        </xsl:call-template> 
    </xsl:template>
    
    <xsl:template name="test-min-date">
       <xsl:param name="min"/>
       <xsl:if test="$min">
            var minDateFormated = (new Date("<xsl:value-of select="$min"/>")).toLocaleString();
            var msg = "<i18n:translate>
                            <i18n:text i18n:key="PLUGINS_FORMS_PAGE_FORM_ERROR_MIN"/>
                            <i18n:param name="min">" + minDateFormated + "</i18n:param>
                       </i18n:translate>";
            if (Date.parse(value) &lt; Date.parse('<xsl:value-of select="$min"/>'))
            {
                AmetysFormsHelper.addFormError('<xsl:value-of select="$uniqueId"/>', '<xsl:value-of select="@name"/>_<xsl:value-of select="$uniqueId"/>', '<xsl:value-of select="ametys:escapeJS(title)"/>', msg);
            }
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="test-max-date">
       <xsl:param name="max"/>
       <xsl:if test="$max">
            var maxDateFormated = (new Date("<xsl:value-of select="$max"/>")).toLocaleString();
            var msg = "<i18n:translate>
                            <i18n:text i18n:key="PLUGINS_FORMS_PAGE_FORM_ERROR_MAX"/>
                            <i18n:param name="max">" + maxDateFormated + "</i18n:param>
                       </i18n:translate>";
            if (Date.parse(value) &gt; Date.parse('<xsl:value-of select="$max"/>'))
            {
                AmetysFormsHelper.addFormError('<xsl:value-of select="$uniqueId"/>', '<xsl:value-of select="@name"/>_<xsl:value-of select="$uniqueId"/>', '<xsl:value-of select="ametys:escapeJS(title)"/>', msg);
            }
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.DateTime']" mode="init-rules">
        $j( document ).ready(function() {
            onDateChangeFunction_<xsl:value-of select="translate(@name, '-', '_')" />_<xsl:value-of select="$uniqueId" />()
        });
        
        function onDateChangeFunction_<xsl:value-of select="translate(@name, '-', '_')" />_<xsl:value-of select="$uniqueId" />() {
            <xsl:if test="date-format/@value = 'datetime'">
                var date = $j('#<xsl:value-of select="@name"/>_<xsl:value-of select="$uniqueId"/>').val();
                let isoDateTime = date ? new Date(date).toISOString() : "";
                $j('#<xsl:value-of select="@name"/>_<xsl:value-of select="$uniqueId"/>_hidden').val(isoDateTime);
            </xsl:if>
        
            FormListenersHelper.executeListenerForInputs("<xsl:value-of select="$uniqueId" />", "<xsl:value-of select="../@number" />");
        }
    </xsl:template>
</xsl:stylesheet>