/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.content.processing;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.SAXException;

import org.ametys.plugins.forms.content.Field;
import org.ametys.plugins.forms.content.Form;
import org.ametys.runtime.i18n.I18nizableText;

/**
 * Action that processes the user submitted data on a form.
 */
public class FormErrorsGenerator extends AbstractGenerator
{

    @Override
    public void generate() throws IOException, SAXException, ProcessingException
    {
        Request request = ObjectModelHelper.getRequest(objectModel);
        
        FormErrors errors = (FormErrors) request.getAttribute("form-errors");
        Form form = errors.getForm();
        
        Map<String, Field> fields = form.getFieldMap();
        
        Map<String, List<I18nizableText>> errorMap = errors.getErrors();
        
        contentHandler.startDocument();
        
        AttributesImpl atts = new AttributesImpl();
        atts.addCDATAAttribute("id", form.getId());
        atts.addCDATAAttribute("label", form.getLabel());
        atts.addCDATAAttribute("insertionFailed", String.valueOf(errors.hasInsertionFailed()));
        atts.addCDATAAttribute("limitReached", String.valueOf(errors.hasLimitReached()));
//        atts.addCDATAAttribute("contentId", form.getContentId());
        
        XMLUtils.startElement(contentHandler, "form-errors", atts);
        
        for (Map.Entry<String, List<I18nizableText>> fieldErrors : errorMap.entrySet())
        {
            String fieldId = fieldErrors.getKey();
            Field field = fields.get(fieldId);
            List<I18nizableText> messages = fieldErrors.getValue();
            
            atts.clear();
            atts.addCDATAAttribute("id", fieldId);
            atts.addCDATAAttribute("name", field.getName());
            atts.addCDATAAttribute("label", field.getLabel());
            atts.addCDATAAttribute("type", field.getType().toString());
            
            XMLUtils.startElement(contentHandler, "field", atts);
            
            for (I18nizableText message : messages)
            {
                message.toSAX(contentHandler, "error");
            }
            
            XMLUtils.endElement(contentHandler, "field");
        }
        
        XMLUtils.endElement(contentHandler, "form-errors");
        
        contentHandler.endDocument();
    }

}
