/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.content.workflow;

import com.opensymphony.workflow.Workflow;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.jcr.Node;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.forms.FormsException;
import org.ametys.plugins.forms.content.Form;
import org.ametys.plugins.forms.content.jcr.FormPropertiesManager;
import org.ametys.plugins.forms.content.table.FormTableManager;
import org.ametys.plugins.forms.data.Answer;
import org.ametys.plugins.forms.workflow.AbstractFormDashboardGenerator;
import org.ametys.plugins.workflow.store.JdbcWorkflowStore;
import org.ametys.plugins.workflow.support.WorkflowProvider;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.Request;

public class FormDashboardGenerator
extends AbstractFormDashboardGenerator {
    protected FormTableManager _formTableManager;
    protected FormPropertiesManager _formPropertiesManager;
    protected WorkflowProvider _workflowProvider;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._formTableManager = (FormTableManager)((Object)smanager.lookup(FormTableManager.ROLE));
        this._formPropertiesManager = (FormPropertiesManager)((Object)smanager.lookup(FormPropertiesManager.ROLE));
        this._workflowProvider = (WorkflowProvider)smanager.lookup(WorkflowProvider.ROLE);
    }

    @Override
    protected List<Answer> _getAnswers(Request request, String siteName, String lang, UserIdentity user) throws FormsException {
        List<Form> forms = this._formPropertiesManager.getFormContentNodes(siteName, lang).stream().map(this::_getForms).flatMap(Collection::stream).collect(Collectors.toList());
        return this._formTableManager.getUserAnwsers(forms, user);
    }

    @Override
    protected Workflow _getWorkflow(Answer answer) {
        return this._workflowProvider.getExternalWorkflow(JdbcWorkflowStore.ROLE);
    }

    private List<Form> _getForms(Node node) {
        try {
            return this._formPropertiesManager.getForms(node);
        }
        catch (Exception e) {
            this.getLogger().error("Can get forms from content node", (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }
}

