/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.forms.dao.FormDAO;
import org.ametys.plugins.forms.dao.FormQuestionDAO;
import org.ametys.plugins.forms.question.FormQuestionType;
import org.ametys.plugins.forms.question.types.impl.ChoicesListQuestionType;
import org.ametys.plugins.forms.repository.CopyFormUpdater;
import org.ametys.plugins.forms.repository.CopyFormUpdaterExtensionPoint;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormPage;
import org.ametys.plugins.forms.repository.FormPageRule;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.TraversableAmetysObject;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObject;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.jcr.NameHelper;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.jackrabbit.util.Text;

public class FormPageDAO
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = FormPageDAO.class.getName();
    protected ObservationManager _observationManager;
    protected AmetysObjectResolver _resolver;
    protected CurrentUserProvider _currentUserProvider;
    protected FormQuestionDAO _formQuestionDAO;
    protected I18nUtils _i18nUtils;
    protected FormDAO _formDAO;
    protected RightManager _rightManager;
    protected CopyFormUpdaterExtensionPoint _copyFormEP;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._observationManager = (ObservationManager)manager.lookup(ObservationManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._formQuestionDAO = (FormQuestionDAO)((Object)manager.lookup(FormQuestionDAO.ROLE));
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._formDAO = (FormDAO)((Object)manager.lookup(FormDAO.ROLE));
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._copyFormEP = (CopyFormUpdaterExtensionPoint)((Object)manager.lookup(CopyFormUpdaterExtensionPoint.ROLE));
    }

    @Callable(rights={""})
    public Map<String, String> createPage(String parentId, String name) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        Form rootNode = (Form)this._resolver.resolveById(parentId);
        this._formDAO.checkHandleFormRight((AmetysObject)rootNode);
        String uniqueName = NameHelper.getUniqueAmetysObjectName((TraversableAmetysObject)rootNode, (String)name);
        FormPage page = (FormPage)rootNode.createChild(uniqueName, "ametys:form-page");
        page.setTitle(uniqueName);
        rootNode.saveChanges();
        HashMap<String, Form> eventParams = new HashMap<String, Form>();
        eventParams.put("form", rootNode);
        this._observationManager.notify(new Event("form.modified", this._getCurrentUser(), eventParams));
        result.put("id", page.getId());
        result.put("name", page.getTitle());
        return result;
    }

    @Callable(rights={""})
    public Map<String, String> renamePage(String id, String newName) {
        HashMap<String, String> results = new HashMap<String, String>();
        FormPage page = (FormPage)this._resolver.resolveById(id);
        this._formDAO.checkHandleFormRight((AmetysObject)page);
        String legalName = Text.escapeIllegalJcrChars((String)newName);
        Node node = page.getNode();
        try {
            page.setTitle(newName);
            node.getSession().move(node.getPath(), node.getParent().getPath() + "/" + legalName);
            node.getSession().save();
            HashMap<String, Form> eventParams = new HashMap<String, Form>();
            eventParams.put("form", page.getForm());
            this._observationManager.notify(new Event("form.modified", this._getCurrentUser(), eventParams));
            results.put("id", id);
            results.put("newName", legalName);
            results.put("formId", page.getForm().getId());
        }
        catch (RepositoryException e) {
            this.getLogger().error("Form renaming failed.", (Throwable)e);
            results.put("message", "cannot-rename");
        }
        return results;
    }

    @Callable(rights={""})
    public Map<String, String> deletePage(String id) {
        HashMap<String, String> result = new HashMap<String, String>();
        FormPage page = (FormPage)this._resolver.resolveById(id);
        this._formDAO.checkHandleFormRight((AmetysObject)page);
        Form parent = page.getForm();
        this._removeReferencesFromQuestionsRules(page, parent);
        page.remove();
        this._removeReferencesFromPages(id, parent);
        this._removeReferencesFromQuestions(id, parent);
        parent.saveChanges();
        HashMap<String, Form> eventParams = new HashMap<String, Form>();
        eventParams.put("form", parent);
        this._observationManager.notify(new Event("form.modified", this._getCurrentUser(), eventParams));
        result.put("id", id);
        result.put("formId", parent.getId());
        return result;
    }

    @Callable(rights={""})
    public Map<String, String> copyPage(String formId, String pageId) {
        HashMap<String, String> result = new HashMap<String, String>();
        Form parentForm = (Form)this._resolver.resolveById(formId);
        this._formDAO.checkHandleFormRight((AmetysObject)parentForm);
        FormPage originalPage = (FormPage)this._resolver.resolveById(pageId);
        String uniqueName = NameHelper.getUniqueAmetysObjectName((TraversableAmetysObject)parentForm, (String)originalPage.getName());
        FormPage cPage = originalPage.copyTo((ModifiableTraversableAmetysObject)parentForm, uniqueName);
        String copyTitle = this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.forms", "PLUGIN_FORMS_TREE_COPY_NAME_PREFIX")) + originalPage.getTitle();
        cPage.setTitle(copyTitle);
        cPage.deleteRule();
        parentForm.saveChanges();
        for (String epId : this._copyFormEP.getExtensionsIds()) {
            CopyFormUpdater copyFormUpdater = (CopyFormUpdater)this._copyFormEP.getExtension(epId);
            copyFormUpdater.updateFormPage(originalPage, cPage);
        }
        HashMap<String, Form> eventParams = new HashMap<String, Form>();
        eventParams.put("form", parentForm);
        this._observationManager.notify(new Event("form.modified", this._getCurrentUser(), eventParams));
        result.put("id", cPage.getId());
        result.put("formId", parentForm.getId());
        return result;
    }

    @Callable(rights={""})
    public Map<String, String> moveObject(String id, String oldParent, String newParent, long index) throws Exception {
        Form form;
        HashMap<String, String> result = new HashMap<String, String>();
        JCRAmetysObject aoMoved = (JCRAmetysObject)this._resolver.resolveById(id);
        this._formDAO.checkHandleFormRight((AmetysObject)aoMoved);
        DefaultTraversableAmetysObject newParentAO = (DefaultTraversableAmetysObject)this._resolver.resolveById(newParent);
        JCRAmetysObject brother = null;
        long size = newParentAO.getChildren().getSize();
        if (index != -1L && index < size) {
            brother = (JCRAmetysObject)newParentAO.getChildAt(index);
        } else if (index >= size) {
            brother = (JCRAmetysObject)newParentAO.getChildAt((long)(Math.toIntExact(size) - 1));
        }
        Form oldForm = this.getParentForm(aoMoved);
        if (oldForm != null) {
            result.put("oldFormId", oldForm.getId());
        }
        if (oldParent.equals(newParent) && brother != null) {
            node = aoMoved.getNode();
            name = "";
            try {
                name = index == size ? null : brother.getName();
                node.getParent().orderBefore(node.getName(), (String)name);
            }
            catch (RepositoryException e) {
                throw new AmetysRepositoryException(String.format("Unable to order AmetysOject '%s' before sibling '%s'", new Object[]{this, name}), (Throwable)e);
            }
        } else {
            node = aoMoved.getNode();
            name = node.getName();
            int localIndex = 2;
            while (newParentAO.hasChild((String)name)) {
                name = node.getName() + "-" + localIndex++;
            }
            node.getSession().move(node.getPath(), newParentAO.getNode().getPath() + "/" + (String)name);
            if (brother != null) {
                node.getParent().orderBefore(node.getName(), brother.getName());
            }
        }
        if (newParentAO.needsSave()) {
            newParentAO.saveChanges();
        }
        if ((form = this.getParentForm(aoMoved)) != null) {
            result.put("newFormId", form.getId());
            HashMap<String, Form> eventParams = new HashMap<String, Form>();
            eventParams.put("form", form);
            this._observationManager.notify(new Event("form.modified", this._getCurrentUser(), eventParams));
        }
        result.put("id", id);
        if (aoMoved instanceof FormPage) {
            result.put("type", "page");
        } else if (aoMoved instanceof FormQuestion) {
            result.put("type", "question");
            result.put("questionType", ((FormQuestion)aoMoved).getType().getId());
        }
        result.put("newParentId", newParentAO.getId());
        result.put("oldParentId", oldParent);
        return result;
    }

    @Callable(rights={"*"})
    public Map<String, Object> getPageProperties(String pageId) {
        try {
            FormPage page = (FormPage)this._resolver.resolveById(pageId);
            return this.getPageProperties(page, true);
        }
        catch (UnknownAmetysObjectException e) {
            this.getLogger().warn("Can't find page with id: {}. It probably has just been deleted", (Object)pageId, (Object)e);
            HashMap<String, Object> infos = new HashMap<String, Object>();
            infos.put("id", pageId);
            return infos;
        }
    }

    public Map<String, Object> getPageProperties(FormPage page, boolean withRights) {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        ArrayList<String> fullPath = new ArrayList<String>();
        fullPath.add(page.getTitle());
        AmetysObject node = page.getParent();
        fullPath.add(0, node.getName());
        infos.put("type", "page");
        infos.put("id", page.getId());
        infos.put("title", page.getTitle());
        infos.put("formId", page.getForm().getId());
        infos.put("hasEntries", !page.getForm().getEntries().isEmpty());
        infos.put("hasChildren", page.getQuestions().size() > 0);
        boolean isConfigured = !page.getQuestions().stream().anyMatch(q -> !q.getType().isQuestionConfigured((FormQuestion)((Object)q)));
        infos.put("isConfigured", isConfigured);
        if (withRights) {
            infos.put("rights", this._getUserRights(page));
        } else {
            infos.put("canWrite", this._formDAO.hasWriteRightOnForm(this._currentUserProvider.getUser(), (AmetysObject)page));
        }
        return infos;
    }

    protected Set<String> _getUserRights(FormPage page) {
        UserIdentity user = this._currentUserProvider.getUser();
        return this._rightManager.getUserRights(user, (Object)page);
    }

    @Callable(rights={"__READ_ACCESS"}, rightContext="right.assignment.context.formsdirectoryaccess", paramIndex=0)
    public List<String> getIdsOfPath(String id) {
        AmetysObject formComponent = this._resolver.resolveById(id);
        if (!(formComponent instanceof FormPage) && !(formComponent instanceof FormQuestion)) {
            throw new IllegalArgumentException("The given id is not a form component");
        }
        ArrayList<String> pathElements = new ArrayList<String>();
        AmetysObject current = formComponent.getParent();
        while (!(current instanceof Form)) {
            pathElements.add(0, current.getId());
            current = current.getParent();
        }
        return pathElements;
    }

    @Callable(rights={""})
    public List<Map<String, Object>> getChildPages(String formId) {
        Form form = (Form)this._resolver.resolveById(formId);
        this._formDAO.checkHandleFormRight((AmetysObject)form);
        return form.getPages().stream().map(p -> this.getPageProperties((FormPage)((Object)p), false)).toList();
    }

    protected Form getParentForm(JCRAmetysObject obj) {
        try {
            JCRAmetysObject currentAo = (JCRAmetysObject)obj.getParent();
            while (!(currentAo instanceof Form)) {
                currentAo = (JCRAmetysObject)currentAo.getParent();
            }
            if (currentAo instanceof Form) {
                return (Form)currentAo;
            }
        }
        catch (AmetysRepositoryException ametysRepositoryException) {
            // empty catch block
        }
        return null;
    }

    @Callable(rights={""})
    public boolean isLastPage(String id) {
        FormPage page = (FormPage)this._resolver.resolveById(id);
        this._formDAO.checkHandleFormRight((AmetysObject)page);
        Form form = page.getForm();
        List<FormPage> pages = form.getPages();
        FormPage lastPage = pages.get(pages.size() - 1);
        return id.equals(lastPage.getId());
    }

    @Callable(rights={""})
    public Map<String, Object> getBranches(String pageId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        FormPage page = (FormPage)this._resolver.resolveById(pageId);
        this._formDAO.checkHandleFormRight((AmetysObject)page);
        result.put("id", pageId);
        ArrayList<Map<String, Object>> questions = new ArrayList<Map<String, Object>>();
        List<FormQuestion> questionsAO = page.getQuestions();
        int index = 1;
        for (FormQuestion question : questionsAO) {
            ChoicesListQuestionType type;
            FormQuestionType formQuestionType = question.getType();
            if (formQuestionType instanceof ChoicesListQuestionType && !(type = (ChoicesListQuestionType)formQuestionType).getSourceType(question).remoteData() && !question.isModifiable()) {
                try {
                    questions.add(this._formQuestionDAO.getRules(question.getId(), index));
                }
                catch (Exception e) {
                    this.getLogger().error("an exception occured while getting rules for question " + question.getId());
                }
            }
            ++index;
        }
        result.put("questions", questions);
        result.put("rule", this.getRule(pageId));
        return result;
    }

    @Callable(rights={""})
    public Map<String, Object> getRule(String id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        FormPage page = (FormPage)this._resolver.resolveById(id);
        this._formDAO.checkHandleFormRight((AmetysObject)page);
        FormPageRule rule = page.getRule();
        if (rule != null) {
            result.put("type", rule.getType().name());
            String pageId = rule.getPageId();
            if (pageId != null) {
                try {
                    FormPage pageAO = (FormPage)this._resolver.resolveById(pageId);
                    result.put("page", pageId);
                    result.put("pageName", pageAO.getTitle());
                }
                catch (UnknownAmetysObjectException unknownAmetysObjectException) {}
            }
        } else {
            result = null;
        }
        return result;
    }

    @Callable(rights={""})
    public Map<String, Object> addRule(String id, String rule, String page) {
        FormPage formPage = (FormPage)this._resolver.resolveById(id);
        this._formDAO.checkHandleFormRight((AmetysObject)formPage);
        formPage.setRule(FormPageRule.PageRuleType.valueOf(rule), page);
        formPage.saveChanges();
        HashMap<String, Form> eventParams = new HashMap<String, Form>();
        eventParams.put("form", formPage.getForm());
        this._observationManager.notify(new Event("form.modified", this._getCurrentUser(), eventParams));
        return new HashMap<String, Object>();
    }

    @Callable(rights={""})
    public Map<String, Object> deleteRule(String id) {
        FormPage formPage = (FormPage)this._resolver.resolveById(id);
        this._formDAO.checkHandleFormRight((AmetysObject)formPage);
        formPage.deleteRule();
        formPage.saveChanges();
        HashMap<String, Form> eventParams = new HashMap<String, Form>();
        eventParams.put("form", formPage.getForm());
        this._observationManager.notify(new Event("form.modified", this._getCurrentUser(), eventParams));
        return new HashMap<String, Object>();
    }

    private void _removeReferencesFromPages(String pageId, Form parent) {
        List rulesWithPageId = parent.getPages().stream().map(page -> page.getRule()).filter(rule -> rule != null && pageId.equals(rule.getPageId())).collect(Collectors.toList());
        for (FormPageRule rule2 : rulesWithPageId) {
            rule2.remove();
        }
        parent.saveChanges();
    }

    private void _removeReferencesFromQuestions(String pageId, Form parent) {
        List rulesWithPageId = parent.getQuestions().stream().map(question -> question.getPageRules()).flatMap(Collection::stream).filter(rule -> rule != null && pageId.equals(rule.getPageId())).collect(Collectors.toList());
        for (FormPageRule rule2 : rulesWithPageId) {
            rule2.remove();
        }
        parent.saveChanges();
    }

    private void _removeReferencesFromQuestionsRules(FormPage page, Form parent) {
        for (FormQuestion questionToDelete : page.getQuestions()) {
            parent.deleteQuestionsRule(questionToDelete.getId());
        }
    }

    protected UserIdentity _getCurrentUser() {
        return this._currentUserProvider.getUser();
    }
}

